/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.util.UIHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class FrameRateMonitor {
    private static final int PAD = 3;
    private static final Font FONT = new Font("SansSerif", 0, 10);
    private static FontMetrics FONT_M;
    private long interval = 500L;
    private long started;
    private long stopAt;
    private int frames;
    private long totalStart = -1L;
    private int totalFrames;
    private StringBuffer msgBuf = new StringBuffer(80);
    private String msg;
    private int msgWidth;
    private int msgHeight;

    public void paint(Graphics graphics, int n, int n2) {
        graphics.setFont(FONT);
        if (FONT_M == null) {
            FONT_M = graphics.getFontMetrics();
        }
        this.tick();
        graphics.setColor(Color.yellow);
        graphics.fillRect(n, n2, this.msgWidth + 6, this.msgHeight + 6);
        graphics.setColor(Color.black);
        graphics.drawString(this.msgBuf.toString(), n + 3, n2 + 3 + FONT_M.getAscent());
    }

    private void tick() {
        long l = System.currentTimeMillis();
        if (this.totalStart < 0L) {
            this.totalStart = l;
        }
        if (l >= this.stopAt) {
            long l2 = l - this.started;
            long l3 = l - this.totalStart;
            if (l3 == 0L) {
                l3 = Integer.MAX_VALUE;
            }
            this.setFps((int)((long)(this.frames * 1000000) / l2), (int)((long)(this.totalFrames * 10000) / l3) * 100);
            this.start();
        }
        ++this.totalFrames;
        ++this.frames;
    }

    private void setFps(int n, int n2) {
        this.msgBuf.setLength(0);
        this.msgBuf.append("fps: ");
        this.msgBuf.append(UIHelper.formatFixed(n, 2));
        this.msgBuf.append("  avg: ");
        this.msgBuf.append(UIHelper.formatFixed(n2, 1));
        this.msg = this.msgBuf.toString();
        this.msgWidth = FONT_M.stringWidth(this.msg);
        this.msgHeight = FONT_M.getHeight();
    }

    private void start() {
        this.started = System.currentTimeMillis();
        this.stopAt = this.started + this.interval;
        this.frames = 0;
    }
}

