/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.html.HTMLHelpScreen;
import elgato.infrastructure.html.HTMLManager;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.ModeScreen;
import elgato.infrastructure.mainScreens.SaveDataMessageScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.mainScreens.StateRecaller;
import elgato.infrastructure.mainScreens.StateSaver;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ActionListener;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.scriptedTests.MeasurementResults;
import elgato.infrastructure.scriptedTests.SoftwareButtonFactory;
import elgato.infrastructure.systemFunctions.SystemScreen;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Platform;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.wheel.ScrollWheelManager;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;

public class GlobalKeyManager
extends KeyAdapter {
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$mainScreens$GlobalKeyManager == null ? (class$elgato$infrastructure$mainScreens$GlobalKeyManager = GlobalKeyManager.class$("elgato.infrastructure.mainScreens.GlobalKeyManager")) : class$elgato$infrastructure$mainScreens$GlobalKeyManager);
    private static final char NO_KEY = '\u0000';
    private static final int UP_ARROW = 104;
    private static final int DOWN_ARROW = 98;
    private static final int[] displayBrightnessLevels = new int[]{0, 50, 120, 180, 255};
    private static boolean debugKeyTiming = "true".equals(System.getProperty("keyTiming"));
    protected static long lastKeyUndefinedStartMillis = 0L;
    protected static int keyPressInProcessCount = 0;
    protected static long lastKeyPressInProcessCountChangeMs = System.currentTimeMillis();
    private static GlobalKeyManager instance;
    private ScreenManager screenManager;
    private MenuPanel leftMenu;
    private MenuPanel rightMenu;
    private boolean localEnabled = true;
    private Vector modeButtonListeners = new Vector();
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$GlobalKeyManager;

    public static KeyEvent makeKeyEvent(Component component, int n) {
        if (n >= 48 && n <= 57) {
            return GlobalKeyManager.makeKeyEvent(component, n, GlobalKeyManager.getDigit(n - 48));
        }
        return GlobalKeyManager.makeKeyEvent(component, n, '\u0000');
    }

    public static KeyEvent makeDecimalKeyEvent(Component component) {
        return GlobalKeyManager.makeKeyEvent(component, 110, '.');
    }

    public static KeyEvent makeKeyEvent(Component component, int n, char c) {
        return new KeyEvent(component, 0, 0L, 0, n, c);
    }

    private static char getDigit(int n) {
        return (char)(48 + n);
    }

    public static KeyEvent makeKeyEvent(Component component, int n, int n2) {
        return new KeyEvent(component, 0, 0L, n2, n, '\u0000');
    }

    public void simulateKey(Component component, int n) {
        instance.keyPressed(GlobalKeyManager.makeKeyEvent(component, n));
        instance.keyReleased(GlobalKeyManager.makeKeyEvent(component, n));
    }

    public static void simulateKey(Component component, int n, char c) {
        instance.keyPressed(GlobalKeyManager.makeKeyEvent(component, n, c));
        instance.keyReleased(GlobalKeyManager.makeKeyEvent(component, n, c));
    }

    public static void simulateShiftKey(Component component, int n) {
        instance.keyPressed(GlobalKeyManager.makeKeyEvent(component, 16, 1));
        instance.keyPressed(GlobalKeyManager.makeKeyEvent(component, n, 1));
        instance.keyReleased(GlobalKeyManager.makeKeyEvent(component, 16, 1));
    }

    public static void simulateCtrlKey(Component component, int n) {
        instance.keyPressed(GlobalKeyManager.makeKeyEvent(component, 17, 2));
        instance.keyPressed(GlobalKeyManager.makeKeyEvent(component, n, 2));
        instance.keyReleased(GlobalKeyManager.makeKeyEvent(component, 17, 2));
    }

    public static GlobalKeyManager instance() {
        return instance;
    }

    public static GlobalKeyManager makeInstance(ScreenManager screenManager) {
        instance = new GlobalKeyManager(screenManager);
        return instance;
    }

    public static void registerInstance(GlobalKeyManager globalKeyManager) {
        instance = globalKeyManager;
    }

    public static void deregisterTestInstance() {
        instance = null;
    }

    protected GlobalKeyManager(ScreenManager screenManager) {
        this.screenManager = screenManager;
        this.leftMenu = screenManager.getLeftMenuPanel();
        this.rightMenu = screenManager.getRightMenuPanel();
    }

    public void keyPressed(KeyEvent keyEvent) {
        long l = System.currentTimeMillis();
        this.startKeyPressProcessing(keyEvent);
        if (logger.isDebugEnabled()) {
            logger.debug("keyEvent=" + keyEvent + ", keys in process=" + keyPressInProcessCount);
        }
        if (keyEvent.getKeyCode() != keyEvent.getKeyCode() && logger.isDebugEnabled()) {
            logger.debug("invalid key released. expected: " + this.toString(keyEvent) + " got: " + this.toString(keyEvent));
        }
        if (keyEvent.getModifiers() != keyEvent.getModifiers()) {
            if (logger.isDebugEnabled()) {
                logger.debug("invalid modifier released. expected: " + this.toString(keyEvent) + " got: " + this.toString(keyEvent));
            }
            GlobalKeyManager.decrementKeyPressInProcessCount();
            return;
        }
        if (this.isModifierKey(keyEvent = this.preprocessKeyEvent(keyEvent))) {
            lastKeyUndefinedStartMillis = l;
        }
        this.processKeyPress(keyEvent);
        this.completeKeyPressProcessing(keyEvent, l);
    }

    protected void processKeyPress(KeyEvent keyEvent) {
        if (RuntimeConfiguration.isEmbedded() && this.processSoftkeyPress(keyEvent)) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 72 && RuntimeConfiguration.isEmbedded() || n == 72 && lastKeyUndefinedStartMillis != 0L) {
            this.handleHelpKeyPress();
        } else if (this.isPresetKey(keyEvent)) {
            this.handlePresetKeyPress();
        } else if (this.isBacklightPress(keyEvent)) {
            this.handleBackLightKeyPress();
        } else if (this.isSaveDataKeyPress(keyEvent)) {
            this.handleSaveDataKeyPress();
        } else if (GlobalKeyManager.isEscapeLocalKey(keyEvent) && RuntimeConfiguration.isEmbedded() || GlobalKeyManager.isEscapeLocalKey(keyEvent) && lastKeyUndefinedStartMillis != 0L) {
            this.handleEscapeLocalKeyPress();
        } else if (this.isModeKeyPress(n, keyEvent)) {
            this.handleModeKeyPress();
        } else if (this.isSaveStateKey(keyEvent)) {
            this.handleSaveStateKeyPress();
        } else if (this.isPresetKey(keyEvent)) {
            this.handlePresetKeyPress();
        } else if (this.isSystemKeyPress(keyEvent)) {
            this.handleSystemKeyPress();
        } else if (this.isRecallStateKey(keyEvent)) {
            this.handleRecallStateKeyPress();
        } else if (this.isPrintScreenKey(keyEvent)) {
            this.handlePrintScreenKeyPress();
        } else if (keyEvent.getKeyCode() == 38) {
            this.handleUpArrowKeyPress(keyEvent);
        } else if (keyEvent.getKeyCode() == 40) {
            this.handleDownArrowKeyPress(keyEvent);
        } else if (this.isBackSpace(keyEvent)) {
            this.handleBackSpaceKeyPress(keyEvent);
        } else {
            this.handleUnhandledKeyPress(keyEvent);
        }
    }

    protected void startKeyPressProcessing(KeyEvent keyEvent) {
        if (!Platform.hasKeyEventFilter() || keyPressInProcessCount == 0) {
            GlobalKeyManager.incrementKeyPressInProcessCount(keyEvent);
        }
    }

    protected void completeKeyPressProcessing(KeyEvent keyEvent, long l) {
        if (!this.isModifierKey(keyEvent)) {
            if (GlobalKeyManager.doDebugKeyTiming() && logger.isDebugEnabled()) {
                logger.keyPress("   queue: keys in process=" + keyPressInProcessCount + ", key=" + KeyEvent.getKeyText(keyEvent.getKeyCode()));
            }
            EventDispatchThread.invokeLater(new KeyPressCompleteRunnable(lastKeyUndefinedStartMillis, l, keyEvent), "GlobalKeyManager.keyPressed");
            lastKeyUndefinedStartMillis = 0L;
        } else {
            GlobalKeyManager.decrementKeyPressInProcessCount();
            if (GlobalKeyManager.doDebugKeyTiming()) {
                logger.keyPress("mod done: keys in process=" + keyPressInProcessCount + ", modifier=" + KeyEvent.getKeyModifiersText(keyEvent.getModifiers()));
            }
        }
    }

    private boolean isModeKeyPress(int n, KeyEvent keyEvent) {
        return n == 112 && keyEvent.isControlDown() || n == 92;
    }

    private boolean isSaveDataKeyPress(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 113 && keyEvent.isControlDown();
    }

    protected KeyEvent preprocessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 104 && keyEvent.isShiftDown() || keyEvent.getKeyCode() == 38) {
            return new KeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), 0, 38, '\u0000');
        }
        if (keyEvent.getKeyCode() == 98 && keyEvent.isShiftDown() || keyEvent.getKeyCode() == 40) {
            return new KeyEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), 0, 40, '\u0000');
        }
        return keyEvent;
    }

    public static boolean isEscapeLocalKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 76;
    }

    protected void handleBackSpaceKeyPress(KeyEvent keyEvent) {
        this.handleUnhandledKeyPress(keyEvent);
    }

    protected boolean isBackSpace(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 8;
    }

    protected void handleBackLightKeyPress() {
        int n = Platform.getDisplayBrightness();
        int n2 = 0;
        for (int i = 0; i < displayBrightnessLevels.length; ++i) {
            if (displayBrightnessLevels[i] <= n) continue;
            n2 = i;
            break;
        }
        Platform.setDisplayBrightness(displayBrightnessLevels[n2]);
    }

    protected boolean isBacklightPress(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 119;
    }

    protected void handleUpArrowKeyPress(KeyEvent keyEvent) {
        this.handleUnhandledKeyPress(keyEvent);
    }

    protected void handleDownArrowKeyPress(KeyEvent keyEvent) {
        this.handleUnhandledKeyPress(keyEvent);
    }

    protected void handlePrintScreenKeyPress() {
        this.screenManager.printScreen();
    }

    protected void handleSaveDataKeyPress() {
        try {
            Screen screen = this.screenManager.getCurrentScreen();
            if (screen instanceof MeasurementScreen) {
                SaveDataMessageScreen saveDataMessageScreen = new SaveDataMessageScreen(TextMessage.MEDIA_DATA_SAVE_PENDING, true, 4, (MeasurementScreen)screen);
                this.screenManager.pushScreen(saveDataMessageScreen);
                return;
            }
            Vector vector = this.screenManager.getScreenStack();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                screen = (Screen)vector.elementAt(i);
                if (!(screen instanceof MeasurementScreen)) continue;
                SaveDataMessageScreen saveDataMessageScreen = new SaveDataMessageScreen(TextMessage.MEDIA_DATA_SAVE_PENDING, true, 4, (MeasurementScreen)screen);
                this.screenManager.pushScreen(saveDataMessageScreen);
                return;
            }
            MessageScreen messageScreen = new MessageScreen(TextMessage.MEDIA_DATA_SAVE_NOT_SUPPORTED, true, 0, 10);
            this.screenManager.pushScreen(messageScreen);
        }
        catch (Exception exception) {
            logger.error("can not create file/ save data:", exception);
        }
    }

    private boolean isSystemKeyPress(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 115 && keyEvent.isControlDown() || keyEvent.getKeyCode() == 46 && keyEvent.isControlDown();
    }

    private boolean isPrintScreenKey(KeyEvent keyEvent) {
        if (RuntimeConfiguration.isEmbedded()) {
            return keyEvent.getKeyCode() == 116 && keyEvent.isControlDown() || keyEvent.getKeyCode() == 80;
        }
        return keyEvent.getKeyCode() == 116 && keyEvent.isControlDown();
    }

    protected void handleRecallStateKeyPress() {
        if (!StateRecaller.isActive) {
            if (StateSaver.isActive) {
                this.screenManager.popScreen();
            }
            this.showRecallScreen();
        }
    }

    protected void showRecallScreen() {
        StateRecaller.showRecallScreen(this.screenManager);
    }

    private boolean isPresetKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 120;
    }

    protected void handleSaveStateKeyPress() {
        if (!StateSaver.isActive) {
            if (StateRecaller.isActive) {
                this.screenManager.popScreen();
            }
            this.showSaveStateScreen();
        }
    }

    protected void showSaveStateScreen() {
        new StateSaver(this.screenManager);
    }

    private boolean isRecallStateKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        return n == 117 && keyEvent.isControlDown();
    }

    protected boolean isSaveStateKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 114 && keyEvent.isControlDown();
    }

    protected boolean isModifierKey(KeyEvent keyEvent) {
        if (RuntimeConfiguration.isEmbedded()) {
            return keyEvent.getKeyCode() == 0 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 17;
        }
        return keyEvent.getKeyCode() == 0 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 17;
    }

    public boolean processSoftkeyPress(KeyEvent keyEvent) {
        char c = Character.toLowerCase(keyEvent.getKeyChar());
        if (c >= 'a' && c <= 'g') {
            this.handleAlphaKeyPress(keyEvent, c);
            return true;
        }
        if (this.isSoftkeyFunctionKey(keyEvent)) {
            this.invokeFunctionKey(keyEvent);
            return true;
        }
        return false;
    }

    protected void handleUnhandledKeyPress(KeyEvent keyEvent) {
        this.screenManager.keyPressed(keyEvent);
    }

    protected void handleModeKeyPress() {
        HTMLManager.resetCacheSession();
        if (this.localEnabled) {
            this.screenManager.loadScreen(new ModeScreen());
        }
        Enumeration enumeration = this.modeButtonListeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed();
        }
    }

    protected void handleEscapeLocalKeyPress() {
        MeasurementFactory.instance().getCommandProcessor().send("local");
    }

    protected void handleSystemKeyPress() {
        if (!SystemScreen.isActive()) {
            this.screenManager.pushScreen(new SystemScreen());
        }
    }

    protected void handlePresetKeyPress() {
        Command command = this.createCommand("recall");
        MeasurementFactory.instance().getCommandProcessor().send(command);
        SoftwareButtonFactory.resetLastTestAccessed();
        MeasurementResults.getInstance().clear();
        this.screenManager.handlePreset();
        this.screenManager.loadScreen(new ModeScreen());
    }

    protected void handleHelpKeyPress() {
        if (logger.isDebugEnabled()) {
            logger.debug("handleHelpKeyPress() active=" + HTMLHelpScreen.isHelpActive() + " enabled=" + HTMLHelpScreen.isHelpEnabled());
        }
        if (!HTMLHelpScreen.isHelpActive() && HTMLHelpScreen.isHelpEnabled()) {
            this.screenManager.pushScreen(new HTMLHelpScreen(this.screenManager));
        }
    }

    private void handleAlphaKeyPress(KeyEvent keyEvent, char c) {
        if (keyEvent.getKeyChar() < 'a') {
            this.handleSoftkeyPress(true, c - 97);
        } else {
            this.handleSoftkeyPress(false, c - 97);
        }
    }

    protected void handleSoftkeyPress(boolean bl, int n) {
        MenuPanel menuPanel = bl ? this.rightMenu : this.leftMenu;
        menuPanel.invokeButton(n);
    }

    private void invokeFunctionKey(KeyEvent keyEvent) {
        this.handleSoftkeyPress(keyEvent.isShiftDown(), keyEvent.getKeyCode() - 112);
    }

    public boolean isSoftkeyFunctionKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = 11;
        boolean bl = (keyEvent.getModifiers() & n2) == 1 || (keyEvent.getModifiers() & n2) == 0;
        return n >= 112 && n <= 118 && bl;
    }

    Command createCommand(String string) {
        return new Command(string);
    }

    public void setLocalEnabled(boolean bl) {
        this.localEnabled = bl;
    }

    protected ScreenManager getScreenManager() {
        return this.screenManager;
    }

    private String toString(KeyEvent keyEvent) {
        return "keyChar: " + keyEvent.getKeyChar() + " keyCode: " + keyEvent.getKeyCode() + " modifiers: " + KeyEvent.getKeyModifiersText(keyEvent.getModifiers());
    }

    public static boolean doDebugKeyTiming() {
        return debugKeyTiming;
    }

    public static synchronized void incrementKeyPressInProcessCount(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        if (n == 401) {
            ++keyPressInProcessCount;
            lastKeyPressInProcessCountChangeMs = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("GlobalKeyManager.incrementKeyPressInProcessCount() c=" + keyPressInProcessCount);
            }
            if (debugKeyTiming) {
                String string = KeyEvent.getKeyModifiersText(keyEvent.getModifiers());
                String string2 = string == null || string.length() < 1 ? "" : string + "-";
                logger.keyPress("   press: keys in process=" + keyPressInProcessCount + ", key=" + string2 + KeyEvent.getKeyText(keyEvent.getKeyCode()) + ", " + Thread.currentThread().toString());
            }
        }
    }

    static synchronized void decrementKeyPressInProcessCount() {
        --keyPressInProcessCount;
        lastKeyPressInProcessCountChangeMs = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("GlobalKeyManager.decrementKeyPressInProcessCount() c=" + keyPressInProcessCount);
        }
        if (keyPressInProcessCount < 0) {
            keyPressInProcessCount = 0;
        }
    }

    public static boolean isKeyPressInProcess() {
        if (keyPressInProcessCount > 0) {
            long l = System.currentTimeMillis() - lastKeyPressInProcessCountChangeMs;
            if (l < 5000L) {
                return true;
            }
            GlobalKeyManager.keyPressInProcessTimeout(l);
        }
        return ScrollWheelManager.isWheelMoveInProcess();
    }

    private static synchronized void keyPressInProcessTimeout(long l) {
        logger.error("GlobalKeyManager.keyPressInProcessTimeout() time since last change=" + l + " ms, resetting count=0");
        keyPressInProcessCount = 0;
        lastKeyPressInProcessCountChangeMs = System.currentTimeMillis();
    }

    public void registerModeButtonListener(ActionListener actionListener) {
        this.modeButtonListeners.addElement(actionListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class KeyPressCompleteRunnable
    implements Runnable {
        private final long keyPressStartMillis;
        private final long keyModifierStartMillis;
        private String keyText;
        private String keyModifierText;

        public KeyPressCompleteRunnable(long l, long l2, KeyEvent keyEvent) {
            this.keyModifierStartMillis = l;
            this.keyPressStartMillis = l2;
            this.keyText = KeyEvent.getKeyText(keyEvent.getKeyCode());
            this.keyModifierText = KeyEvent.getKeyModifiersText(keyEvent.getModifiers());
        }

        public void run() {
            GlobalKeyManager.decrementKeyPressInProcessCount();
            if (GlobalKeyManager.doDebugKeyTiming()) {
                long l = System.currentTimeMillis();
                long l2 = l - this.keyModifierStartMillis;
                long l3 = l - this.keyPressStartMillis;
                String string = this.keyModifierText == null || this.keyModifierText.length() == 0 || this.keyModifierText.equals(this.keyText) || this.keyText.equals("Control") ? this.keyText : this.keyModifierText + "-" + this.keyText;
                String string2 = this.keyModifierStartMillis == 0L ? "" : ", elapsed from modifier=" + l2;
                logger.keyPress("complete: keys in process=" + keyPressInProcessCount + ", elapsed=" + l3 + string2 + ", key=" + string);
            }
        }
    }
}

