/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.gui.ModelTypeMgr;
import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.TrimodeActuatorButton;
import elgato.infrastructure.analyzer.Analyzer;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.html.HtmlTable;
import elgato.infrastructure.mainScreens.GenericMessageScreen;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.SaveDataUnsupportedException;
import elgato.infrastructure.mainScreens.Saveable;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.measurement.MeasurementReader;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.StateButton;
import elgato.infrastructure.menu.StateButtonGroup;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.OptionSecurity;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.text.DecimalFormat;

public abstract class MeasurementScreen
extends Screen
implements OptionSecurity {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$mainScreens$MeasurementScreen == null ? (class$elgato$infrastructure$mainScreens$MeasurementScreen = MeasurementScreen.class$("elgato.infrastructure.mainScreens.MeasurementScreen")) : class$elgato$infrastructure$mainScreens$MeasurementScreen);
    private final CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
    private Actuator averagingState;
    private FreqChanUnitsHelper freqChanUnitsHelper;
    public static MeasurementScreen pushedScreen = null;
    protected final String tab = "    ";
    protected static final int TEST_NAME_WIDTH = 29;
    protected static final int MEASURED_VALUE_WIDTH = 21;
    protected static final int LOWER_LIMIT_WIDTH = 13;
    protected static final int UPPER_LIMIT_WIDTH = 13;
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$MeasurementScreen;

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.setupAnalyzer();
        screenManager.installLeftMenu(this.buildLeftMenu());
        this.installAnalyzer(screenManager);
        this.commandProcessor.setActive(this.getMeasurementName());
        this.addMeasurementListeners();
        this.sendInitialGetCommands();
        DisplayGlobalMeasurementSettings.instance().refresh();
        this.refreshMeasurementSettings();
        this.pressHomeButton();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        this.commandProcessor.setInactive();
        if (this.freqChanUnitsHelper != null) {
            this.freqChanUnitsHelper.remove();
            this.freqChanUnitsHelper = null;
        }
        this.removeMeasurementListeners();
        if (this.getAnalyzer() != null) {
            this.getAnalyzer().dispose();
        }
        this.averagingState = null;
        super.uninstallScreen(screenManager);
    }

    protected void refreshMeasurementSettings() {
    }

    protected void installAnalyzer(ScreenManager screenManager) {
        screenManager.installDisplay(this.getAnalyzerPanel());
    }

    public void setupFreqChanUnitsListener(Menu menu, int n) {
        this.freqChanUnitsHelper = new FreqChanUnitsHelper(menu, n);
        this.freqChanUnitsHelper.add();
        this.freqChanUnitsHelper.installProperStepButton();
    }

    protected void addMeasurementListeners() {
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener((MeasurementListener)((Object)this.getAnalyzerPanel()), this.getMeasurementClass());
    }

    protected void removeMeasurementListeners() {
        MeasurementReader measurementReader = MeasurementFactory.instance().getMeasurementReader();
        measurementReader.removeMeasurementListener((MeasurementListener)((Object)this.getAnalyzerPanel()), this.getMeasurementClass());
    }

    public String getTopic() {
        return this.getMeasurementName();
    }

    public String getDisplayTopic() {
        return "display." + this.getTopic();
    }

    private void sendInitialGetCommands() {
        Command[] commandArray = this.getInitialGetCommands();
        for (int i = 0; i < commandArray.length; ++i) {
            this.commandProcessor.send(commandArray[i]);
        }
    }

    public MenuButton createAverageSweepButton(LongActuator longActuator, ListActuator listActuator) {
        return this.buildAverageSweepButton(longActuator, listActuator);
    }

    private MenuButton buildAverageSweepButton(LongActuator longActuator, ListActuator listActuator) {
        if (this.averagingState != null) {
            logger.error("should not build another button or listener will be added too many times, more that one", new Exception("Stack trace"));
        }
        this.averagingState = listActuator;
        StateButtonGroup stateButtonGroup = new StateButtonGroup();
        StateButton stateButton = new StateButton(Text.Continuous, this.getContextString("averageSweepWithCR.averageSweepContinuous"), stateButtonGroup, new Command("resume"));
        StateButton stateButton2 = new StateButton(Text.Single, this.getContextString("averageSweepWithCR.averageSweepSingle"), stateButtonGroup, new Command("single"));
        RestartButton restartButton = new RestartButton(Text.Restart, this.getContextString("averageSweepWithCR.averageSweepRestart"));
        stateButtonGroup.selectButton(stateButton);
        ActuatorEditor actuatorEditor = this.createNumAveragesButton(longActuator);
        if (ModelTypeMgr.instance().getModelType() == 0) {
            return new SimpleMenuButton(Text.Average_slash_n_Sweep, this.getContextString("averageSweepWithCR"), new Menu(Text.Average_slash_Sweep, new MenuItem[]{stateButton, stateButton2, restartButton, new ActuatorSubMenuButton(listActuator, this.getContextString("averageSweepWithCR.averageSweepAveraging"), true, this.getListenerBaseName()), actuatorEditor}, 3));
        }
        return new SubMenuButton(Text.Average_slash_n_Sweep, this.getContextString("averageSweepWithCR"), new Menu(Text.Average_slash_Sweep, new MenuItem[]{stateButton, stateButton2, restartButton, new ActuatorSubMenuButton(listActuator, this.getContextString("averageSweepWithCR.averageSweepAveraging"), true, this.getListenerBaseName()), actuatorEditor}, 3));
    }

    private ActuatorEditor createNumAveragesButton(LongActuator longActuator) {
        return new ActuatorEditor(longActuator, this.getContextString("averageSweepWithCR.averageSweepAverage"), this.getListenerBaseName() + ".numAveragesButton");
    }

    public MultiStateActuatorButton createInterferenceRejectionButton(ListActuator listActuator) {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(listActuator, this.getContextString("interference.rejection"), this.getListenerBaseName());
        return multiStateActuatorButton;
    }

    public TraceAnalyzer getTraceAnalyzer() {
        return (TraceAnalyzer)this.getAnalyzer();
    }

    protected abstract Menu buildLeftMenu();

    protected abstract Command[] getInitialGetCommands();

    protected abstract String getMeasurementName();

    protected abstract void setupAnalyzer();

    public Analyzer getAnalyzer() {
        return (Analyzer)((Object)this.getAnalyzerPanel());
    }

    protected abstract Component getAnalyzerPanel();

    protected abstract Class getMeasurementClass();

    public void saveData(PrintWriter printWriter) throws SaveDataUnsupportedException {
        if (!(this.getAnalyzer() instanceof Saveable)) {
            throw new SaveDataUnsupportedException();
        }
        ((Saveable)((Object)this.getAnalyzer())).saveData(printWriter);
    }

    public String optionName() {
        return this.getMeasurementName();
    }

    public static MenuItem createFreqChanUnitsButton(String string) {
        return new MultiStateActuatorButton(DisplayGlobalMeasurementSettings.instance().getChanFreqUnits(), "units", string);
    }

    public static MenuItem createLossButton(LongActuator longActuator, LongActuator longActuator2, ListActuator listActuator, String string, String string2) {
        TrimodeActuatorButton trimodeActuatorButton = new TrimodeActuatorButton((ValueListInterface)listActuator, string, new ValueInterface[]{longActuator, longActuator2}, string2);
        trimodeActuatorButton.setReadOnlyValueIndex(1);
        return trimodeActuatorButton;
    }

    public MultiStateActuatorButton createPowerDetectorButton(ListActuator listActuator) {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(listActuator, this.getContextString("powerDetector"), this.getListenerBaseName());
        String string = MeasurementFactory.instance().getComponentRevision("RcvrFPGARev");
        boolean bl = string != null && UIHelper.compareVersionNumbers(string, "0.3") >= 0;
        multiStateActuatorButton.setEnabled(bl);
        return multiStateActuatorButton;
    }

    protected MenuItem createFrequencyStepButton() {
        return new ActuatorEditor(DisplayGlobalMeasurementSettings.instance().getFrequencyStep(), this.getContextString("frequencyChannel.cfStep"), this.getListenerBaseName() + ".freqStepButton");
    }

    public abstract String getTestResults(ScreenManager var1, String var2);

    protected static String addPassFail(double d, double d2, double d3) {
        if (d3 != Double.MIN_VALUE && d < d3 || d2 != Double.MAX_VALUE && d > d2) {
            return Text.FAIL;
        }
        return Text.PASS;
    }

    protected static String format(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    protected static String formatResultLine(String string, String string2, String string3, String string4, String string5) {
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.addRow(new String[]{string, string2, string3, string4, string5});
        return htmlTable.getRow(0);
    }

    public static String createResultLine(double d, double d2, double d3, String string, String string2) {
        String string3 = "0.00";
        String string4 = string.endsWith("sf") ? MeasurementScreen.format(d, "0") + " " + string2 : MeasurementScreen.format(d /= 1000.0, string3) + " " + string2;
        String string5 = MeasurementScreen.format(d2, string3);
        String string6 = MeasurementScreen.format(d3, string3);
        if (d2 == Double.POSITIVE_INFINITY) {
            string5 = "";
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            string6 = "";
        }
        return MeasurementScreen.formatResultLine(string, string4, string6, string5, MeasurementScreen.addPassFail(d, d2, d3));
    }

    public void displayErrorMessageScreen(ScreenManager screenManager) {
        GenericMessageScreen genericMessageScreen = new GenericMessageScreen(TextMessage.MEDIA_DATA_SAVE_FAILURE, true, 4);
        screenManager.pushScreen(genericMessageScreen);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RestartButton
    extends PushButton
    implements ActionListener {
        public RestartButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MeasurementFactory.instance().getCommandProcessor().set(MeasurementScreen.this.getMeasurementName(), "avgType", 99L);
        }
    }

    private class FreqChanUnitsHelper {
        private final Menu freqChanMenu;
        private final MenuItem freqStepButton;
        private final MenuItem chanStepButton;
        private final int stepButtonIndex;
        private final ValueListener freqChanUnitsListener = new ValueListener(this){
            private final String listenerName;
            private final /* synthetic */ FreqChanUnitsHelper this$1;
            {
                this.this$1 = freqChanUnitsHelper;
                this.listenerName = FreqChanUnitsHelper.access$000(this.this$1).getListenerBaseName() + ".freqChanUnitsListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                EventDispatchThread.runOnEventThread("freqChanUnitsListener", new Runnable(this){
                    private final /* synthetic */ 1 this$2;
                    {
                        this.this$2 = var1_1;
                    }

                    public void run() {
                        1.access$100(this.this$2).installProperStepButton();
                    }
                });
                FreqChanUnitsHelper.access$000(this.this$1).getScreenManager().getRightMenuPanel().repaint();
            }

            static /* synthetic */ FreqChanUnitsHelper access$100(1 var0) {
                return var0.this$1;
            }
        };

        public FreqChanUnitsHelper(Menu menu, int n) {
            DisplayGlobalMeasurementSettings displayGlobalMeasurementSettings = DisplayGlobalMeasurementSettings.instance();
            this.freqChanMenu = menu;
            this.stepButtonIndex = n;
            this.chanStepButton = new ActuatorEditor(displayGlobalMeasurementSettings.getChannelStep(), MeasurementScreen.this.getContextString("frequencyChannel.cfStep"), MeasurementScreen.this.getListenerBaseName() + ".chanStepButton");
            this.freqStepButton = MeasurementScreen.this.createFrequencyStepButton();
        }

        public void add() {
            DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().addValueListener(this.freqChanUnitsListener);
        }

        public void remove() {
            DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().removeValueListener(this.freqChanUnitsListener);
        }

        public void installProperStepButton() {
            DisplayGlobalMeasurementSettings displayGlobalMeasurementSettings = DisplayGlobalMeasurementSettings.instance();
            if (displayGlobalMeasurementSettings.isChannelSelected()) {
                this.freqChanMenu.setMenuItem(this.chanStepButton, this.stepButtonIndex);
            } else {
                this.freqChanMenu.setMenuItem(this.freqStepButton, this.stepButtonIndex);
            }
        }

        static /* synthetic */ MeasurementScreen access$000(FreqChanUnitsHelper freqChanUnitsHelper) {
            return freqChanUnitsHelper.MeasurementScreen.this;
        }
    }
}

