/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.FileSelectButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.SystemProcess;
import elgato.infrastructure.util.TextMessage;
import java.io.File;

public abstract class MediaMessageScreen
extends MessageScreen
implements Runnable,
AlphaEditScreen.AlphaEditScreenExitListener {
    public static final int MODE_PENDING = 0;
    public static final int MODE_PROMPT = 1;
    public static final int MODE_ABORT = 2;
    public static final int MODE_END = 3;
    public static final int MODE_APPEND = 4;
    public static final int MODE_PROMPT_FOR_FILENAME = 5;
    public static final int MODE_FAILURE = 6;
    int mode = 0;
    private String promptMessage = "";
    private ScreenManager sm = null;
    private String pendingMessage = "";
    private String promptedFilenameKey;
    private String determineFilenameDir = "";

    public MediaMessageScreen(String string, boolean bl, int n, String string2) {
        super(string, bl, n);
        this.pendingMessage = string;
        this.promptMessage = string2;
    }

    public String getUnqualifiedFilename(String string) {
        try {
            int n = string.lastIndexOf(File.separator);
            if (n != -1) {
                return string.substring(++n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected boolean fileExists(String string) {
        String[] stringArray = this.getFileList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void alphaEditScreenExit(int n, String string) {
        if (n == 0) {
            String string2 = SystemMeasurementSettings.instance().getFilename(this.promptedFilenameKey);
            String string3 = this.determineFilenameDir + File.separator + string2;
            if (this.fileExists(string2)) {
                this.getScreenManager().pushScreen(this.createConfirmationScreen(string2, string3));
            } else {
                this.saveToMedia(string3);
            }
        } else {
            this.abortSave();
        }
    }

    void abortSave() {
        this.setMode(2);
        this.setExitMessageScreen(null);
    }

    protected MessageScreen createConfirmationScreen(String string, final String string2) {
        MessageScreen messageScreen = new MessageScreen(this.getConfirmationText(), true, 3);
        messageScreen.getHTMLRenderer().addVariableReplacment("$SETTINGS$", string);
        messageScreen.addListener(new MessageScreenListener(){

            public void messageScreenExit(int n) {
                if (n == 2) {
                    MediaMessageScreen.this.saveToMedia(string2);
                } else if (n == 3 || n == 1) {
                    MediaMessageScreen.this.abortSave();
                } else {
                    System.out.println("exitCode: " + n);
                }
            }
        });
        return messageScreen;
    }

    void saveToMedia(String string) {
        Thread thread = new Thread((Runnable)this, ":" + string);
        thread.start();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.sm = screenManager;
        Thread thread = new Thread((Runnable)this, "firstAttempt");
        thread.start();
    }

    public SystemProcess determineFilename(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        boolean bl;
        SystemProcess systemProcess = new SystemProcess("determineFilename()");
        this.determineFilenameDir = string;
        boolean bl2 = false;
        this.promptedFilenameKey = string3;
        int n2 = SystemMeasurementSettings.instance().getInt(string2);
        if (n2 == 2) {
            systemProcess.put("promptForFilename", "");
            this.setMode(5);
            final FileSelectButton fileSelectButton = this.createFilenameButton(this);
            EventDispatchThread.invokeLater(new Runnable(){

                public void run() {
                    fileSelectButton.press();
                }
            }, "MediaMessageScreen.determineFilename");
            systemProcess.setExitCode(0);
            return systemProcess;
        }
        boolean bl3 = bl = SystemMeasurementSettings.instance().getInt(string2) == 1;
        if (bl) {
            if (string5 == null) {
                string5 = "file";
            }
            systemProcess.setExitCode(0);
            systemProcess.put("filename", string + File.separator + string5 + "_" + FileSystemHelper.getInstance().getTimestamp() + string6);
            return systemProcess;
        }
        String string7 = SystemMeasurementSettings.instance().getString(string3);
        if (string7 == null) {
            string7 = string5 == null ? "file" : string5;
        }
        string7 = string + File.separator + string7;
        if (FileSystemHelper.getInstance().fileExists(string7 + string6, n)) {
            int n3 = SystemMeasurementSettings.instance().getInt(string4);
            switch (n3) {
                case 1: {
                    break;
                }
                case 4: {
                    systemProcess = this.append(string7 + string6, n);
                    systemProcess.put("filename", string7 + string6);
                    return systemProcess;
                }
                case 0: {
                    this.prompt(string7 + string6);
                    bl2 = true;
                    break;
                }
                case 2: {
                    string7 = string7 + FileSystemHelper.getInstance().getUniqueID();
                    break;
                }
                case 3: {
                    string7 = string7 + "_" + FileSystemHelper.getInstance().getTimestamp();
                }
            }
        }
        systemProcess.setExitCode(0);
        if (bl2) {
            return systemProcess;
        }
        systemProcess.put("filename", string7);
        return systemProcess;
    }

    void overwriteExistingFile(String string) {
        this.setMessage(this.pendingMessage);
        Thread thread = new Thread((Runnable)this, ":" + string);
        thread.start();
    }

    public void prompt(String string) {
        PromptMessageScreen promptMessageScreen = new PromptMessageScreen(string, this.promptMessage, 3, 30);
        promptMessageScreen.setAttribute("filename", string);
        this.sm.pushScreen(promptMessageScreen);
        this.setMode(1);
    }

    private SystemProcess append(String string, int n) {
        SystemProcess systemProcess = FileSystemHelper.getInstance().copyFile(string, string + ".tmp", n);
        return systemProcess;
    }

    public void setExitMessageScreen(SystemProcess systemProcess) {
        String string = this.getMode() == 2 || systemProcess == null ? TextMessage.ABORTED : (systemProcess.getExitCode() == 0 ? TextMessage.SUCCESS : TextMessage.FAILURE);
        this.setMode(3);
        this.setType(0);
        this.setMessage(string);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.startsWith(":")) {
            this.commitAction(string.substring(1));
        } else {
            this.commitAction(null);
        }
    }

    protected String[] getFileList() {
        String[] stringArray = null;
        stringArray = RuntimeConfiguration.isEmbedded() ? FileSystemHelper.getInstance().getDeviceFileList(this.getDeviceType(), "", this.getFileExtension(), false) : FileSystemHelper.getInstance().getFileList(FileSystemHelper.getInstance().getLocalDirectory(), this.getFileExtension(), false);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public abstract void commitAction(String var1);

    public abstract FileSelectButton createFilenameButton(AlphaEditScreen.AlphaEditScreenExitListener var1);

    protected abstract int getDeviceType();

    protected abstract String getFileExtension();

    protected abstract String getConfirmationText();

    class PromptMessageScreen
    extends MessageScreen
    implements MessageScreenListener {
        String filename;
        String prompt;

        public PromptMessageScreen(String string, String string2, int n, int n2) {
            super("", true, n, n2);
            this.filename = string;
            this.prompt = string2;
            this.addListener(this);
        }

        public void messageScreenExit(int n) {
            if (n == 2) {
                MediaMessageScreen.this.mode = 0;
                MediaMessageScreen.this.overwriteExistingFile(this.filename);
            } else {
                MediaMessageScreen.this.mode = 2;
                MediaMessageScreen.this.setExitMessageScreen(null);
            }
        }

        public void installScreen(ScreenManager screenManager) {
            super.installScreen(screenManager);
            this.getHTMLRenderer().addVariableReplacment("$FILENAME$", this.filename);
            this.setMessage(this.prompt);
        }
    }
}

