/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.html.HTMLRenderer;
import elgato.infrastructure.html.HTMLRendererListener;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.ModalKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.ShellExecutioner;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;

public class MessageScreen
extends Screen
implements HTMLRendererListener,
Runnable {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$mainScreens$MessageScreen == null ? (class$elgato$infrastructure$mainScreens$MessageScreen = MessageScreen.class$("elgato.infrastructure.mainScreens.MessageScreen")) : class$elgato$infrastructure$mainScreens$MessageScreen).getName());
    private static final HydroBorderPainterConfig BORDER_CONFIG = res.getBorderConfig("border");
    public static final int TYPE_OK = 0;
    public static final int TYPE_OK_CANCEL = 1;
    public static final int TYPE_YES_NO = 2;
    public static final int TYPE_YES_NO_CANCEL = 3;
    public static final int TYPE_PROGRESS = 4;
    public static final int TYPE_REBOOT_HIDDENCANCEL = 5;
    public static final int EXIT_OK = 0;
    public static final int EXIT_CANCEL = 1;
    public static final int EXIT_YES = 2;
    public static final int EXIT_NO = 3;
    private int type = 0;
    HTMLRenderer htmlRenderer = new HTMLRenderer();
    private boolean htmlMessage = false;
    private boolean pagingHandled = false;
    private MessageButton timeoutButton = null;
    private Hashtable attributes = new Hashtable();
    private ScreenManager sm = null;
    private String message;
    private int timeoutInSeconds = -1;
    private boolean messageScreenExited = false;
    private boolean escapePopsScreen = true;
    private Vector listeners = new Vector(3);
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$MessageScreen;

    public MessageScreen(String string, boolean bl, int n, int n2) {
        this.message = string;
        this.htmlMessage = bl;
        this.type = n;
        this.timeoutInSeconds = n2;
        this.handleTimeout();
    }

    public MessageScreen(String string, boolean bl, int n) {
        this(string, bl, n, -1);
    }

    public void addListener(MessageScreenListener messageScreenListener) {
        this.listeners.addElement(messageScreenListener);
    }

    private void fireMessageScreenExit(int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((MessageScreenListener)this.listeners.elementAt(i)).messageScreenExit(n);
        }
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public HTMLRenderer getHTMLRenderer() {
        return this.htmlRenderer;
    }

    private void handleTimeout() {
        if (this.timeoutInSeconds <= 0) {
            return;
        }
        Thread thread = new Thread((Runnable)this, "timeout");
        thread.start();
    }

    void exitMessageScreen(int n) {
        if (this.messageScreenExited) {
            return;
        }
        this.messageScreenExited = true;
        this.sm.popScreen();
        this.fireMessageScreenExit(n);
    }

    public void setEscapePopsScreen(boolean bl) {
        this.escapePopsScreen = bl;
    }

    public void installScreen(ScreenManager screenManager) {
        this.sm = screenManager;
        super.installScreen(screenManager);
        ModalKeyManager modalKeyManager = new ModalKeyManager(screenManager);
        modalKeyManager.setEscapePopsScreen(this.escapePopsScreen);
        GlobalKeyManager.registerInstance(modalKeyManager);
        if (!this.htmlMessage) {
            this.message = "<BODY>" + this.message + "</BODY>";
        }
        this.htmlRenderer.addListener(this);
        this.htmlRenderer.setText(this.message);
        screenManager.installDisplay(new BorderWrapper(this.htmlRenderer, BORDER_CONFIG, true));
        this.htmlRenderer.render();
        this.createMenu(screenManager);
        screenManager.getLeftMenuPanel().clear();
    }

    MessageButton createExitButton(String string, final int n) {
        return new MessageButton(string, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageScreen.this.exitMessageScreen(n);
            }
        });
    }

    MessageButton createRebootButton(String string) {
        return new MessageButton(string, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShellExecutioner.reboot();
            }
        });
    }

    private void createMenu(ScreenManager screenManager) {
        this.timeoutButton = null;
        switch (this.type) {
            case 0: {
                this.timeoutButton = this.createExitButton(Text.Ok, 0);
                screenManager.installRightMenu(new Menu("", new MenuItem[]{this.timeoutButton}));
                break;
            }
            case 1: {
                this.timeoutButton = this.createExitButton(Text.Cancel, 1);
                screenManager.installRightMenu(new Menu("", new MenuItem[]{this.createExitButton(Text.Ok, 0), null, null, null, null, null, this.timeoutButton}));
                break;
            }
            case 2: {
                this.timeoutButton = this.createExitButton(Text.No, 0);
                screenManager.installRightMenu(new Menu("", new MenuItem[]{this.createExitButton(Text.Yes, 2), this.timeoutButton}));
                break;
            }
            case 3: {
                this.timeoutButton = this.createExitButton(Text.Cancel, 1);
                screenManager.installRightMenu(new Menu("", new MenuItem[]{this.createExitButton(Text.Yes, 2), this.createExitButton(Text.No, 3), null, null, null, null, this.timeoutButton}));
                break;
            }
            case 5: {
                this.timeoutButton = this.createRebootButton(Text.Reboot);
                MessageButton messageButton = this.createExitButton(Text.Cancel, 0);
                messageButton.setHidden(true);
                screenManager.installRightMenu(new Menu("", new MenuItem[]{this.timeoutButton, null, null, null, null, null, messageButton}));
                break;
            }
            case 4: {
                screenManager.clearRightMenu();
            }
        }
    }

    private void handlePagingButtons() {
        this.pagingHandled = true;
        if (this.htmlRenderer.isScrollingRequired()) {
            this.sm.getRightMenuPanel().setMenuItem(this.makeScrollUpButton(), 3);
            this.sm.getRightMenuPanel().setMenuItem(this.makeScrollDownButton(), 4);
            this.sm.getRightMenuPanel().setMenuItem(this.makePageUpButton(), 5);
            this.sm.getRightMenuPanel().setMenuItem(this.makePageDownButton(), 6);
        }
    }

    public void uninstallScreen(ScreenManager screenManager) {
        if (this.htmlRenderer != null) {
            this.htmlRenderer.removeListener(this);
        }
        try {
            GlobalKeyManager.makeInstance(screenManager);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        super.uninstallScreen(screenManager);
    }

    public ScreenManager getScreenManager() {
        return super.getScreenManager();
    }

    public String getContextId() {
        return super.getContextId();
    }

    public String getHelpContext() {
        return super.getHelpContext();
    }

    public String getContextString(String string) {
        return super.getContextString(string);
    }

    private PushButton makeScrollUpButton() {
        return new PushButton(Text.Scroll_Up, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageScreen.this.htmlRenderer.scrollUp();
            }
        });
    }

    private PushButton makeScrollDownButton() {
        return new PushButton(Text.Scroll_Down, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageScreen.this.htmlRenderer.scrollDown();
            }
        });
    }

    private PushButton makePageUpButton() {
        return new PushButton(Text.Page_Up, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageScreen.this.htmlRenderer.scrollPageUp();
            }
        });
    }

    private PushButton makePageDownButton() {
        return new PushButton(Text.Page_Down, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageScreen.this.htmlRenderer.scrollPageDown();
            }
        });
    }

    public void setType(int n) {
        this.setType(n, true);
    }

    public void setType(int n, boolean bl) {
        this.type = n;
        if (bl) {
            this.createMenu(this.sm);
            this.sm.getRightMenuPanel().repaint();
        }
    }

    public void setMessage(String string) {
        this.htmlRenderer.setText(string);
        this.htmlRenderer.render();
    }

    public void finishedHTMLRendering() {
        if (this.pagingHandled) {
            return;
        }
        this.handlePagingButtons();
    }

    private void timeout() {
        if (this.timeoutInSeconds <= 0) {
            return;
        }
        boolean bl = false;
        int n = this.timeoutInSeconds;
        while (!bl && !this.messageScreenExited) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (--n <= 0) {
                bl = true;
            }
            if (this.timeoutButton == null) continue;
            this.timeoutButton.setSubtext("   " + n);
            this.timeoutButton.repaint();
        }
        if (bl && !this.messageScreenExited) {
            this.exitMessageScreen(1);
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals("timeout")) {
            this.timeout();
        }
    }

    public static MessageScreen createRebootMessageScreen(Command command, String string) {
        return new MessageScreen("<html><body><h1>" + Text.REBOOT_MESSAGE_SCREEN_TEXT_1 + "</h1><br><br>" + Text.REBOOT_MESSAGE_SCREEN_TEXT_2 + "<br>" + Text.REBOOT_MESSAGE_SCREEN_TEXT_3 + "<br>" + Text.REBOOT_MESSAGE_SCREEN_TEXT_4 + " <br><br>" + Text.REBOOT_MESSAGE_SCREEN_TEXT_5 + "<br><br>" + string + "<br><br>" + command + "<br><br>" + Text.REBOOT_MESSAGE_SCREEN_TEXT_6 + " <b>" + Text.REBOOT_MESSAGE_SCREEN_TEXT_7 + "</b>" + Text.REBOOT_MESSAGE_SCREEN_TEXT_8 + "</body></html>", true, 5);
    }

    public static MessageScreen createGuiFatalErrorScreen(String string) {
        return new MessageScreen("<html><body><h1>" + Text.GUI_FAIL_MESSAGE_SCREEN_TEXT_1 + "</h1><br><br>" + Text.GUI_FAIL_MESSAGE_SCREEN_TEXT_2 + "<br>" + Text.GUI_FAIL_MESSAGE_SCREEN_TEXT_3 + " " + Text.HELP_NUMBER + Text.GUI_FAIL_MESSAGE_SCREEN_TEXT_4 + " <br><br>" + Text.GUI_FAIL_MESSAGE_SCREEN_TEXT_5 + "<br><br>" + string, true, 4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MessageButton
    extends PushButton {
        private boolean hidden;

        public MessageButton(String string, String string2, ActionListener actionListener) {
            super(string, string2, actionListener);
        }

        public void setSubtext(String string) {
            this.setBodyText(string);
        }

        public void setHidden(boolean bl) {
            this.hidden = bl;
        }

        public void paint(Graphics graphics, int n, int n2) {
            if (!this.hidden) {
                super.paint(graphics, n, n2);
            }
        }
    }
}

