/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.html.HTMLRenderer;
import elgato.infrastructure.mainScreens.MediaMessageScreen;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.FileSelectButton;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.StorageDevice;
import elgato.infrastructure.util.SystemProcess;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.widgets.EProgressBar;
import elgato.infrastructure.widgets.ImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class PrintScreenMessageScreen
extends MediaMessageScreen {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$mainScreens$PrintScreenMessageScreen == null ? (class$elgato$infrastructure$mainScreens$PrintScreenMessageScreen = PrintScreenMessageScreen.class$("elgato.infrastructure.mainScreens.PrintScreenMessageScreen")) : class$elgato$infrastructure$mainScreens$PrintScreenMessageScreen).getName());
    private static final Resources systemResources = Resources.getResources("elgato.system");
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$mainScreens$PrintScreenMessageScreen == null ? (class$elgato$infrastructure$mainScreens$PrintScreenMessageScreen = PrintScreenMessageScreen.class$("elgato.infrastructure.mainScreens.PrintScreenMessageScreen")) : class$elgato$infrastructure$mainScreens$PrintScreenMessageScreen);
    private static final int MAX_SAVE_SCREEN_HOLD = 60;
    private static final String AGILENT_LOGO_PATH = systemResources.getString("agilent.logo.image.path");
    private Image decoratedImage;
    private Image logoImage;
    private Image screenImage;
    private Image gpsLocImage;
    boolean isScreenCaptured = false;
    boolean screenCaptureFailed = false;
    boolean screenImageCaptureFinished = false;
    EProgressBar progressBar;
    boolean progressBarStopped = false;
    boolean progressBarSuspended = false;
    private boolean lightBackground;
    private boolean presetFlag = false;
    private Frame screenFrame;
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$PrintScreenMessageScreen;

    public PrintScreenMessageScreen(String string, boolean bl, int n, Frame frame, Image image, Image image2, boolean bl2) {
        super(string, bl, n, TextMessage.MEDIA_SCREEN_SAVE_PROMPT_OVERWRITE);
        this.screenFrame = frame;
        this.lightBackground = bl2;
        this.screenImage = image;
        this.gpsLocImage = image2;
        this.createProgressBar();
        this.captureFinished();
        this.startProgressBar();
    }

    private void createProgressBar() {
        this.progressBar = new EProgressBar("Screen Capture", Integer.parseInt(res.getString("progressBar.x")), Integer.parseInt(res.getString("progressBar.y")), Integer.parseInt(res.getString("progressBar.width")), Integer.parseInt(res.getString("progressBar.height")));
        if (!RuntimeConfiguration.isEmbedded()) {
            this.progressBar.addTask(Text.SCREEN_PRINT_SCREEN_PROGRESS_CAPTURE, 10, 1);
            this.progressBar.addTask(Text.SCREEN_PRINT_SCREEN_PROGRESS_SAVE, 90, 20);
        } else {
            this.progressBar.addTask(Text.SCREEN_PRINT_SCREEN_PROGRESS_CAPTURE, 55, 3);
            this.progressBar.addTask(Text.SCREEN_PRINT_SCREEN_PROGRESS_SAVE, 45, 20);
        }
    }

    private void startProgressBar() {
        Thread thread = new Thread(new ProgressBarUpdate(this.getHTMLRenderer()));
        thread.start();
    }

    private void captureFinished() {
        EventDispatchThread.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    PrintScreenMessageScreen.this.isScreenCaptured = true;
                }
                catch (Exception exception) {
                    logger.error("captureScreenImage failed", exception);
                    PrintScreenMessageScreen.this.screenCaptureFailed = true;
                }
                finally {
                    PrintScreenMessageScreen.this.progressBar.nextTask();
                    PrintScreenMessageScreen.this.screenImageCaptureFinished = true;
                }
            }
        }, "captureScreenImage()");
    }

    private void decorateImage(String string) {
        String string2 = FileSystemHelper.getInstance().getLocalDirectory();
        String string3 = string2 + "screenTmp.png";
        String string4 = string2 + "gpsTmp.png";
        try {
            if (string == null) {
                return;
            }
            if (this.screenImage == null) {
                return;
            }
            FileSystemHelper.getInstance().saveImage(string3, this.screenImage);
            if (this.gpsLocImage != null) {
                FileSystemHelper.getInstance().saveImage(string4, this.gpsLocImage);
            }
            this.logoImage = ImageIcon.loadImage(AGILENT_LOGO_PATH, this.screenFrame);
            this.screenImage = ImageIcon.loadImageAbsPath(string3, this.screenFrame, true);
            if (RuntimeConfiguration.isEmbedded()) {
                FileSystemHelper.getInstance().removeFile(string3);
            }
            Rectangle rectangle = new Rectangle(0, 0, this.screenImage.getWidth(null), this.screenImage.getHeight(null));
            int n = rectangle.height;
            int n2 = rectangle.width;
            int n3 = this.screenImage.getHeight(null);
            n += (this.logoImage.getHeight(null) + 2) * 2;
            if (this.gpsLocImage != null) {
                this.gpsLocImage = ImageIcon.loadImageAbsPath(string4, this.screenFrame);
                n += this.gpsLocImage.getHeight(null);
            }
            this.decoratedImage = this.screenFrame.createImage(n2, n);
            Graphics graphics = this.decoratedImage.getGraphics();
            Color color = this.lightBackground ? ((Component)this.screenFrame).getBackground().brighter().brighter() : MenuPanel.BG_COLOR;
            graphics.setColor(color);
            graphics.fillRect(0, 0, n2, n);
            graphics.setFont(new Font("SansSerif", 1, 12));
            int n4 = 1;
            int n5 = 84;
            int n6 = 1;
            int n7 = 21;
            int n8 = this.screenImage.getWidth(null) - 2 * n5;
            n3 += n7;
            if (this.lightBackground) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.drawRect(n5, n6, n8, n7);
            graphics.drawString(string, n5 + n4 + 1, n6 + (int)((float)n7 * 0.8f));
            graphics.drawImage(this.screenImage, 1, n7, null);
            if (this.gpsLocImage != null) {
                graphics.drawImage(this.gpsLocImage, (this.screenImage.getWidth(null) - this.gpsLocImage.getWidth(null) - n4 * 2) / 2, n3, null);
                n3 += this.gpsLocImage.getHeight(null);
            }
            graphics.drawImage(this.logoImage, (this.screenImage.getWidth(null) - this.logoImage.getWidth(null) - n4 * 2) / 2, n3, null);
            graphics.dispose();
        }
        catch (Exception exception) {
            logger.warn("decorateImage: No addition of filename to screen capture image..." + exception);
        }
    }

    public SystemProcess saveScreenImage(String string) {
        SystemProcess systemProcess;
        String string2;
        int n = 0;
        this.progressBarSuspended = true;
        while (!this.isScreenCaptured) {
            try {
                Thread.sleep(500L);
                if (n++ <= 60 && !this.screenCaptureFailed) continue;
                SystemProcess systemProcess2 = new SystemProcess("abortSaveScreen");
                systemProcess2.setExitCode(-1);
                systemProcess2.addErrorOutput(TextMessage.MEDIA_SCREEN_CAPTURE_FAILURE);
                this.setMode(6);
                return systemProcess2;
            }
            catch (Exception exception) {
                logger.warn("saveScreenImage(" + string + "): " + exception);
            }
        }
        String string3 = FileSystemHelper.getInstance().getLocalDirectory();
        StorageDevice storageDevice = null;
        int n2 = -1;
        if (string3 == null) {
            n2 = SystemMeasurementSettings.instance().getScreenDeviceType();
            storageDevice = FileSystemHelper.getInstance().createStorageDevice(n2);
            if (storageDevice == null) {
                SystemProcess systemProcess3 = new SystemProcess("createStorageDevice");
                systemProcess3.setException(new NullPointerException("Unable to create writable storage device."));
                systemProcess3.setExitCode(1);
                return systemProcess3;
            }
        }
        String string4 = string2 = string3 == null ? storageDevice.getDirectory() : string3;
        if (string == null) {
            systemProcess = this.determineFilename(string2, "screenAutoNameFile", "screenFilename", "screenFileExists", Text.printScreen, ".png", n2);
            if (systemProcess.getExitCode() < 0) {
                return systemProcess;
            }
            string = (String)systemProcess.get("filename");
            if (string == null) {
                return null;
            }
        }
        if (!string.endsWith(".png")) {
            string = string + ".png";
        }
        this.progressBarSuspended = false;
        this.decorateImage(this.getUnqualifiedFilename(string));
        systemProcess = string3 == null ? FileSystemHelper.getInstance().saveImage(storageDevice, string, this.decoratedImage, false) : FileSystemHelper.getInstance().saveImage(string, this.decoratedImage);
        systemProcess.put("filename", string);
        return systemProcess;
    }

    public void setExitMessageScreen(SystemProcess systemProcess) {
        String string;
        this.progressBar.nextTask();
        this.progressBarStopped = true;
        this.getHTMLRenderer().repaint();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.progressBar.hide();
        if (this.getMode() == 2 || systemProcess == null) {
            string = TextMessage.MEDIA_SCREEN_SAVE_ABORT;
        } else {
            this.getHTMLRenderer().clearVariableReplacement();
            if (systemProcess.getExitCode() == 0) {
                this.getHTMLRenderer().addVariableReplacment("$FILENAME$", "<B>" + (String)systemProcess.get("filename") + "</B>");
                string = TextMessage.MEDIA_SCREEN_SAVE_SUCCESS;
            } else {
                this.getHTMLRenderer().addVariableReplacment("$OUTPUT$", systemProcess.getOutputAsHTML());
                string = TextMessage.MEDIA_SCREEN_SAVE_FAILURE;
            }
        }
        this.setMode(3);
        if (this.presetFlag) {
            this.presetFlag = false;
        } else {
            this.setType(0);
        }
        this.setMessage(string);
    }

    public void commitAction(String string) {
        this.printScreen(string);
    }

    private void printScreen(String string) {
        final SystemProcess systemProcess = this.saveScreenImage(string);
        if (systemProcess == null && (this.getMode() == 1 || this.getMode() == 5)) {
            return;
        }
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                PrintScreenMessageScreen.this.setExitMessageScreen(systemProcess);
            }
        }, "PrintScreenMessageScreen.printScreen");
    }

    public FileSelectButton createFilenameButton(AlphaEditScreen.AlphaEditScreenExitListener alphaEditScreenExitListener) {
        return new FileSelectButton(Text.User_Filename, Text.Enter_Screen_Filename, this.getContextString("printScreenSetup.filename"), (SettingsModel)SystemMeasurementSettings.instance(), "screenFilename", this.getFileList(), alphaEditScreenExitListener);
    }

    protected int getDeviceType() {
        return SystemMeasurementSettings.instance().getScreenDeviceType();
    }

    protected String getFileExtension() {
        return ".png";
    }

    protected String getConfirmationText() {
        return TextMessage.SCREEN_SAVE_CONFIRM;
    }

    public void handlePreset() {
        this.presetFlag = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ProgressBarUpdate
    implements Runnable,
    HTMLRenderer.HTMLRendererExternalPainter {
        HTMLRenderer renderer = null;

        public ProgressBarUpdate(HTMLRenderer hTMLRenderer) {
            this.renderer = hTMLRenderer;
            hTMLRenderer.addExternalPainter(this);
        }

        public void paintHTMLRenderer(Graphics graphics) {
            PrintScreenMessageScreen.this.progressBar.paint(graphics);
        }

        private void cycleProgressBar() {
            while (!PrintScreenMessageScreen.this.progressBarStopped) {
                if (!PrintScreenMessageScreen.this.progressBarSuspended || !PrintScreenMessageScreen.this.screenImageCaptureFinished) {
                    PrintScreenMessageScreen.this.progressBar.bumpTaskASecond();
                    this.renderer.repaint();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.warn("ProgressBarUpdate.cycleProgressBar(): " + interruptedException);
                }
            }
        }

        public void run() {
            this.cycleProgressBar();
        }
    }
}

