/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.SaveDataMessageScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.StorageDevice;
import elgato.infrastructure.util.SystemProcess;
import elgato.infrastructure.util.TextMessage;
import java.io.ByteArrayInputStream;

public class SaveTestDataMessageScreen
extends SaveDataMessageScreen {
    private String dataToWrite;
    private ScreenManager sm;

    public SaveTestDataMessageScreen(String string, ScreenManager screenManager) {
        super(TextMessage.MEDIA_DATA_SAVE_PENDING, true, 4, (MeasurementScreen)null);
        this.dataToWrite = string;
        this.sm = screenManager;
    }

    public void commitAction(String string) {
        final SystemProcess systemProcess = this.writeToPcmciaCard(this.sm, string);
        if (systemProcess == null && (this.getMode() == 1 || this.getMode() == 5)) {
            return;
        }
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                SaveTestDataMessageScreen.this.setExitMessageScreen(systemProcess);
            }
        }, "SaveDataMessageScreen.saveData");
    }

    SystemProcess writeToPcmciaCard(ScreenManager screenManager, String string) {
        SystemProcess systemProcess = null;
        StorageDevice storageDevice = FileSystemHelper.getInstance().createStorageDevice(this.getDeviceType());
        if (storageDevice == null) {
            systemProcess = new SystemProcess("createStorageDevice");
            systemProcess.setException(new NullPointerException("Unable to create writable storage device."));
            systemProcess.setExitCode(1);
            return systemProcess;
        }
        String string2 = storageDevice.getDirectory();
        if (string == null) {
            systemProcess = this.determineFilename(string2, "dataAutoNameFile", "dataFilename", "dataFileExists", "tempResults", ".html", this.getDeviceType());
            if (systemProcess.getExitCode() < 0) {
                return systemProcess;
            }
            string = (String)systemProcess.get("filename");
            if (string == null) {
                return null;
            }
        }
        if (!string.endsWith(".html")) {
            string = string + ".html";
        }
        systemProcess = new SystemProcess("saveData");
        systemProcess.put("filename", string);
        try {
            FileSystemHelper.getInstance().saveFile(storageDevice, string, new ByteArrayInputStream(this.dataToWrite.getBytes()));
            systemProcess.setExitCode(0);
        }
        catch (Exception exception) {
            systemProcess.setExitCode(1);
            systemProcess.setException(exception);
        }
        return systemProcess;
    }
}

