/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.SigGenButtonFactory;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public abstract class Screen {
    private ScreenManager screenManager;
    protected String listenerBaseName;

    public void installScreen(ScreenManager screenManager) {
        this.screenManager = screenManager;
        MenuPanel[] menuPanelArray = new MenuPanel[]{this.screenManager.getLeftMenuPanel(), this.screenManager.getRightMenuPanel()};
        for (int i = 0; i < menuPanelArray.length; ++i) {
            if (menuPanelArray[i] == null) continue;
            menuPanelArray[i].clear();
        }
    }

    public void uninstallScreen(ScreenManager screenManager) {
        this.screenManager = null;
    }

    public ScreenManager getScreenManager() {
        return this.screenManager;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public String getContextId() {
        return this.getClass().getName();
    }

    public String getHelpContext() {
        String string = this.getHelpContextFromMenuPanel(this.screenManager.getRightMenuPanel());
        if (string != null) {
            return string;
        }
        string = this.getHelpContextFromMenuPanel(this.screenManager.getLeftMenuPanel());
        if (string != null) {
            return string;
        }
        return this.getContextId();
    }

    private String getHelpContextFromMenuPanel(MenuPanel menuPanel) {
        MenuItem menuItem;
        if (menuPanel != null && (menuItem = menuPanel.getSelectedItem()) != null) {
            return menuItem.getContextId();
        }
        return null;
    }

    public String getContextString(String string) {
        return this.getClass().getName() + "." + string;
    }

    public void pressHomeButton() {
        this.getScreenManager().getLeftMenuPanel().invokeButton(0);
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        return image;
    }

    public void handlePreset() {
    }

    public String getListenerBaseName() {
        if (this.listenerBaseName == null) {
            this.listenerBaseName = this.getClass().getName();
            int n = this.listenerBaseName.lastIndexOf(".");
            if (n > -1) {
                try {
                    this.listenerBaseName = this.listenerBaseName.substring(n + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.listenerBaseName;
    }

    public MenuItem createSigGenButton() {
        boolean bl = MeasurementFactory.instance().measurementAvailable("source");
        MenuItem[] menuItemArray = bl ? new MenuItem[]{SigGenButtonFactory.createFrequencyButton(this), SigGenButtonFactory.createRfButton(this), SigGenButtonFactory.createAmplitudeButton(this), SigGenButtonFactory.createLossButton(this), SigGenButtonFactory.createPersistButton(this, Text.Enable_n_Sig_Gen), this.createModulationFormatButton()} : new MenuItem[]{};
        SubMenuButton subMenuButton = new SubMenuButton(Text.Sig_Gen, this.getContextString("sigGen"), new Menu(Text.Sig_Gen, menuItemArray), true);
        subMenuButton.getMenu().getItems()[6].setText(Text.Back);
        subMenuButton.setEnabled(bl);
        return subMenuButton;
    }

    private MenuItem createModulationFormatButton() {
        ListActuatorButton listActuatorButton = SigGenButtonFactory.createModulationFormatButton(this, Text.Mod_Format);
        if (!this.modulationAvailable()) {
            listActuatorButton.setEnabled(false);
        }
        return listActuatorButton;
    }

    protected boolean modulationAvailable() {
        return MeasurementFactory.instance().optionAvailable("cdmaSource");
    }
}

