/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JComponent;

public class SetupPanel
extends JComponent {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$mainScreens$SetupPanel == null ? (class$elgato$infrastructure$mainScreens$SetupPanel = SetupPanel.class$("elgato.infrastructure.mainScreens.SetupPanel")) : class$elgato$infrastructure$mainScreens$SetupPanel).getName());
    private static final Color FONT_COLOR = res.getColor("font.color");
    private static final HydroBorderPainterConfig config = res.getBorderConfig("border");
    private static final int SPACE_BETWEEN_COLUMNS = 24;
    private final Vector items = new Vector();
    private final Font font = res.getFont("font");
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$SetupPanel;

    public Vector getItems() {
        return this.items;
    }

    public void addItem(final MenuItem menuItem) {
        this.items.addElement(new SetupItem(){

            public String getText() {
                return menuItem.getText();
            }

            public String getValue() {
                if (!this.isEnabled()) {
                    return Text.N_slash_A;
                }
                return UIHelper.stripNewlines(menuItem.getBodyText());
            }

            public boolean isEnabled() {
                return menuItem.isEnabled();
            }
        });
    }

    public void addItem(final SubMenuButton subMenuButton) {
        this.items.addElement(new SetupItem(){

            public String getText() {
                return subMenuButton.getText();
            }

            public String getValue() {
                if (!this.isEnabled()) {
                    return Text.N_slash_A;
                }
                return subMenuButton.getSubText();
            }

            public boolean isEnabled() {
                return subMenuButton.isEnabled();
            }
        });
    }

    private SetupItem getItem(int n) {
        return (SetupItem)this.items.elementAt(n);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent() + fontMetrics.getLeading();
        int n3 = this.getSize().height / this.items.size();
        int n4 = n + (n3 - n) / 2;
        for (int i = 0; i < this.items.size(); ++i) {
            SetupItem setupItem = this.getItem(i);
            this.drawItem(graphics, n2, n4 + n3 * i, this.getMaximumTextSize(fontMetrics), setupItem);
        }
    }

    private void drawItem(Graphics graphics, int n, int n2, int n3, SetupItem setupItem) {
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = setupItem.getText() + ":";
        int n4 = fontMetrics.getHeight();
        graphics.setColor(setupItem.isEnabled() ? this.getFontColor() : Color.gray);
        graphics.setFont(font2);
        graphics.drawString(string, n, n2);
        graphics.setFont(font);
        if (setupItem.getValue() != null) {
            graphics.drawString(setupItem.getValue(), n3 + n4, n2);
        }
    }

    Color getFontColor() {
        return FONT_COLOR;
    }

    Color getBackgroundColor() {
        return config.getBackgroundColor();
    }

    private int getMaximumTextSize(FontMetrics fontMetrics) {
        int n = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            n = Math.max(n, fontMetrics.stringWidth(this.getItem(i).getText()));
        }
        return n + 24;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface SetupItem {
        public String getText();

        public String getValue();

        public boolean isEnabled();
    }
}

