/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.mainScreens.VersionPopup;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.widgets.HydroBorderPainter;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import elgato.infrastructure.widgets.ImageIcon;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;

public class SplashScreen
extends JComponent {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$mainScreens$SplashScreen == null ? (class$elgato$infrastructure$mainScreens$SplashScreen = SplashScreen.class$("elgato.infrastructure.mainScreens.SplashScreen")) : class$elgato$infrastructure$mainScreens$SplashScreen).getName());
    private static final HydroBorderPainterConfig BORDER_CONFIG = res.getBorderConfig("border");
    private static final String UNKNOWN_MODEL_ID_DEFAULTS_TO = "Remote";
    private VersionPopup versionPopup;
    private Image backgroundImage;
    private Image modelSpecificOverlay;
    private CommandListener systemIdListener = new CommandListener(){

        public void commandReceived(Command command) {
            EventDispatchThread.invokeLater(new Runnable(this, command){
                private final /* synthetic */ Command val$command;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$command = command;
                }

                public void run() {
                    1.access$000(this.this$1).loadSplashImage(this.val$command.getProperty("model"));
                }
            }, "SplashScreen.systemIdListener");
            MeasurementFactory.instance().getCommandProcessor().removeCommandListener("setSystemId", this);
        }

        static /* synthetic */ SplashScreen access$000(1 var0) {
            return var0.SplashScreen.this;
        }
    };
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$SplashScreen;

    public SplashScreen() {
        MeasurementFactory.instance().getCommandProcessor().sendSystemIdCommand(this.systemIdListener);
        this.backgroundImage = ImageIcon.loadImage("images/ModeScreen.jpg", this);
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        HydroBorderPainter.paintBorder(graphics, 0, 0, n, n2, true, BORDER_CONFIG);
        int n3 = BORDER_CONFIG.getBorderWidth();
        graphics.translate(n3, n3);
        int n4 = n3 * 2;
        graphics.setClip(0, 0, n - n4, n2 - n4);
        n -= n4;
        n2 -= n4;
        this.drawImage(graphics, this.backgroundImage);
        if (this.modelSpecificOverlay != null) {
            this.drawImage(graphics, this.modelSpecificOverlay);
        }
        if (this.versionPopup != null) {
            this.versionPopup.paint(graphics, 10, n2 - 17);
        }
    }

    private void drawImage(Graphics graphics, Image image) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        int n5 = 12;
        int n6 = -5;
        graphics.drawImage(image, (n - n3) / 2 + n5, (n2 - n4) / 2 + n6, null);
    }

    void loadSplashImage(String string) {
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("unknown")) {
            string = UNKNOWN_MODEL_ID_DEFAULTS_TO;
        }
        String string2 = "images/ModeScreen_overlay-" + string + ".png";
        this.modelSpecificOverlay = ImageIcon.loadImage(string2, this);
        this.versionPopup = new VersionPopup();
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

