/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.systemFunctions.SavedState;
import elgato.infrastructure.systemFunctions.SavedStateList;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.Comparator;
import elgato.infrastructure.util.StringComparator;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.DefaultEListModel;
import elgato.infrastructure.widgets.EListCellRenderer;
import elgato.infrastructure.widgets.EListModel;

public class StateRecaller {
    public static boolean isActive = false;

    public static void showRecallScreen(ScreenManager screenManager) {
        SavedStateList savedStateList = MeasurementFactory.instance().getSavedStateList();
        Object[] objectArray = savedStateList.getReadableStates();
        int n = StateRecaller.sortStatesAndGetCurrentStateIndex((SavedState[])objectArray, savedStateList.getCurrentState());
        StateRecallerScreen stateRecallerScreen = new StateRecallerScreen(new DefaultEListModel(objectArray), n, new RecallStateSelectionListener(), Text.Recall_State, new SavedStateCellRenderer(savedStateList.getPowerUpState()));
        screenManager.pushScreen(stateRecallerScreen);
    }

    static int sortStatesAndGetCurrentStateIndex(SavedState[] savedStateArray, String string) {
        Arrays.sort(savedStateArray, new SavedStateNameComparator());
        int n = StateRecaller.search(savedStateArray, string);
        return n;
    }

    static int search(SavedState[] savedStateArray, String string) {
        for (int i = 0; i < savedStateArray.length; ++i) {
            if (!savedStateArray[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    static class SavedStateCellRenderer
    extends DefaultEListCellRenderer {
        private final String powerUpState;

        public SavedStateCellRenderer(String string) {
            this.powerUpState = string;
        }

        protected String stringValue(Object object) {
            SavedState savedState = (SavedState)object;
            if (savedState.getName().equals(this.powerUpState) && !savedState.getName().equals("Powerup")) {
                return savedState.getName() + Text.Power_Up;
            }
            return savedState.getName();
        }
    }

    static class SavedStateNameComparator
    implements Comparator {
        private final Comparator stringComparator = new StringComparator();

        SavedStateNameComparator() {
        }

        public int compare(Object object, Object object2) {
            SavedState savedState = (SavedState)object;
            SavedState savedState2 = (SavedState)object2;
            return this.stringComparator.compare(savedState.getName(), savedState2.getName());
        }
    }

    public static class StateRecallerScreen
    extends ListScreen {
        public StateRecallerScreen(EListModel eListModel, int n, ItemSelectionListener itemSelectionListener, String string, EListCellRenderer eListCellRenderer) {
            super(eListModel, n, itemSelectionListener, string, eListCellRenderer);
        }

        public void installScreen(ScreenManager screenManager) {
            super.installScreen(screenManager);
            isActive = true;
        }

        public void uninstallScreen(ScreenManager screenManager) {
            isActive = false;
            super.uninstallScreen(screenManager);
        }
    }

    private static class RecallStateSelectionListener
    implements ItemSelectionListener {
        private RecallStateSelectionListener() {
        }

        public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
            SavedState savedState = (SavedState)itemSelectionEvent.getValue();
            Command command = new Command("recall");
            command.addProperty("config", savedState.getName());
            MeasurementFactory.instance().getCommandProcessor().send(command);
        }
    }
}

