/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.MessageScreenListener;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.mainScreens.StateRecaller;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.systemFunctions.SavedState;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.DefaultEListModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class StateSaver {
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$mainScreens$StateSaver == null ? (class$elgato$infrastructure$mainScreens$StateSaver = StateSaver.class$("elgato.infrastructure.mainScreens.StateSaver")) : class$elgato$infrastructure$mainScreens$StateSaver);
    public static boolean isActive = false;
    AlphaEditScreen alphaEditScreen;
    private StatePrefetcher prefetcher = new StatePrefetcher();
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$StateSaver;

    public StateSaver(ScreenManager screenManager) {
        this.prefetcher.fetch();
        Value value = this.getCorrectStateForDisplay();
        this.alphaEditScreen = new AlphaEditScreen(value){

            public void installScreen(ScreenManager screenManager) {
                super.installScreen(screenManager);
                isActive = true;
            }

            public void uninstallScreen(ScreenManager screenManager) {
                isActive = false;
                super.uninstallScreen(screenManager);
            }
        };
        this.alphaEditScreen.setSecondRightMenuItem(this.createStateListButton(screenManager));
        value.addValueListener(this.createValueChangeListener(screenManager));
        screenManager.pushScreen(this.alphaEditScreen);
    }

    protected Value getCorrectStateForDisplay() {
        String string = MeasurementFactory.instance().getSavedStateList().getCurrentState();
        if (string.equals("FactoryDefaults") || string.equals("Powerup")) {
            string = "User";
        }
        Value value = Value.createValue("Save state name", string);
        return value;
    }

    private ValueListener createValueChangeListener(final ScreenManager screenManager) {
        return new ValueListener(){
            private final String listenerName = "stateNameListener";

            public String getListenerName() {
                return "stateNameListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                String string = ((Object)valueInterface).toString();
                if (StateSaver.this.stateExists(string)) {
                    MessageScreen messageScreen = new MessageScreen(TextMessage.SCREEN_SYSTEM_SETTINGS_SAVE_CONFIRM, true, 3);
                    messageScreen.getHTMLRenderer().addVariableReplacment("$SETTINGS$", string);
                    messageScreen.addListener(new MessageScreenListener(this, string){
                        private final /* synthetic */ String val$stateName;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$stateName = string;
                        }

                        public void messageScreenExit(int n) {
                            if (n == 2) {
                                2.access$100(this.this$1).save(this.val$stateName);
                            }
                        }
                    });
                    screenManager.pushScreen(messageScreen);
                } else {
                    StateSaver.this.save(string);
                }
            }

            static /* synthetic */ StateSaver access$100(2 var0) {
                return var0.StateSaver.this;
            }
        };
    }

    boolean stateExists(String string) {
        SavedState[] savedStateArray = this.prefetcher.getStates();
        for (int i = 0; i < savedStateArray.length; ++i) {
            SavedState savedState = savedStateArray[i];
            if (!savedState.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    void save(String string) {
        Command command = new Command("save");
        command.addProperty("config", string);
        MeasurementFactory.instance().getCommandProcessor().send(command);
    }

    private MenuItem createStateListButton(final ScreenManager screenManager) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                screenManager.pushScreen(StateSaver.this.createListScreen());
            }
        };
        return new PushButton(Text.Select_name_from_existing_save_states, "savedStateList", actionListener);
    }

    protected Screen createListScreen() {
        Object[] objectArray = this.prefetcher.getStates();
        int n = this.findIndexForState((SavedState[])objectArray);
        return new ListScreen(new DefaultEListModel(objectArray), n, this.createSelectionListener(), Text.Select_saved_state, new StateRecaller.SavedStateCellRenderer(MeasurementFactory.instance().getSavedStateList().getPowerUpState()));
    }

    protected int findIndexForState(SavedState[] savedStateArray) {
        int n = StateRecaller.sortStatesAndGetCurrentStateIndex(savedStateArray, MeasurementFactory.instance().getSavedStateList().getCurrentState());
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    private ItemSelectionListener createSelectionListener() {
        return new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                SavedState savedState = (SavedState)itemSelectionEvent.getValue();
                StateSaver.this.alphaEditScreen.setValue(savedState.getName());
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class StatePrefetcher {
        private SavedState[] states;
        private RuntimeException exception;

        private StatePrefetcher() {
        }

        public void fetch() {
            new Thread(this){
                private final /* synthetic */ StatePrefetcher this$0;
                {
                    this.this$0 = statePrefetcher;
                }

                public void run() {
                    if (logger.isDebugEnabled()) {
                        logger.debug("StatePrefetcher.run() fetching state list...");
                    }
                    this.this$0.doFetch();
                    if (logger.isDebugEnabled()) {
                        logger.debug("StatePrefetcher.run() done fetching state list.");
                    }
                }
            }.start();
        }

        synchronized void doFetch() {
            try {
                this.states = MeasurementFactory.instance().getWritableSavedStates();
            }
            catch (RuntimeException runtimeException) {
                this.exception = runtimeException;
            }
        }

        public synchronized SavedState[] getStates() {
            long l = System.currentTimeMillis() + 1000L;
            try {
                while (this.states == null) {
                    long l2 = System.currentTimeMillis();
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    if (l2 >= l) {
                        logger.error("Timed out waiting for prefetched saved state list");
                        this.states = new SavedState[0];
                    }
                    this.wait(l - l2);
                }
            }
            catch (InterruptedException interruptedException) {
                this.states = new SavedState[0];
            }
            return this.states;
        }
    }
}

