/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.manufacturing;

import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.html.HTMLRenderer;
import elgato.infrastructure.html.HTMLScreen;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.manufacturing.FullscreenTestKeyManager;
import elgato.infrastructure.manufacturing.GameUtilities;
import elgato.infrastructure.manufacturing.HighScoreListHelper;
import elgato.infrastructure.manufacturing.snake.SnakeScreen;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.ScreenButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.Glue;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import elgato.infrastructure.widgets.WrappedTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.util.Random;
import java.util.Vector;
import javax.swing.JComponent;

public class DisplayTestScreen
extends Screen {
    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        screenManager.installLeftMenu(this.createLeftMenu());
        screenManager.installRightMenu(this.createRightMenu());
        HTMLRenderer hTMLRenderer = new HTMLRenderer();
        hTMLRenderer.setText(Text.Display_Test_HTMLMessage);
        screenManager.installDisplay(new BorderWrapper(hTMLRenderer, HTMLScreen.BORDER_CONFIG, true));
    }

    private Menu createLeftMenu() {
        return new Menu(Text.Display_Test, new MenuItem[]{this.createChameleonTestButton(Text.Custom_n_Half_n_Brightness, 0.5f), this.createChameleonTestButton(Text.Custom_n_Full_n_Brightness, 1.0f)});
    }

    private Menu createRightMenu() {
        return new Menu("", new MenuItem[]{this.createColorTestButton(Text.White, Color.white), this.createColorTestButton(Text.Black, Color.black), this.createColorTestButton(Text.Reg, Color.red), this.createColorTestButton(Text.Green, Color.green), this.createColorTestButton(Text.Blue, Color.blue), null, this.createPopScreenButton()});
    }

    private MenuItem createPopScreenButton() {
        return new PushButton(Text.Back, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayTestScreen.this.getScreenManager().popScreen();
            }
        });
    }

    private MenuItem createChameleonTestButton(String string, final float f) {
        PushButton pushButton = new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayTestScreen.this.doTest(new Chameleon(f));
            }
        });
        return pushButton;
    }

    private MenuItem createColorTestButton(String string, final Color color) {
        PushButton pushButton = new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayTestScreen.this.doTest(new Glue(1, 1, color));
            }
        });
        pushButton.setNameColor(DisplayTestScreen.inverse(color));
        pushButton.setBorderConfig(DisplayTestScreen.colorizeBorder(pushButton.getBorderConfig(), color));
        pushButton.setBorderConfigPressed(DisplayTestScreen.colorizeBorder(pushButton.getBorderConfigPressed(), color));
        return pushButton;
    }

    private static HydroBorderPainterConfig colorizeBorder(HydroBorderPainterConfig hydroBorderPainterConfig, Color color) {
        return new HydroBorderPainterConfig(color, hydroBorderPainterConfig.getBorderWidth(), hydroBorderPainterConfig.getBorderColors());
    }

    private static Color inverse(Color color) {
        return new Color(~color.getRGB() & 0xFFFFFF);
    }

    private void doTest(Component component) {
        ScreenManager screenManager = this.getScreenManager();
        screenManager.installFullscreenComponent(component);
        GlobalKeyManager.registerInstance(new FullscreenTestKeyManager(screenManager));
    }

    public static MenuItem createExtrasButton(String string) {
        return new InvisibleSubMenuButton("Extras", string, new Menu("Extras", new MenuItem[]{ScreenButton.newPushingButton("Tetris", new TetrisScreen()), ScreenButton.newPushingButton("Nibbles", new SnakeScreen()), null, null, null, null}));
    }

    static class Piece
    implements Cloneable {
        private boolean[] bitmap;
        private int x;
        private int y;
        private int width;
        private int height;
        private Color color;

        Piece(boolean[] blArray, int n, int n2, Color color) {
            this.bitmap = blArray;
            this.width = n;
            this.height = n2;
            this.color = color;
        }

        public boolean[] bitmap() {
            return this.bitmap;
        }

        public boolean bitAt(int n, int n2) {
            return this.bitmap[n2 * this.width + n];
        }

        public int x() {
            return this.x;
        }

        public void x(int n) {
            this.x = n;
        }

        public int y() {
            return this.y;
        }

        public void y(int n) {
            this.y = n;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public Color color() {
            return this.color;
        }

        public boolean collidesWith(Piece piece) {
            int n = Math.max(this.x, piece.x);
            int n2 = Math.max(this.y, piece.y);
            int n3 = Math.min(this.x + this.width - 1, piece.x + piece.width - 1);
            int n4 = Math.min(this.y + this.height - 1, piece.y + piece.height - 1);
            for (int i = n2; i <= n4; ++i) {
                for (int j = n; j <= n3; ++j) {
                    if (!this.bitAt(j - this.x, i - this.y) || !piece.bitAt(j - piece.x, i - piece.y)) continue;
                    return true;
                }
            }
            return false;
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public void rotateLeft() {
            this.doRotate(true, false);
        }

        public void rotateRight() {
            this.doRotate(false, true);
        }

        private void doRotate(boolean bl, boolean bl2) {
            boolean[] blArray = new boolean[this.bitmap.length];
            int n = this.height;
            int n2 = this.width;
            int n3 = 0;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n4 = bl2 ? this.height - i - 1 : i;
                    int n5 = bl ? this.width - j - 1 : j;
                    blArray[n5 * n + n4] = this.bitmap[n3++];
                }
            }
            this.bitmap = blArray;
            this.width = n;
            this.height = n2;
        }
    }

    static class Tetris
    extends JComponent {
        private static final int NO_GAME = 0;
        private static final int PLAYING = 1;
        private static final int PAUSED = 2;
        private static final int GAME_OVER = 3;
        private TetrisScreen screen;
        private WrappedTimer tickTimer;
        private WrappedTimer messageSlideTimer;
        private int gameState;
        private Vector messages = new Vector();
        private static final Piece[] prototypePieces = new Piece[]{new Piece(new boolean[]{true, false, false, true, true, true}, 3, 2, Color.yellow), new Piece(new boolean[]{false, false, true, true, true, true}, 3, 2, Color.green), new Piece(new boolean[]{true, true, true, true}, 1, 4, Color.red), new Piece(new boolean[]{true, false, true, true, false, true}, 2, 3, Color.orange), new Piece(new boolean[]{false, true, true, true, true, false}, 2, 3, Color.pink), new Piece(new boolean[]{true, true, true, true}, 2, 2, Color.blue)};
        private static final int borderSize = 4;
        private static final int margin = 1;
        private static final int blockSize = 14;
        private static final int pointsPerBlock = 10;
        private static final int piecesForLevelAdvance = 21;
        private static final int levelScoringMultiplier = 15;
        private final Dimension boardSize = new Dimension(14, 22);
        private final Dimension drawSize = this.calcBoardSize();
        private Vector pieces = new Vector();
        private Random random = new Random();
        private Piece activePiece;
        private Piece nextPiece;
        private int level;
        private int score;
        private int placedPieceCount;

        public Tetris(TetrisScreen tetrisScreen) {
            this.screen = tetrisScreen;
            this.setBackground(Color.black);
            this.gameState = 0;
            this.messageSlideTimer = new WrappedTimer(100, new ActionListener(this){
                private final /* synthetic */ Tetris this$0;
                {
                    this.this$0 = tetris;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Tetris.access$400(this.this$0);
                }
            });
            this.tickTimer = new WrappedTimer(0, new ActionListener(this){
                private final /* synthetic */ Tetris this$0;
                {
                    this.this$0 = tetris;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Tetris.access$500(this.this$0);
                }
            });
        }

        public void dispose() {
            this.tickTimer.stop();
            this.messageSlideTimer.stop();
        }

        protected void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.getBoardSize();
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            graphics.translate(n, n2);
            this.paintBoard(graphics);
            if (this.gameState == 2) {
                GameUtilities.fillWithGrayShade(graphics, 0, 0, dimension2.width, dimension2.height);
            }
            graphics.translate(-n, -n2);
            this.paintMessages(graphics, n + dimension2.width, (dimension.width - dimension2.width) / 2);
            if (this.gameState == 3) {
                graphics.setColor(Color.white);
                graphics.setFont(GameUtilities.gameOverFont);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                String string = "GAME OVER";
                graphics.drawString(string, n + (dimension2.width - fontMetrics.stringWidth(string)) / 2, n2 + dimension2.height / 2);
            } else if (this.gameState == 2) {
                graphics.setColor(Color.white);
                graphics.setFont(GameUtilities.gameOverFont);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                String string = "PAUSED";
                graphics.drawString(string, n + (dimension2.width - fontMetrics.stringWidth(string)) / 2, n2 + dimension2.height / 2);
            }
            if (this.gameState == 0) {
                graphics.setColor(Color.white);
                graphics.setFont(GameUtilities.startupMessageFont);
                graphics.drawString("Press the New Game button", n + 10, n2 + 30);
                graphics.drawString("to begin a game.", n + 10, n2 + 50);
                graphics.drawString("Use the RPG dial to", n + 10, n2 + 70);
                graphics.drawString("move the current piece", n + 10, n2 + 90);
                graphics.drawString("and the Up/Down arrows to", n + 10, n2 + 110);
                graphics.drawString("rotate it right/left.", n + 10, n2 + 130);
            } else {
                this.paintScoreboard(graphics);
            }
        }

        private void paintMessages(Graphics graphics, int n, int n2) {
            Message message;
            int n3;
            Vector<Message> vector = new Vector<Message>(2);
            for (n3 = 0; n3 < this.messages.size(); ++n3) {
                message = (Message)this.messages.elementAt(n3);
                graphics.setFont(new Font("SansSerif", 0, message.size));
                int n4 = 255 - message.offset;
                if (n4 < 1) {
                    vector.addElement(message);
                    continue;
                }
                graphics.setColor(new Color(0, n4 / 2, n4));
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.drawString(message.text, n + (n2 - fontMetrics.stringWidth(message.text)) / 2, 40 + fontMetrics.getAscent() + message.offset);
            }
            for (n3 = 0; n3 < vector.size(); ++n3) {
                message = (Message)vector.elementAt(n3);
                this.messages.removeElement(message);
            }
        }

        private void tickMessages() {
            for (int i = 0; i < this.messages.size(); ++i) {
                Message message = (Message)this.messages.elementAt(i);
                message.tick();
            }
            if (this.messages.size() > 0) {
                this.repaint();
            }
        }

        void showMessage(String string) {
            this.messages.addElement(new Message(string));
            this.tickMessages();
            this.messageSlideTimer.restart();
        }

        private void paintScoreboard(Graphics graphics) {
            int n = (this.getSize().width - this.getBoardSize().width) / 2 - 10;
            graphics.setColor(GameUtilities.SCOREBOARD_BACKGROUND);
            graphics.fillRect(5, 5, n, 160);
            graphics.setFont(GameUtilities.scoreboardFont);
            graphics.setColor(Color.white);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = 10 + fontMetrics.getAscent();
            graphics.drawString("Level: " + this.level, 10, n2);
            graphics.drawString("Score: " + this.score, 10, n2 += fontMetrics.getHeight());
            graphics.drawString("Next piece: ", 10, n2 += fontMetrics.getHeight());
            n2 += fontMetrics.getHeight();
            if (this.nextPiece != null) {
                this.drawPiece(graphics, this.nextPiece, 10, n2);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getBoardSize();
            return new Dimension(dimension.width + 100, dimension.height);
        }

        public void advancePiece() {
            if (this.gameState != 1) {
                return;
            }
            this.tickNow();
        }

        private void tickNow() {
            this.tick();
            this.tickTimer.restart();
        }

        private boolean testAndSetGameState(int n, int n2) {
            if (this.gameState == n) {
                this.gameState = n2;
                return true;
            }
            return false;
        }

        public void pause() {
            if (this.testAndSetGameState(1, 2)) {
                this.tickTimer.stop();
                this.messageSlideTimer.stop();
                this.repaint();
            }
        }

        public void resume() {
            if (this.testAndSetGameState(2, 1)) {
                this.tickTimer.start();
                this.messageSlideTimer.start();
                this.repaint();
            }
        }

        public boolean isPaused() {
            return this.gameState == 2;
        }

        public void gameOver() {
            this.gameState = 3;
            this.tickTimer.stop();
            this.messageSlideTimer.stop();
            this.repaint();
            this.screen.handleGameOver(this.score, this.level);
        }

        public void newGame() {
            this.pieces.removeAllElements();
            this.activePiece = null;
            this.resetLevel();
            this.score = 0;
            this.placedPieceCount = 0;
            this.gameState = 1;
            this.tickTimer.start();
            this.messageSlideTimer.start();
            this.repaint();
        }

        public Dimension getBoardSize() {
            return new Dimension(this.drawSize);
        }

        private Dimension calcBoardSize() {
            int n = 10;
            return new Dimension(n + this.boardSize.width * 14, n + this.boardSize.height * 14);
        }

        private boolean addPiece() {
            if (this.nextPiece == null) {
                this.nextPiece = this.getRandomPiece();
            }
            this.activePiece = this.nextPiece;
            this.nextPiece = this.getRandomPiece();
            this.pieces.addElement(this.activePiece);
            this.activePiece.x((this.boardSize.width - this.activePiece.width()) / 2);
            this.activePiece.y(0);
            return !this.isInvalidPlacement(this.activePiece);
        }

        private Piece getRandomPiece() {
            int n = (this.random.nextInt() & Integer.MAX_VALUE) % prototypePieces.length;
            Piece piece = (Piece)prototypePieces[n].clone();
            return piece;
        }

        public void resetLevel() {
            this.level = 1;
            this.calculateTickDelay();
        }

        public void incLevel() {
            ++this.level;
            this.calculateTickDelay();
        }

        private void calculateTickDelay() {
            this.tickTimer.setDelay(Tetris.getTickDelayForLevel(this.level));
        }

        static int getTickDelayForLevel(int n) {
            return 180 + 440 / n;
        }

        private void commitPiece() {
            Piece piece = this.activePiece;
            this.activePiece = null;
            this.pieces.removeElement(piece);
            ++this.placedPieceCount;
            if (this.placedPieceCount % 21 == 0) {
                this.incLevel();
            }
            for (int i = 0; i < piece.height(); ++i) {
                for (int j = 0; j < piece.width(); ++j) {
                    if (!piece.bitAt(j, i)) continue;
                    Piece piece2 = new Piece(new boolean[]{true}, 1, 1, piece.color());
                    piece2.x(piece.x() + j);
                    piece2.y(piece.y() + i);
                    this.pieces.addElement(piece2);
                }
            }
            this.paintImmediately(new Rectangle(this.getSize()));
            this.removeCompleteRows();
            this.repaint();
        }

        private void removeCompleteRows() {
            int n;
            int n2;
            int[] nArray = new int[this.boardSize.height];
            for (n2 = 0; n2 < this.pieces.size(); ++n2) {
                Piece piece = (Piece)this.pieces.elementAt(n2);
                int n3 = piece.y();
                nArray[n3] = nArray[n3] + 1;
            }
            n2 = 0;
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != this.boardSize.width) continue;
                ++n2;
                this.removeRow(n);
            }
            n = this.calculateScoreForCompletedRows(n2);
            this.score += n;
            if (n != 0) {
                this.showMessage("" + n);
            }
        }

        private int calculateScoreForCompletedRows(int n) {
            int n2 = this.boardSize.width * 10;
            return (n2 *= 1 << n - 1) + n2 * 15 * this.level / 100;
        }

        private void removeRow(int n) {
            Piece piece;
            int n2;
            Vector<Piece> vector = new Vector<Piece>(6);
            for (n2 = 0; n2 < this.pieces.size(); ++n2) {
                piece = (Piece)this.pieces.elementAt(n2);
                if (piece.y() < n) {
                    piece.y(piece.y() + 1);
                    continue;
                }
                if (piece.y() != n) continue;
                vector.addElement(piece);
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                piece = (Piece)vector.elementAt(n2);
                this.pieces.removeElement(piece);
            }
        }

        private void tick() {
            if (this.activePiece != null) {
                if (!this.tryToMovePiece(this.activePiece, this.activePiece.x(), this.activePiece.y() + 1)) {
                    this.commitPiece();
                }
            } else if (!this.addPiece()) {
                this.gameOver();
            }
            this.repaint();
        }

        public void movePiece(int n) {
            if (this.gameState != 1) {
                return;
            }
            if (this.activePiece != null) {
                this.tryToMovePiece(this.activePiece, this.activePiece.x() + n, this.activePiece.y());
            }
            this.repaint();
        }

        public void dropPiece() {
            if (this.gameState != 1) {
                return;
            }
            if (this.activePiece != null) {
                while (this.tryToMovePiece(this.activePiece, this.activePiece.x(), this.activePiece.y() + 1)) {
                }
                this.commitPiece();
            }
        }

        private boolean tryToMovePiece(Piece piece, int n, int n2) {
            int n3 = piece.x();
            int n4 = piece.y();
            piece.x(n);
            piece.y(n2);
            if (this.isInvalidPlacement(piece)) {
                piece.x(n3);
                piece.y(n4);
                return false;
            }
            return true;
        }

        private boolean isInvalidPlacement(Piece piece) {
            return this.collidesWithAnyPiece(piece) || this.isOutOfBounds(piece);
        }

        private boolean isOutOfBounds(Piece piece) {
            return piece.x() < 0 || piece.y() < 0 || piece.x() + piece.width() > this.boardSize.width || piece.y() + piece.height() > this.boardSize.height;
        }

        private boolean collidesWithAnyPiece(Piece piece) {
            for (int i = 0; i < this.pieces.size(); ++i) {
                Piece piece2 = (Piece)this.pieces.elementAt(i);
                if (piece2 == piece || !piece2.collidesWith(piece)) continue;
                return true;
            }
            return false;
        }

        private void paintBoard(Graphics graphics) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.drawSize.width, this.drawSize.height);
            this.drawBorder(graphics, 0, 0, this.drawSize.width, this.drawSize.height, 4);
            this.drawPieces(graphics);
        }

        private void drawPieces(Graphics graphics) {
            for (int i = 0; i < this.pieces.size(); ++i) {
                Piece piece = (Piece)this.pieces.elementAt(i);
                this.drawPiece(graphics, piece, 5, 5);
            }
        }

        private void drawPiece(Graphics graphics, Piece piece, int n, int n2) {
            boolean[] blArray = piece.bitmap();
            int n3 = 0;
            for (int i = 0; i < piece.height(); ++i) {
                int n4 = 0;
                while (n4 < piece.width()) {
                    if (blArray[n3]) {
                        this.drawBlock(graphics, n + (piece.x() + n4) * 14, n2 + (piece.y() + i) * 14, piece.color());
                    }
                    ++n4;
                    ++n3;
                }
            }
        }

        private static Color adjustBrightness(Color color, int n) {
            return new Color(Math.max(0, Math.min(color.getRed() + n, 255)), Math.max(0, Math.min(color.getGreen() + n, 255)), Math.max(0, Math.min(color.getBlue() + n, 255)));
        }

        private void drawBlock(Graphics graphics, int n, int n2, Color color) {
            int n3 = 13;
            graphics.setColor(Tetris.adjustBrightness(color, 160));
            graphics.drawLine(n, n2, n + n3, n2);
            graphics.drawLine(n, n2, n, n2 + n3);
            graphics.setColor(Tetris.adjustBrightness(color, -160));
            graphics.drawLine(n, n2 + n3, n + n3, n2 + n3);
            graphics.drawLine(n + n3, n2, n + n3, n2 + n3);
            graphics.setColor(color);
            graphics.fillRect(n + 1, n2 + 1, n3 - 1, n3 - 1);
        }

        private void drawBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            graphics.setColor(Color.white);
            for (int i = 0; i < n5; ++i) {
                graphics.drawLine(n, n2 + i, n + n3 - 1, n2 + i);
                graphics.drawLine(n, n2 + n4 - 1 - i, n + n3 - 1, n2 + n4 - 1 - i);
                graphics.drawLine(n + i, n2, n + i, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1 - i, n2, n + n3 - 1 - i, n2 + n4 - 1);
            }
            if (this.activePiece != null) {
                graphics.setColor(Color.red);
                Rectangle rectangle = new Rectangle(5 + this.activePiece.x() * 14, n4 - n5, 14 * this.activePiece.width(), n5);
                graphics.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            }
        }

        public void rotateLeft() {
            if (this.gameState != 1) {
                return;
            }
            if (this.activePiece != null) {
                this.activePiece.rotateLeft();
                if (this.isInvalidPlacement(this.activePiece)) {
                    this.activePiece.rotateRight();
                }
            }
            this.repaint();
        }

        public void rotateRight() {
            if (this.gameState != 1) {
                return;
            }
            if (this.activePiece != null) {
                this.activePiece.rotateRight();
                if (this.isInvalidPlacement(this.activePiece)) {
                    this.activePiece.rotateLeft();
                }
            }
            this.repaint();
        }

        static /* synthetic */ void access$400(Tetris tetris) {
            tetris.tickMessages();
        }

        static /* synthetic */ void access$500(Tetris tetris) {
            tetris.tick();
        }

        private static class Message {
            final String text;
            int size;
            int offset;

            Message(String string) {
                this.text = string;
                this.size = 36;
                this.offset = 0;
            }

            void tick() {
                this.size -= 2;
                this.offset += 10;
            }
        }
    }

    static class TetrisScreen
    extends Screen
    implements ScrollWheelListener {
        private static final String prefix = "ts";
        private Tetris game;
        private HighScoreListHelper highScoreHelper;

        TetrisScreen() {
        }

        public void installScreen(ScreenManager screenManager) {
            super.installScreen(screenManager);
            screenManager.getLeftMenuPanel().installMenu(this.createLeftMenu());
            screenManager.getRightMenuPanel().installMenu(this.createRightMenu());
            this.game = new Tetris(this);
            screenManager.installDisplay(new BorderWrapper(this.game, TraceAnalyzer.getChartBorder(), true));
            this.highScoreHelper = new HighScoreListHelper("Tetris", prefix);
            Command command = Command.makeGetCommand(this.highScoreHelper.getTopic());
            command.addProperty(this.highScoreHelper.getKeyLastNameEntered(), "");
            MeasurementFactory.instance().getCommandProcessor().send(command);
            ScrollWheelManager.instance().addScrollWheelListener(this);
        }

        public void uninstallScreen(ScreenManager screenManager) {
            ScrollWheelManager.instance().removeScrollWheelListener(this);
            this.game.pause();
            this.game = null;
            this.highScoreHelper = null;
            super.uninstallScreen(screenManager);
        }

        private Menu createLeftMenu() {
            return new Menu("Tetris", new MenuItem[]{this.createNewGameButton(), this.createHighScoreListButton(), null, this.createDownButton(), this.createDropButton(), this.createRotateLeftButton(), this.createLeftButton()});
        }

        private MenuItem createNewGameButton() {
            return new PushButton("New Game", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$100(this.this$0).newGame();
                }
            });
        }

        private MenuItem createHighScoreListButton() {
            return new PushButton("High Scores", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$100(this.this$0).pause();
                    TetrisScreen.access$200(this.this$0).showHighScores(null);
                }
            });
        }

        private MenuItem createDownButton() {
            return new PushButton("Down", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$100(this.this$0).advancePiece();
                }
            });
        }

        private MenuItem createDropButton() {
            return new PushButton("Drop", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$100(this.this$0).dropPiece();
                }
            });
        }

        private Menu createRightMenu() {
            return new Menu("", new MenuItem[]{this.createPauseButton(), this.createQuitButton(), null, null, null, this.createRotateRightButton(), this.createRightButton()});
        }

        private MenuItem createLeftButton() {
            return new PushButton("Left", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$100(this.this$0).movePiece(-1);
                }
            });
        }

        private MenuItem createRightButton() {
            return new PushButton("Right", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$100(this.this$0).movePiece(1);
                }
            });
        }

        private MenuItem createRotateLeftButton() {
            return new PushButton("Rotate\nLeft", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$100(this.this$0).rotateLeft();
                }
            });
        }

        private MenuItem createRotateRightButton() {
            return new PushButton("Rotate\nRight", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$100(this.this$0).rotateRight();
                }
            });
        }

        private MenuItem createPauseButton() {
            return new PushButton("Pause", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TetrisScreen.access$100(this.this$0).isPaused()) {
                        TetrisScreen.access$100(this.this$0).resume();
                    } else {
                        TetrisScreen.access$100(this.this$0).pause();
                    }
                }
            });
        }

        private MenuItem createQuitButton() {
            return new PushButton("Quit", "", new ActionListener(this){
                private final /* synthetic */ TetrisScreen this$0;
                {
                    this.this$0 = tetrisScreen;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TetrisScreen.access$300(this.this$0);
                }
            });
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 40) {
                this.game.rotateLeft();
            } else if (keyEvent.getKeyCode() == 38) {
                this.game.rotateRight();
            } else {
                return;
            }
            keyEvent.consume();
        }

        public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
            int n = scrollWheelEvent.getUnitsMoved();
            int n2 = n < 0 ? -1 : 1;
            for (int i = Math.abs(n); i > 0; --i) {
                this.game.movePiece(n2);
            }
            scrollWheelEvent.consume();
        }

        public void scrollWheelMoveComplete() {
        }

        private void quit() {
            this.getScreenManager().popScreen();
        }

        public void handleGameOver(int n, int n2) {
            if (this.highScoreHelper != null) {
                this.highScoreHelper.handleGameOver(n, n2);
            }
        }

        static /* synthetic */ Tetris access$100(TetrisScreen tetrisScreen) {
            return tetrisScreen.game;
        }

        static /* synthetic */ HighScoreListHelper access$200(TetrisScreen tetrisScreen) {
            return tetrisScreen.highScoreHelper;
        }

        static /* synthetic */ void access$300(TetrisScreen tetrisScreen) {
            tetrisScreen.quit();
        }
    }

    private static class Chameleon
    extends JComponent
    implements ScrollWheelListener {
        private float hue = 0.0f;
        private float brightness;

        Chameleon(float f) {
            this.brightness = f;
            this.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ Chameleon this$0;
                {
                    this.this$0 = chameleon;
                }

                public void componentShown(ComponentEvent componentEvent) {
                    ScrollWheelManager.instance().addScrollWheelListener(this.this$0);
                }

                public void componentHidden(ComponentEvent componentEvent) {
                    ScrollWheelManager.instance().removeScrollWheelListener(this.this$0);
                }
            });
            this.updateColor();
        }

        private void updateColor() {
            Color color = new Color(Color.HSBtoRGB(this.hue, 1.0f, this.brightness));
            this.setBackground(color);
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }

        public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
            this.hue += (float)scrollWheelEvent.getWheelRotation() / 120.0f;
            this.updateColor();
            this.repaint();
        }

        public void scrollWheelMoveComplete() {
        }
    }

    private static class InvisibleSubMenuButton
    extends SubMenuButton {
        long last = 0L;
        int count = 0;

        public InvisibleSubMenuButton(String string, String string2, Menu menu) {
            super(string, string2, menu);
        }

        public void press() {
            long l = System.currentTimeMillis();
            if (l - this.last > 1000L) {
                this.count = 0;
            }
            this.last = l;
            if (++this.count == 3) {
                this.count = 0;
                super.press();
            }
        }

        public void paint(Graphics graphics, int n, int n2) {
        }
    }
}

