/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.manufacturing;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.Comparator;

class HighScoreList {
    private static final int SCORES = 10;
    private static final String SCOREKEY = "sc";
    private static final String LEVELKEY = "lv";
    private static final String NAMEKEY = "nm";
    private final String topic;
    private final String keyPrefix;
    private final Entry[] entries;
    private static final Comparator entryComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            return entry2.getScore() - entry.getScore();
        }
    };

    public HighScoreList(String string, String string2) {
        this.topic = string;
        this.keyPrefix = string2;
        this.entries = new Entry[10];
        this.load();
    }

    private void load() {
        CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
        Command command = Command.makeGetCommand(this.topic);
        for (int i = 0; i < 10; ++i) {
            command.addProperty(this.keyPrefix + SCOREKEY + i, 0L);
            command.addProperty(this.keyPrefix + LEVELKEY + i, 0L);
            command.addProperty(this.keyPrefix + NAMEKEY + i, "-");
        }
        try {
            Command command2 = commandProcessor.call(command, "set");
            for (int i = 0; i < 10; ++i) {
                this.entries[i] = new Entry(Integer.parseInt(command2.getProperty(this.keyPrefix + SCOREKEY + i)), Integer.parseInt(command2.getProperty(this.keyPrefix + LEVELKEY + i)), command2.getProperty(this.keyPrefix + NAMEKEY + i));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get high score list: " + exception);
        }
    }

    private void store() {
        CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
        Command command = Command.makeSetCommand(this.topic);
        for (int i = 0; i < this.entries.length; ++i) {
            Entry entry = this.entries[i];
            command.addProperty(this.keyPrefix + SCOREKEY + i, entry.getScore());
            command.addProperty(this.keyPrefix + LEVELKEY + i, entry.getLevel());
            command.addProperty(this.keyPrefix + NAMEKEY + i, entry.getName());
        }
        commandProcessor.send(command);
    }

    public int size() {
        return 10;
    }

    public int getMinScore() {
        return this.getEntry(this.size() - 1).getScore();
    }

    public Entry getEntry(int n) {
        return this.entries[n];
    }

    public void addEntry(Entry entry) {
        int n;
        Object[] objectArray = new Entry[this.size() + 1];
        for (n = 0; n < this.entries.length; ++n) {
            objectArray[n] = this.entries[n];
        }
        objectArray[this.size()] = entry;
        Arrays.sort(objectArray, entryComparator);
        for (n = 0; n < this.entries.length; ++n) {
            this.entries[n] = objectArray[n];
        }
        this.store();
    }

    public static class Entry {
        private final int score;
        private final int level;
        private final String name;

        public Entry(int n, int n2, String string) {
            this.score = n;
            this.level = n2;
            this.name = string;
        }

        public int getScore() {
            return this.score;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }
    }
}

