/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.manufacturing;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.manufacturing.HighScoreList;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public class HighScoreListHelper {
    private static final String topic = "system";
    private final String description;
    private final String prefix;
    private final HighScoreList highScoreList;
    private final SettingsModel settingsModel;

    public HighScoreListHelper(String string, String string2) {
        this.description = string;
        this.prefix = string2;
        this.highScoreList = new HighScoreList(topic, string2);
        this.settingsModel = MeasurementFactory.instance().getSettingsModel(topic);
    }

    public String getTopic() {
        return topic;
    }

    public String getKeyLastNameEntered() {
        return this.prefix + "lastEntered";
    }

    public void handleGameOver(final int n, final int n2) {
        if (n > this.highScoreList.getMinScore()) {
            final String string = this.getKeyLastNameEntered();
            String string2 = this.settingsModel.getString(string);
            if (string2 == null) {
                string2 = "";
            }
            Value value = Value.createValue("New high score! Enter your name:", string2);
            value.addValueListener(new ValueListener(){
                private final String listenerName = "highScoreNameListener";

                public String getListenerName() {
                    return "highScoreNameListener";
                }

                public void valueChanged(ValueInterface valueInterface) {
                    String string2 = ((Object)valueInterface).toString();
                    HighScoreListHelper.this.settingsModel.set(string, string2);
                    Command command = Command.makeSetCommand(HighScoreListHelper.topic);
                    command.addProperty(string, string2);
                    MeasurementFactory.instance().getCommandProcessor().send(command);
                    HighScoreList.Entry entry = new HighScoreList.Entry(n, n2, string2);
                    HighScoreListHelper.this.highScoreList.addEntry(entry);
                    HighScoreListHelper.this.showHighScores(entry);
                }
            });
            MeasurementFactory.instance().getScreenManager().pushScreen(new AlphaEditScreen(value));
        }
    }

    public void showHighScores(HighScoreList.Entry entry) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><h1>").append(this.description).append(" - High Scores</h1><br><br>");
        stringBuffer.append("<table>");
        stringBuffer.append("<tr><td width=\"10%\"><b>Rank</b></td><td width=\"25%\"><b>Score</b></td><td width=\"10%\"><b>Level</b></td><td width=\"55%\"><b>Name</b></td></tr>");
        for (int i = 0; i < this.highScoreList.size(); ++i) {
            HighScoreList.Entry entry2 = this.highScoreList.getEntry(i);
            boolean bl = entry2 == entry;
            String string = bl ? "<b>" : "";
            String string2 = bl ? "</b>" : "";
            stringBuffer.append("<tr>");
            stringBuffer.append("<td width=\"10%\">").append(string).append(i + 1).append(string2).append("</td>");
            stringBuffer.append("<td width=\"25%\">").append(string).append(entry2.getScore()).append(string2).append("</td>");
            stringBuffer.append("<td width=\"10%\">").append(string).append(entry2.getLevel()).append(string2).append("</td>");
            stringBuffer.append("<td width=\"55%\">").append(string).append(entry2.getName()).append(string2).append("</td>");
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table></body>");
        MessageScreen messageScreen = new MessageScreen(stringBuffer.toString(), true, 0);
        MeasurementFactory.instance().getScreenManager().pushScreen(messageScreen);
    }
}

