/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.manufacturing;

import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.manufacturing.KeyboardTestKeyManager;
import elgato.infrastructure.manufacturing.KeyboardTestModel;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.Comparator;
import elgato.infrastructure.util.FastMath;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.Timer;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.BorderWrapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JComponent;

public class KeyboardTestScreen
extends Screen
implements ScrollWheelListener {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$manufacturing$KeyboardTestScreen == null ? (class$elgato$infrastructure$manufacturing$KeyboardTestScreen = KeyboardTestScreen.class$("elgato.infrastructure.manufacturing.KeyboardTestScreen")) : class$elgato$infrastructure$manufacturing$KeyboardTestScreen);
    private KeyboardTestPanel keyboardTestPanel;
    private KeyboardTestModel model;
    static /* synthetic */ Class class$elgato$infrastructure$manufacturing$KeyboardTestScreen;
    static /* synthetic */ Class class$elgato$infrastructure$manufacturing$KeyboardTestScreen$Model;

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.model = new KeyboardTestModel();
        this.installTestPanel();
        this.model.registerPropertyChangedListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                KeyboardTestScreen.this.keyboardTestPanel.repaint();
            }
        });
        screenManager.installLeftMenu(this.createLeftMenu());
        screenManager.installRightMenu(this.createRightMenu());
        GlobalKeyManager.registerInstance(new KeyboardTestKeyManager(screenManager, this.model));
        ScrollWheelManager.instance().addScrollWheelListener(this);
    }

    public void uninstallScreen(ScreenManager screenManager) {
        ScrollWheelManager.instance().removeScrollWheelListener(this);
        GlobalKeyManager.registerInstance(GlobalKeyManager.makeInstance(screenManager));
        super.uninstallScreen(screenManager);
    }

    public KeyboardTestModel getModel() {
        return this.model;
    }

    private void installTestPanel() {
        this.keyboardTestPanel = new KeyboardTestPanel();
        this.getScreenManager().installDisplay(new BorderWrapper(this.keyboardTestPanel, TraceAnalyzer.getChartBorder(), true));
    }

    Menu createRightMenu() {
        MenuItem[] menuItemArray = new MenuItem[7];
        for (int i = 0; i < 7; ++i) {
            menuItemArray[i] = new PushButton("Button " + i + "\n" + this.model.getSoftRightKey(i), "", new RightActionListener(i, menuItemArray, this.model));
        }
        return new Menu(Text.Keyboard_Test, menuItemArray);
    }

    Menu createLeftMenu() {
        MenuItem[] menuItemArray = new MenuItem[7];
        for (int i = 0; i < 7; ++i) {
            menuItemArray[i] = new PushButton("Button " + i + "\n" + this.model.getSoftLeftKey(i), "", new LeftActionListener(i, menuItemArray, this.model));
        }
        return new Menu("", menuItemArray);
    }

    public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
        int n = scrollWheelEvent.getUnitsMoved();
        if (n != 0) {
            this.model.setScrollWheelCount(this.model.getScrollWheelCount() + n);
        }
        this.model.setScrollWheelRotation(this.model.getScrollWheelRotation() + scrollWheelEvent.getWheelRotation());
    }

    public void scrollWheelMoveComplete() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Renderer {
        private int[] vertices;
        private int[] patches;
        private int nPatches;
        private int rx;
        private int ry;
        private int rz;
        private final Timer process1Timer = new Timer("Renderer/process1");
        private final Timer rotateTimer = new Timer("Renderer/rotate");
        private final Timer projectTimer = new Timer("Renderer/project");
        private final Timer depthSortTimer = new Timer("Renderer/depthSort");
        private final Timer drawTimer = new Timer("Renderer/draw");

        public void setRotation(int n, int n2, int n3) {
            this.rx = n;
            this.ry = n2;
            this.rz = n3;
        }

        public void processModel(Model model) {
            this.process1Timer.start();
            if (this.vertices == null || this.vertices.length != model.vertices.length) {
                this.vertices = new int[model.vertices.length];
            }
            System.arraycopy(model.vertices, 0, this.vertices, 0, this.vertices.length);
            if (this.patches == null || this.patches.length != model.patches.length) {
                this.patches = new int[model.patches.length];
            }
            this.nPatches = this.patches.length / 3;
            System.arraycopy(model.patches, 0, this.patches, 0, this.patches.length);
            this.process1Timer.stop();
            this.rotateTimer.start();
            this.rotateVertices(this.vertices, this.rx, this.ry, this.rz);
            this.rotateTimer.stop();
        }

        public void render(Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = 196608;
            this.projectTimer.start();
            this.project(this.vertices, -262144, n5);
            this.projectTimer.stop();
            this.depthSortTimer.start();
            Object[] objectArray = new Integer[this.nPatches];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = new Integer(i);
            }
            Arrays.sort(objectArray, new Comparator(this){
                private final /* synthetic */ Renderer this$0;
                {
                    this.this$0 = renderer;
                }

                public int compare(Object object, Object object2) {
                    int n;
                    int n2 = (Integer)object;
                    int n3 = (Integer)object2;
                    int n4 = Renderer.access$500(this.this$0, Renderer.access$300(this.this$0), Renderer.access$400(this.this$0), n2, 2);
                    return n4 < (n = Renderer.access$500(this.this$0, Renderer.access$300(this.this$0), Renderer.access$400(this.this$0), n3, 2)) ? -1 : (n4 > n ? 1 : 0);
                }
            });
            this.depthSortTimer.stop();
            this.drawTimer.start();
            Color color = graphics.getColor();
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            int n6 = 196608 / Math.min(n3, n4);
            Vec3i[] vec3iArray = new Vec3i[]{new Vec3i(), new Vec3i(), new Vec3i()};
            Vec3i vec3i = new Vec3i(-256, 200, -400);
            vec3i.normalize();
            for (int i = 0; i < objectArray.length; ++i) {
                int n7;
                int n8;
                int n9 = (Integer)objectArray[i];
                int n10 = n9 * 3;
                for (int j = 0; j < 3; ++j) {
                    n8 = this.patches[n10 + j];
                    n7 = n8 * 3;
                    vec3iArray[j].x = this.vertices[n7];
                    vec3iArray[j].y = this.vertices[n7 + 1];
                    vec3iArray[j].z = this.vertices[n7 + 2];
                    nArray[j] = n + n3 / 2 + this.vertices[n7] / n6;
                    nArray2[j] = n2 + n4 / 2 - this.vertices[n7 + 1] / n6;
                }
                Vec3i vec3i2 = Vec3i.normal(vec3iArray[0], vec3iArray[1], vec3iArray[2]);
                n8 = vec3i2.dot(vec3i);
                n10 = ((65536 - n8) * 40 >> 16) + 16;
                n7 = 0;
                int n11 = 153;
                int n12 = 204;
                graphics.setColor(new Color(Renderer.boundUint8(n7 + n10), Renderer.boundUint8(n11 + n10), Renderer.boundUint8(n12 + n10)));
                graphics.fillPolygon(nArray, nArray2, 3);
            }
            this.drawTimer.stop();
            graphics.setColor(color);
        }

        private void project(int[] nArray, int n, int n2) {
            for (int i = 0; i < nArray.length; i += 3) {
                int n3 = nArray[i];
                int n4 = nArray[i + 1];
                int n5 = nArray[i + 2];
                n3 = (int)((long)n3 * (long)n2 / (long)(n5 += n));
                n4 = (int)((long)n4 * (long)n2 / (long)n5);
                nArray[i] = n3;
                nArray[i + 1] = n4;
                nArray[i + 2] = n5;
            }
        }

        private void rotateVertices(int[] nArray, int n, int n2, int n3) {
            int n4 = FastMath.sin(n);
            int n5 = FastMath.sin(n2);
            int n6 = FastMath.sin(n3);
            int n7 = FastMath.cos(n);
            int n8 = FastMath.cos(n2);
            int n9 = FastMath.cos(n3);
            for (int i = 0; i < nArray.length; i += 3) {
                int n10 = nArray[i];
                int n11 = nArray[i + 1];
                int n12 = nArray[i + 2];
                int n13 = (int)((long)n12 * (long)n4 >> 16) + (int)((long)n11 * (long)n7 >> 16);
                int n14 = (int)((long)n12 * (long)n7 >> 16) - (int)((long)n11 * (long)n4 >> 16);
                int n15 = (int)((long)n10 * (long)n8 >> 16) - (int)((long)n14 * (long)n5 >> 16);
                n12 = (int)((long)n10 * (long)n5 >> 16) + (int)((long)n14 * (long)n8 >> 16);
                n10 = (int)((long)n15 * (long)n9 >> 16) + (int)((long)n13 * (long)n6 >> 16);
                n11 = (int)((long)(-n15) * (long)n6 >> 16) + (int)((long)n13 * (long)n9 >> 16);
                nArray[i] = n10;
                nArray[i + 1] = n11;
                nArray[i + 2] = n12;
            }
        }

        private int coordAvg(int[] nArray, int[] nArray2, int n, int n2) {
            int n3 = 0;
            int n4 = n * 3;
            n3 += nArray2[nArray[n4 + 0] * 3 + n2];
            n3 += nArray2[nArray[n4 + 1] * 3 + n2];
            return (n3 += nArray2[nArray[n4 + 2] * 3 + n2]) / 3;
        }

        private static int boundUint8(int n) {
            if (n < 0) {
                return 0;
            }
            if (n > 255) {
                return 255;
            }
            return n;
        }

        static /* synthetic */ int[] access$300(Renderer renderer) {
            return renderer.patches;
        }

        static /* synthetic */ int[] access$400(Renderer renderer) {
            return renderer.vertices;
        }

        static /* synthetic */ int access$500(Renderer renderer, int[] nArray, int[] nArray2, int n, int n2) {
            return renderer.coordAvg(nArray, nArray2, n, n2);
        }

        public static class Vec3i {
            int x;
            int y;
            int z;

            public Vec3i() {
            }

            public Vec3i(int n, int n2, int n3) {
                this.x = n;
                this.y = n2;
                this.z = n3;
            }

            public static Vec3i normal(Vec3i vec3i, Vec3i vec3i2, Vec3i vec3i3) {
                Vec3i vec3i4 = vec3i2.sub(vec3i);
                Vec3i vec3i5 = vec3i3.sub(vec3i);
                vec3i4.cross(vec3i5);
                if (vec3i4.x == 0 && vec3i4.y == 0 && vec3i4.z == 0) {
                    return vec3i4;
                }
                vec3i4.normalize();
                return vec3i4;
            }

            public void cross(Vec3i vec3i) {
                int n = (int)((long)this.y * (long)vec3i.z >> 16) - (int)((long)vec3i.y * (long)this.z >> 16);
                int n2 = (int)((long)this.z * (long)vec3i.x >> 16) - (int)((long)vec3i.z * (long)this.x >> 16);
                int n3 = (int)((long)this.x * (long)vec3i.y >> 16) - (int)((long)vec3i.x * (long)this.y >> 16);
                this.x = n;
                this.y = n2;
                this.z = n3;
            }

            public int dot(Vec3i vec3i) {
                return (int)((long)this.x * (long)vec3i.x >> 16) + (int)((long)this.y * (long)vec3i.y >> 16) + (int)((long)this.z * (long)vec3i.z >> 16);
            }

            public Vec3i sub(Vec3i vec3i) {
                return new Vec3i(this.x - vec3i.x, this.y - vec3i.y, this.z - vec3i.z);
            }

            public void normalize() {
                int n = FastMath.fp1616sqrt((int)((long)this.x * (long)this.x >> 16) + (int)((long)this.y * (long)this.y >> 16) + (int)((long)this.z * (long)this.z >> 16));
                this.x = FastMath.fp1616div(this.x, n);
                this.y = FastMath.fp1616div(this.y, n);
                this.z = FastMath.fp1616div(this.z, n);
            }

            public String toString() {
                return "<" + this.x + "," + this.y + "," + this.z + ">";
            }
        }
    }

    public static class Model {
        public static final String AGILENT_LOGO_MODEL = "/agilent-logo.e3d";
        public int[] vertices;
        public int[] patches;

        public static Model load(String string) throws ModelLoadException {
            URL uRL;
            if (logger.isDebugEnabled()) {
                logger.debug("load() Loading model " + string);
            }
            if ((uRL = (class$elgato$infrastructure$manufacturing$KeyboardTestScreen$Model == null ? (class$elgato$infrastructure$manufacturing$KeyboardTestScreen$Model = KeyboardTestScreen.class$("elgato.infrastructure.manufacturing.KeyboardTestScreen$Model")) : class$elgato$infrastructure$manufacturing$KeyboardTestScreen$Model).getResource(string)) == null) {
                throw new ModelLoadException("Model not found: " + string);
            }
            InputStream inputStream = null;
            try {
                int n;
                inputStream = uRL.openStream();
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                byte[] byArray = new byte[4];
                if (dataInputStream.read(byArray) < 0 || !"e3d1".equals(new String(byArray))) {
                    throw new ModelLoadException("Invalid file format");
                }
                int n2 = dataInputStream.readInt();
                if (n2 < 0) {
                    throw new ModelLoadException("Num patches < 0");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("load() " + n2 + " patches");
                }
                int[] nArray = new int[n2 * 3];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = dataInputStream.readInt();
                }
                n = dataInputStream.readInt();
                if (n < 0) {
                    throw new ModelLoadException("Num vectors < 0");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("load() " + n + " vertices");
                }
                int[] nArray2 = new int[n * 3];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = (int)(dataInputStream.readFloat() * 65536.0f);
                }
                Model model = new Model();
                model.patches = nArray;
                model.vertices = nArray2;
                if (logger.isDebugEnabled()) {
                    logger.debug("load() Model loaded.");
                }
                Model model2 = model;
                return model2;
            }
            catch (IOException iOException) {
                throw new ModelLoadException("IO error: " + iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class ModelLoadException
    extends Exception {
        public ModelLoadException(String string) {
            super(string);
        }
    }

    private static class RightActionListener
    extends KeyboardTestActionListener {
        public RightActionListener(int n, MenuItem[] menuItemArray, KeyboardTestModel keyboardTestModel) {
            super(n, menuItemArray, keyboardTestModel);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.model.incrementSoftRightKey(this.index);
            this.buttons[this.index].setText("Button " + this.index + "\n" + this.model.getSoftRightKey(this.index));
        }
    }

    private static class LeftActionListener
    extends KeyboardTestActionListener {
        public LeftActionListener(int n, MenuItem[] menuItemArray, KeyboardTestModel keyboardTestModel) {
            super(n, menuItemArray, keyboardTestModel);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.model.incrementSoftLeftKey(this.index);
            this.buttons[this.index].setText("Button " + this.index + "\n" + this.model.getSoftLeftKey(this.index));
        }
    }

    private static abstract class KeyboardTestActionListener
    implements ActionListener {
        int index;
        MenuItem[] buttons;
        KeyboardTestModel model;

        public KeyboardTestActionListener(int n, MenuItem[] menuItemArray, KeyboardTestModel keyboardTestModel) {
            this.index = n;
            this.buttons = menuItemArray;
            this.model = keyboardTestModel;
        }

        public abstract void actionPerformed(ActionEvent var1);
    }

    private class KeyboardTestPanel
    extends JComponent {
        private Model logoModel = null;
        private Renderer renderer = new Renderer();

        protected void paintComponent(Graphics graphics) {
            int n;
            graphics.setColor(Color.white);
            graphics.setFont(FixedPanel.labelFont);
            graphics.translate(20, 24);
            graphics.drawString("Preset", 0, 0);
            graphics.drawString(KeyboardTestScreen.this.model.getPresetCount(), 150, 0);
            graphics.drawString("Backlight", 0, 20);
            graphics.drawString(KeyboardTestScreen.this.model.getBacklightCount(), 150, 20);
            graphics.drawString("Help", 0, 40);
            graphics.drawString(KeyboardTestScreen.this.model.getHelpCount(), 150, 40);
            graphics.drawString("Mode", 0, 80);
            graphics.drawString(KeyboardTestScreen.this.model.getModeCount(), 150, 80);
            graphics.drawString("Save Data", 0, 100);
            graphics.drawString(KeyboardTestScreen.this.model.getSaveDataCount(), 150, 100);
            graphics.drawString("Save State", 0, 120);
            graphics.drawString(KeyboardTestScreen.this.model.getSaveStateCount(), 150, 120);
            graphics.drawString("System", 0, 140);
            graphics.drawString(KeyboardTestScreen.this.model.getSystemCount(), 150, 140);
            graphics.drawString("Print Screen", 0, 160);
            graphics.drawString(KeyboardTestScreen.this.model.getPrintScreenCount(), 150, 160);
            graphics.drawString("Recall State", 0, 180);
            graphics.drawString(KeyboardTestScreen.this.model.getRecallStateCount(), 150, 180);
            graphics.drawString("Scroll Wheel", 0, 200);
            graphics.drawString(String.valueOf(KeyboardTestScreen.this.model.getScrollWheelCount()), 150, 200);
            graphics.drawString("(rotation)", 80, 220);
            graphics.drawString(String.valueOf(KeyboardTestScreen.this.model.getScrollWheelRotation()), 150, 220);
            this.drawPieMeter(graphics, 10, 210, 64, 64, 0, 400, KeyboardTestScreen.this.model.getScrollWheelRotation());
            if (this.logoModel != null) {
                n = 0;
                int n2 = 600;
                int n3 = KeyboardTestScreen.this.model.getScrollWheelRotation();
                int n4 = (n3 - n) * 32768 / (n2 - n) + n;
                this.renderer.setRotation(n4 += 1638, n4, 0);
                this.renderer.processModel(this.logoModel);
                this.renderer.render(graphics, 90, 210, 64, 64);
            }
            for (n = 0; n < 10; ++n) {
                graphics.drawString("Key " + n, 250, n * 20);
                graphics.drawString(String.valueOf(KeyboardTestScreen.this.model.getNumberKeyCount()[n]), 375, n * 20);
            }
            graphics.drawString("Key .", 250, 200);
            graphics.drawString(KeyboardTestScreen.this.model.getDotCount(), 375, 200);
            graphics.drawString("Backspace", 250, 220);
            graphics.drawString(KeyboardTestScreen.this.model.getBackSpaceCount(), 375, 220);
            graphics.drawString("Up Arrow", 250, 240);
            graphics.drawString(KeyboardTestScreen.this.model.getUpArrowCount(), 375, 240);
            graphics.drawString("Down Arrow", 250, 260);
            graphics.drawString(KeyboardTestScreen.this.model.getDownArrowCount(), 375, 260);
            graphics.setFont(new Font("SansSerif", 1, 20));
            graphics.setColor(Color.yellow);
            graphics.drawString("Esc to exit", 30, 300);
        }

        private void drawPieMeter(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            Color color = graphics.getColor();
            graphics.setColor(new Color(92, 92, 192));
            graphics.fillOval(n, n2, n3, n4);
            graphics.setColor(Color.lightGray);
            graphics.drawOval(n, n2, n3, n4);
            int n8 = n2 + n4 / 2;
            int n9 = n + n3 / 2;
            graphics.fillOval(n9 - 1, n8 - 1, 2, 2);
            int n10 = (n7 - n5) * 32768 / (n6 - n5) + n5;
            int n11 = FastMath.cos(n10 -= 8192) * (n3 / 2) >> 16;
            int n12 = FastMath.sin(n10) * (n3 / 2) >> 16;
            graphics.setColor(Color.yellow);
            graphics.translate(n9, n8);
            graphics.drawLine(0, 0, n11, n12);
            graphics.translate(-n9, -n8);
            graphics.setColor(color);
        }
    }
}

