/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.manufacturing.snake;

import elgato.infrastructure.manufacturing.snake.Apple;
import elgato.infrastructure.manufacturing.snake.GameState;
import elgato.infrastructure.manufacturing.snake.Snake;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.Random;

class SnakeBoard {
    private static final int BORDER = 2;
    private static final int BLOCKSIZE = 8;
    private static final int BODYMARGIN = 1;
    private Dimension displaySize;
    private Dimension boardSize;
    private Snake snake;
    private Apple apple;
    private Random random = new Random();
    private GameState gameState;
    private Image background;

    public SnakeBoard(int n, int n2, GameState gameState) {
        this.boardSize = new Dimension(n, n2);
        this.gameState = gameState;
        this.snake = new Snake(5, new Point(1, 0), new Point(this.boardSize.width / 2, this.boardSize.height / 2));
        this.placeApple();
        this.displaySize = new Dimension(this.boardSize.width * 8 + 4, this.boardSize.height * 8 + 4);
        this.createBackground();
    }

    public Dimension getDisplaySize() {
        return this.displaySize;
    }

    private void placeApple() {
        Point point;
        int n = 0;
        while (this.snake.bodyContainsPoint(point = new Point((this.random.nextInt() & Integer.MAX_VALUE) % this.boardSize.width, (this.random.nextInt() & Integer.MAX_VALUE) % this.boardSize.height)) && n < 10000) {
        }
        this.apple = new Apple(point);
    }

    public void draw(Graphics graphics) {
        Point point;
        graphics.drawImage(this.background, 0, 0, null);
        graphics.setColor(Color.white);
        graphics.drawRect(0, 0, this.displaySize.width, this.displaySize.height);
        if (this.apple != null) {
            graphics.setColor(Color.blue);
            point = this.apple.getLocation();
            graphics.fillOval(2 + point.x * 8, 2 + point.y * 8, 8, 8);
        }
        graphics.setColor(Color.yellow);
        point = null;
        for (int i = 0; i < this.snake.length(); ++i) {
            Point point2 = this.snake.getBodyPoint(i);
            Rectangle rectangle = new Rectangle(2 + point2.x * 8 + 1, 2 + point2.y * 8 + 1, 6, 6);
            if (point != null) {
                if (point.x < point2.x) {
                    rectangle.x -= 2;
                    rectangle.width += 2;
                } else if (point.x > point2.x) {
                    rectangle.width += 2;
                } else if (point.y < point2.y) {
                    rectangle.y -= 2;
                    rectangle.height += 2;
                } else if (point.y > point2.y) {
                    rectangle.height += 2;
                }
            }
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            point = point2;
        }
    }

    private void createBackground() {
        int n = this.displaySize.width;
        int n2 = this.displaySize.height;
        int[] nArray = new int[n * n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = (n4 + i) * 112 / (n + n2);
                int n6 = n5 + 16;
                int n7 = 16;
                int n8 = 111 - n5 + 16;
                nArray[n3] = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
                ++n4;
                ++n3;
            }
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, this.displaySize.width);
        this.background = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public void setDirection(Point point) {
        this.snake.setDirection(point);
    }

    public Snake getSnake() {
        return this.snake;
    }

    public boolean move() {
        boolean bl;
        Point point = this.snake.getHead();
        Point point2 = new Point(point.x + this.snake.getDirection().x, point.y + this.snake.getDirection().y);
        boolean bl2 = bl = point2.x < 0 || point2.x >= this.boardSize.width || point2.y < 0 || point2.y >= this.boardSize.height;
        if (bl || this.snake.bodyContainsPoint(point2)) {
            return false;
        }
        this.snake.move(point2);
        if (point2.equals(this.apple.getLocation())) {
            this.placeApple();
            this.snake.lengthen();
            this.gameState.score += 100;
        }
        return true;
    }
}

