/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.manufacturing.snake;

import elgato.infrastructure.manufacturing.GameUtilities;
import elgato.infrastructure.manufacturing.snake.GameState;
import elgato.infrastructure.manufacturing.snake.SnakeBoard;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;

class SnakeDisplay
extends JComponent {
    private GameState gameState;
    private SnakeBoard board;

    public SnakeDisplay(GameState gameState) {
        this.gameState = gameState;
        this.setBackground(Color.black);
    }

    public void newGame() {
        this.gameState.score = 0;
        this.gameState.state = 1;
        this.board = new SnakeBoard(24, 16, this.gameState);
    }

    public SnakeBoard getBoard() {
        return this.board;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.gameState.state == 0) {
            graphics.setFont(GameUtilities.startupMessageFont);
            graphics.setColor(Color.white);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            int n2 = 80;
            int n3 = 100;
            graphics.drawString("In this game you are a young snake.", n2, n3);
            graphics.drawString("The object is to eat as many apples as you can.", n2, n3 += n);
            graphics.drawString("As you eat, you will begin to grow. Be careful, however!", n2, n3 += n);
            graphics.drawString("You lose if you run into a wall or yourself.", n2, n3 += n);
            graphics.drawString("Use the numeric keypad keys to change direction:", n2, n3 += n * 3 / 2);
            graphics.drawString("8", n2 + 90, n3 += n * 3 / 2);
            graphics.drawString("4", n2 + 90 - 16, n3 += 16);
            graphics.drawString("6", n2 + 90 + 16, n3);
            graphics.drawString("2", n2 + 90, n3 += 16);
            return;
        }
        Dimension dimension = this.board.getDisplaySize();
        int n = (this.getWidth() - dimension.width) / 2;
        int n4 = (this.getHeight() - dimension.height) / 2;
        graphics.translate(n, n4);
        this.board.draw(graphics);
        graphics.translate(-n, -n4);
        this.drawScoreboard(graphics, 5, n4, n - 10, dimension.height);
        if (this.gameState.state == 3) {
            String string = "GAME OVER";
            graphics.setColor(new Color(255, 140, 150));
            graphics.setFont(GameUtilities.gameOverFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.stringWidth(string);
            graphics.drawString(string, (this.getWidth() - n5) / 2, (this.getHeight() - fontMetrics.getAscent()) / 2);
        } else if (this.gameState.state == 2) {
            GameUtilities.fillWithGrayShade(graphics, n, n4, dimension.width, dimension.height);
            graphics.setColor(Color.white);
            graphics.setFont(GameUtilities.gameOverFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = "PAUSED";
            int n6 = fontMetrics.stringWidth(string);
            graphics.drawString(string, (this.getWidth() - n6) / 2, (this.getHeight() - fontMetrics.getAscent()) / 2);
        }
    }

    private void drawScoreboard(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(GameUtilities.SCOREBOARD_BACKGROUND);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setFont(GameUtilities.scoreboardFont);
        graphics.setColor(Color.white);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = n2 + 10 + fontMetrics.getAscent();
        graphics.drawString("Score: " + this.gameState.score, 10, n5);
        graphics.drawString("Snake length: " + this.board.getSnake().length(), 10, n5 += fontMetrics.getHeight());
    }
}

