/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.manufacturing.snake;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.manufacturing.HighScoreListHelper;
import elgato.infrastructure.manufacturing.snake.GameState;
import elgato.infrastructure.manufacturing.snake.Keymap;
import elgato.infrastructure.manufacturing.snake.SnakeDisplay;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.widgets.WrappedTimer;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

public class SnakeScreen
extends Screen {
    private static final String prefix = "snk";
    private static final int TICKDELAY = 300;
    private Keymap keymap;
    private SnakeDisplay display;
    private WrappedTimer tickTimer;
    private Point chosenDirection;
    private GameState gameState;
    private HighScoreListHelper highScoreListHelper;

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.highScoreListHelper = new HighScoreListHelper("Nibbles", prefix);
        Command command = Command.makeGetCommand(this.highScoreListHelper.getTopic());
        command.addProperty(this.highScoreListHelper.getKeyLastNameEntered(), "");
        MeasurementFactory.instance().getCommandProcessor().send(command);
        this.gameState = new GameState();
        this.gameState.score = 0;
        this.gameState.state = 0;
        this.keymap = Keymap.get();
        this.display = new SnakeDisplay(this.gameState);
        screenManager.installDisplay(this.display);
        this.gameState.state = 0;
        this.tickTimer = new WrappedTimer(300, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((SnakeScreen)SnakeScreen.this).gameState.state == 1) {
                    if (SnakeScreen.this.chosenDirection != null) {
                        SnakeScreen.this.display.getBoard().setDirection(SnakeScreen.this.chosenDirection);
                        SnakeScreen.this.chosenDirection = null;
                    }
                    if (!SnakeScreen.this.display.getBoard().move()) {
                        ((SnakeScreen)SnakeScreen.this).gameState.state = 3;
                        EventDispatchThread.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                SnakeScreen.access$400(1.access$300(this.this$1)).handleGameOver(SnakeScreen.access$000((SnakeScreen)1.access$300(this.this$1)).score, 1);
                            }
                        }, "Snake.HandleGameOver");
                    }
                }
                SnakeScreen.this.display.paintImmediately(0, 0, SnakeScreen.this.display.getWidth(), SnakeScreen.this.display.getHeight());
            }

            static /* synthetic */ SnakeScreen access$300(1 var0) {
                return var0.SnakeScreen.this;
            }
        });
        this.tickTimer.start();
        screenManager.installLeftMenu(new Menu("Nibbles", new MenuItem[]{this.createNewGameButton(), this.createHighScoreListButton()}));
        screenManager.installRightMenu(new Menu("", new MenuItem[]{this.createPauseButton(), this.createQuitButton()}));
    }

    private MenuItem createNewGameButton() {
        return new PushButton("New Game", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnakeScreen.this.display.newGame();
            }
        });
    }

    private MenuItem createHighScoreListButton() {
        return new PushButton("High Scores", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnakeScreen.this.pauseGame();
                SnakeScreen.this.highScoreListHelper.showHighScores(null);
            }
        });
    }

    private MenuItem createPauseButton() {
        return new PushButton("Pause", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((SnakeScreen)SnakeScreen.this).gameState.state == 2) {
                    SnakeScreen.this.resumeGame();
                } else {
                    SnakeScreen.this.pauseGame();
                }
            }
        });
    }

    private MenuItem createQuitButton() {
        return new PushButton("Quit", "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnakeScreen.this.getScreenManager().popScreen();
            }
        });
    }

    private void pauseGame() {
        if (this.gameState.state == 1) {
            this.gameState.state = 2;
        }
    }

    private void resumeGame() {
        if (this.gameState.state == 2) {
            this.gameState.state = 1;
        }
    }

    public void uninstallScreen(ScreenManager screenManager) {
        this.tickTimer.stop();
        super.uninstallScreen(screenManager);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.gameState.state == 1) {
            if (this.keymap.isUp(keyEvent)) {
                this.changeDirection(0, -1);
            } else if (this.keymap.isDown(keyEvent)) {
                this.changeDirection(0, 1);
            } else if (this.keymap.isLeft(keyEvent)) {
                this.changeDirection(-1, 0);
            } else if (this.keymap.isRight(keyEvent)) {
                this.changeDirection(1, 0);
            }
        }
    }

    private void changeDirection(int n, int n2) {
        if (this.chosenDirection != null) {
            return;
        }
        Point point = this.display.getBoard().getSnake().getDirection();
        if (-n == point.x && -n2 == point.y) {
            return;
        }
        this.chosenDirection = new Point(n, n2);
    }
}

