/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.marker;

import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.measurement.AbstractValidator;
import elgato.infrastructure.measurement.TraceMeasurement;

public class IndexSteppingValidator
extends AbstractValidator {
    private TraceAnalyzer analyzer;

    public IndexSteppingValidator(TraceAnalyzer traceAnalyzer) {
        this.analyzer = traceAnalyzer;
    }

    public void dispose() {
        this.analyzer = null;
    }

    protected long doIncrement(long l, int n) {
        int n2;
        int n3 = Math.abs(n);
        int n4 = n2 = n < 0 ? -1 : 1;
        while (n3-- > 0) {
            l = this.step(l, n2);
        }
        return l;
    }

    protected long doDecrement(long l, int n) {
        return this.doIncrement(l, -n);
    }

    private long step(long l, int n) {
        if (this.analyzer == null) {
            return l;
        }
        TraceMeasurement traceMeasurement = this.analyzer.getTraceMeasurement();
        if (traceMeasurement == null) {
            return l;
        }
        int n2 = traceMeasurement.getIndexForXValue(this.convertRelativeToAbsolute(l));
        if (n2 < 0) {
            return l;
        }
        int n3 = n2 + n;
        long l2 = this.convertAbsoluteToRelative(traceMeasurement.getXValueForIndex(n3));
        if (!this.isValid(l2)) {
            return l;
        }
        return l2;
    }

    public boolean isValid(long l) {
        if (this.analyzer == null) {
            return true;
        }
        TraceMeasurement traceMeasurement = this.analyzer.getTraceMeasurement();
        if (traceMeasurement == null) {
            return true;
        }
        int n = traceMeasurement.getIndexForXValue(this.convertRelativeToAbsolute(l));
        return n >= 0 && n < traceMeasurement.getTraceLength();
    }

    public boolean isValid(String string) {
        try {
            return this.isValid(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public long validValue(long l) {
        if (this.isValid(l)) {
            return l;
        }
        if (this.analyzer == null) {
            return l;
        }
        TraceMeasurement traceMeasurement = this.analyzer.getTraceMeasurement();
        long l2 = Long.MAX_VALUE;
        long l3 = 0L;
        int n = traceMeasurement.getTraceLength();
        for (int i = 0; i < n; ++i) {
            long l4 = this.convertAbsoluteToRelative(traceMeasurement.getXValueForIndex(i));
            long l5 = Math.abs(l - l4);
            if (l5 >= l2) continue;
            l2 = l5;
            l3 = l4;
        }
        return this.convertAbsoluteToRelative(l3);
    }

    protected long convertAbsoluteToRelative(long l) {
        return l;
    }

    protected long convertRelativeToAbsolute(long l) {
        return l;
    }
}

