/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.marker;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.marker.MarkerIcon;
import elgato.infrastructure.marker.MarkerListener;
import elgato.infrastructure.marker.MarkerModel;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.cdma.CdmaAnalyzer;
import elgato.measurement.cdma.CdmaMeasurement;
import elgato.measurement.cdma1xev.Cdma1xevAnalyzer;
import elgato.measurement.cdma1xev.Cdma1xevMeasurement;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;

public class Marker {
    protected static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$marker$Marker == null ? (class$elgato$infrastructure$marker$Marker = Marker.class$("elgato.infrastructure.marker.Marker")) : class$elgato$infrastructure$marker$Marker);
    private static final int NO_DATA = Integer.MIN_VALUE;
    public static final int NOT_DRAWN = Integer.MIN_VALUE;
    private MarkerIcon normalIcon;
    private MarkerIcon deltaIcon;
    protected TraceAnalyzer analyzer;
    private Vector markerListeners = new Vector();
    private int lockedNormalValue;
    protected TraceMeasurement measurement;
    private boolean relativeDelta;
    private MarkerModel markerModel;
    ValueListener markerUpdatedListener;
    long yTop;
    long yRange;
    int h;
    int y;
    boolean bLineChart;
    static /* synthetic */ Class class$elgato$infrastructure$marker$Marker;

    public Marker(TraceAnalyzer traceAnalyzer, MarkerModel markerModel, boolean bl) {
        this.analyzer = traceAnalyzer;
        this.normalIcon = MarkerIcon.getIcon(markerModel.getMarkerIndex(), false, traceAnalyzer);
        this.deltaIcon = MarkerIcon.getIcon(markerModel.getMarkerIndex(), true, traceAnalyzer);
        this.markerModel = markerModel;
        this.relativeDelta = bl;
        this.bLineChart = false;
        this.yTop = 0L;
        this.yRange = 1L;
        this.h = 1;
        this.markerUpdatedListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = Marker.this.getAnalyzer().getMarkerListenerBaseName() + ".markerUpdatedListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                Marker.this.fireMarkerUpdated();
            }
        };
        markerModel.getNormalValue().addValueListener(this.markerUpdatedListener);
        markerModel.getDeltaValue().addValueListener(this.markerUpdatedListener);
        markerModel.getMode().addValueListener(this.markerUpdatedListener);
        if (markerModel.getMarkerTrace() != null) {
            markerModel.getMarkerTrace().addValueListener(this.markerUpdatedListener);
        }
    }

    public void dispose() {
        this.markerModel.getNormalValue().removeValueListener(this.markerUpdatedListener);
        this.markerModel.getDeltaValue().removeValueListener(this.markerUpdatedListener);
        this.markerModel.getMode().removeValueListener(this.markerUpdatedListener);
        if (this.markerModel.getMarkerTrace() != null) {
            this.markerModel.getMarkerTrace().removeValueListener(this.markerUpdatedListener);
        }
        this.markerUpdatedListener = null;
        if (!this.markerListeners.isEmpty()) {
            this.markerListeners.removeAllElements();
        }
        this.markerListeners = null;
        this.normalIcon = null;
        this.deltaIcon = null;
        this.markerModel = null;
        this.analyzer = null;
        this.measurement = null;
    }

    public MarkerModel getModel() {
        return this.markerModel;
    }

    protected TraceAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean isVisible() {
        return this.showingNormal();
    }

    public boolean isDeltaVisible() {
        return this.showingDelta();
    }

    public long boundValue(long l) {
        long l2 = this.getStartValueFromTrace();
        long l3 = this.getStopValueFromTrace();
        if (l < l2) {
            l = l2;
        }
        if (l > l3) {
            l = l3;
        }
        return l;
    }

    void boundMarker() {
        this.setNormalValue(this.boundValue(this.getNormalValue()));
        this.setDeltaValue(this.boundValue(this.getAbsoluteDeltaValue()));
    }

    public void setAbsoluteValue(long l) {
        if (this.showingDelta()) {
            this.setDeltaValue(l);
        } else {
            this.setNormalValue(l);
        }
    }

    public long getAbsoluteValue() {
        return this.showingDelta() ? this.getAbsoluteDeltaValue() : this.getNormalValue();
    }

    protected long getNormalValue() {
        return this.markerModel.getNormalValue().longValue();
    }

    public void setNormalValue(long l) {
        this.setIfChanged(this.markerModel.getNormalValue(), l);
    }

    public void setDeltaValue(long l) {
        long l2 = l;
        if (this.relativeDelta) {
            l2 -= this.getNormalValue();
        }
        this.setIfChanged(this.markerModel.getDeltaValue(), l2);
    }

    protected long getAbsoluteDeltaValue() {
        long l = this.markerModel.getDeltaValue().longValue();
        if (this.relativeDelta) {
            l += this.getNormalValue();
        }
        return l;
    }

    private void setIfChanged(LongActuator longActuator, long l) {
        if (longActuator.longValue() != l) {
            longActuator.send(l);
        }
    }

    int getAbsolutePowerLevel() {
        if (this.showingDelta()) {
            return this.getDeltaPowerLevel();
        }
        return this.getPowerLevel();
    }

    private int getPowerLevel() {
        if (this.showingDelta() && this.bLineChart) {
            return this.lockedNormalValue;
        }
        this.lockedNormalValue = this.getTraceValue(this.getNormalValue());
        return this.lockedNormalValue;
    }

    long getRelativeDeltaPowerLevel() {
        return this.showingDelta() ? (long)(this.getDeltaPowerLevel() - this.getPowerLevel()) : 0L;
    }

    private int getDeltaPowerLevel() {
        return this.getTraceValue(this.getAbsoluteDeltaValue());
    }

    private int getTraceValue(long l) {
        int n = this.measurement.getIndexForXValue(l);
        if (n < 0 || n >= this.measurement.getTraceLength()) {
            return Integer.MIN_VALUE;
        }
        return this.measurement.getMarkerTrace(this.markerModel.getMarkerTraceIndex())[n];
    }

    public MarkerModel getMarkerModel() {
        return this.markerModel;
    }

    public void addMarkerListener(MarkerListener markerListener) {
        this.markerListeners.addElement(markerListener);
    }

    public void removeMarkerListener(MarkerListener markerListener) {
        this.markerListeners.removeElement(markerListener);
    }

    private void fireMarkerUpdated() {
        for (int i = 0; i < this.markerListeners.size(); ++i) {
            MarkerListener markerListener = (MarkerListener)this.markerListeners.elementAt(i);
            markerListener.markerUpdated();
        }
    }

    protected long getStartValueFromTrace() {
        return this.analyzer.getTraceStartValue();
    }

    protected long getStopValueFromTrace() {
        return this.analyzer.getTraceStopValue();
    }

    protected long getStartValueFromTrace(long l) {
        return this.analyzer.getTraceStartValue(l);
    }

    protected long getStopValueFromTrace(long l) {
        return this.analyzer.getTraceStopValue(l);
    }

    private boolean showingNormal() {
        return this.markerModel.showingNormal();
    }

    private boolean showingDelta() {
        return this.markerModel.showingDelta();
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        this.measurement = traceMeasurement;
        this.boundMarker();
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.showingNormal() && this.analyzer != null && this.analyzer.getMeasurement() != null) {
            long l = this.getNormalValue();
            long l2 = this.getPowerLevel();
            stringBuffer.append(Text.MKR).append(this.normalIcon.getLabel()).append(": ");
            if (l2 == Integer.MIN_VALUE) {
                stringBuffer.append("?");
            } else {
                this.formatValue(stringBuffer, l, this.analyzer.getYAxisNormalStrategy(), l2, false);
                if (this.showingDelta()) {
                    long l3 = this.markerModel.getDeltaValue().longValue();
                    if (this.getDeltaPowerLevel() == Integer.MIN_VALUE) {
                        stringBuffer.append(" (").append(Text.DELTA_SYMBOL).append("?").append(")");
                    } else {
                        long l4 = this.getRelativeDeltaPowerLevel();
                        stringBuffer.append(" (").append(Text.DELTA_SYMBOL).append(" ");
                        if (this.relativeDelta && l3 >= 0L) {
                            stringBuffer.append('+');
                        }
                        this.formatValue(stringBuffer, l3, this.analyzer.getYAxisDeltaStrategy(), l4, true);
                        stringBuffer.append(")");
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    private void formatValue(StringBuffer stringBuffer, long l, NumberFieldStrategy numberFieldStrategy, long l2, boolean bl) {
        boolean bl2;
        boolean bl3;
        stringBuffer.append(this.analyzer.getXAxisStrategy().format(l));
        stringBuffer.append(", ");
        if (bl && l2 >= 0L) {
            stringBuffer.append('+');
        }
        boolean bl4 = bl3 = this.analyzer instanceof CdmaAnalyzer && !((CdmaAnalyzer)this.analyzer).isRelative();
        if (bl3 && !bl) {
            l2 = ((CdmaMeasurement)this.analyzer.getMeasurement()).convertToAbsolutePower((int)l2);
        }
        boolean bl5 = bl2 = this.analyzer instanceof Cdma1xevAnalyzer && !((Cdma1xevAnalyzer)this.analyzer).isRelative();
        if (bl2 && !bl) {
            l2 = ((Cdma1xevMeasurement)this.analyzer.getMeasurement()).convertToAbsolutePower((int)l2);
        }
        stringBuffer.append(numberFieldStrategy.format(l2));
    }

    public void setGraphicInfo(long l, int n, int n2, long l2, boolean bl) {
        this.h = n;
        this.y = n2;
        this.yTop = l;
        this.yRange = l2;
        this.bLineChart = bl;
    }

    public void paint(Component component, Graphics graphics, final int[] nArray, final int[] nArray2) {
        this.drawMarker(component, graphics, new Painter(){

            public void paint(Component component, Graphics graphics, long l, int n, boolean bl) {
                int n2 = nArray[n];
                int n3 = nArray2[n];
                if (Marker.this.bLineChart && !bl && Marker.this.getModel().getMode().intValue() == MarkerModel.DELTA.intValue()) {
                    n3 = (int)((long)Marker.this.y + ((long)Marker.this.getPowerLevel() - Marker.this.yTop) * (long)Marker.this.h / Marker.this.yRange);
                }
                if (n2 == Integer.MIN_VALUE) {
                    return;
                }
                MarkerIcon markerIcon = bl ? Marker.this.deltaIcon : Marker.this.normalIcon;
                markerIcon.paintIcon(component, graphics, n2 - markerIcon.getIconWidth() / 2, n3 - markerIcon.getIconHeight());
            }
        });
    }

    public void paintUsingVerticalLine(Component component, Graphics graphics, final int n, final int n2, final int n3, final int n4, final int n5, final int n6, final boolean bl) {
        this.drawMarker(component, graphics, new Painter(){

            public void paint(Component component, Graphics graphics, long l, int n7, boolean bl2) {
                int n22 = n3 / (n6 - n5 + 1) / 2;
                if (n22 == 0) {
                    ++n22;
                }
                if (!bl) {
                    n7 = Marker.this.measurement.linearizeXValue(n7);
                }
                if (n7 < n5 || n7 > n6) {
                    return;
                }
                int n32 = n + n22 + (n7 - n5) * n3 / (n6 - n5 + 1);
                int n42 = n2 + n4;
                graphics.setColor(Marker.this.normalIcon.getColor());
                if (bl2) {
                    graphics.setColor(Marker.this.deltaIcon.getColor());
                    for (int i = n2 + 2; i < n42; i += 6) {
                        graphics.drawLine(n32, i, n32, i + 2);
                    }
                } else {
                    graphics.drawLine(n32, n2, n32, n2 + n4);
                }
                MarkerIcon markerIcon = bl2 ? Marker.this.deltaIcon : Marker.this.normalIcon;
                markerIcon.paintIconText(component, graphics, n32, n2, 0);
                markerIcon.paintIconText(component, graphics, n32, n42, 2);
            }
        });
    }

    private void drawMarker(Component component, Graphics graphics, Painter painter) {
        if (this.showingNormal() && this.analyzer != null && this.analyzer.getMeasurement() != null) {
            this.boundMarker();
            this.drawMarkerPart(component, graphics, false, painter);
            if (this.showingDelta()) {
                this.drawMarkerPart(component, graphics, true, painter);
            }
        }
    }

    protected void drawMarkerPart(Component component, Graphics graphics, boolean bl, Painter painter) {
        long l;
        long l2 = l = bl ? this.getAbsoluteDeltaValue() : this.getNormalValue();
        if (l < this.analyzer.getViewStartValue() || l > this.analyzer.getViewStopValue()) {
            return;
        }
        int n = this.measurement.getIndexForXValue(l);
        if (n < 0) {
            logger.warn("Value " + l + " not found in measurement with getIndexForXValue(), " + "most likely the measurement is invalid.");
            return;
        }
        painter.paint(component, graphics, l, n, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static interface Painter {
        public void paint(Component var1, Graphics var2, long var3, int var5, boolean var6);
    }
}

