/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.marker;

import elgato.gui.ModelTypeMgr;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.TrimodeActuatorButton;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.marker.IndexSteppingValidator;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.marker.MarkerModel;
import elgato.infrastructure.marker.MarkerSettings;
import elgato.infrastructure.marker.MarkerSettingsFactory;
import elgato.infrastructure.marker.RelativeSteppingValidator;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.menu.ActionButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.peakSearch.ActivityFinder;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MarkerButtonFactory {
    protected static final int MARKER_COUNT = 4;
    protected static final int MARKER_TYPE_BUTTON_INDEX = 1;
    protected static final int MARKER_TRACE_BUTTON_INDEX = 2;
    protected MeasurementScreen screen;
    protected Menu markerMenu;
    protected TrimodeActuatorButton[] markerTypeButtons;
    protected Marker[] markers;
    private final PeakButtonData minPeakData = new PeakButtonData();
    protected final PeakButtonData maxPeakData = new PeakButtonData();
    protected final PeakButtonData activeData = new PeakButtonData();
    private ListActuator selectedMarker;
    private ActuatorSubMenuButton[] markerTraceButtons;
    private ValueInterface xCenterValue;
    private ValueInterface yTopValue;
    protected boolean relativeDelta;
    private ValueListener selectedMarkerListener;
    private ValueListener[] modeListeners;
    private ValueListener[] markerUpdatedListeners;
    protected IndexSteppingValidator normalValidator;
    protected RelativeSteppingValidator[] deltaValidators = new RelativeSteppingValidator[4];
    protected MarkerSettings markerSettings;

    public MarkerButtonFactory() {
    }

    public MarkerButtonFactory(MeasurementScreen measurementScreen, ValueInterface valueInterface, ValueInterface valueInterface2, LongActuator longActuator, boolean bl) {
        this.screen = measurementScreen;
        this.xCenterValue = valueInterface;
        this.yTopValue = valueInterface2;
        this.relativeDelta = bl;
        this.markerSettings = MarkerSettingsFactory.instance().getMarkerSettings(measurementScreen.getTopic(), longActuator);
        this.markerSettings.refresh();
        this.markers = this.createMarkers(measurementScreen.getTraceAnalyzer(), this.markerSettings);
        this.selectedMarker = this.markerSettings.getSelectedMarker();
        this.markerTypeButtons = new TrimodeActuatorButton[this.markers.length];
        for (int i = 0; i < this.markerTypeButtons.length; ++i) {
            this.markerTypeButtons[i] = this.makeMarkerTypeButton(this.markers[i]);
            this.markerTypeButtons[i].setEnabled(false);
        }
        this.markerTraceButtons = null;
        this.addValueListeners();
    }

    public MarkerButtonFactory(MeasurementScreen measurementScreen, ValueInterface valueInterface, ValueInterface valueInterface2, LongActuator longActuator, boolean bl, Value[] valueArray, MarkerSettingsFactory markerSettingsFactory) {
        this(measurementScreen, valueInterface, valueInterface2, longActuator, bl, valueArray, markerSettingsFactory, "");
    }

    public MarkerButtonFactory(MeasurementScreen measurementScreen, ValueInterface valueInterface, ValueInterface valueInterface2, LongActuator longActuator, boolean bl, Value[] valueArray, MarkerSettingsFactory markerSettingsFactory, String string) {
        this.setupSettings(measurementScreen, valueInterface, valueInterface2, bl, markerSettingsFactory, longActuator, valueArray, string);
        this.markers = this.createMarkers(measurementScreen.getTraceAnalyzer(), this.markerSettings);
        this.setupMarkerButtons();
    }

    protected void setupSettings(MeasurementScreen measurementScreen, ValueInterface valueInterface, ValueInterface valueInterface2, boolean bl, MarkerSettingsFactory markerSettingsFactory, LongActuator longActuator, Value[] valueArray, String string) {
        this.screen = measurementScreen;
        this.xCenterValue = valueInterface;
        this.yTopValue = valueInterface2;
        this.relativeDelta = bl;
        this.markerSettings = markerSettingsFactory.getMarkerSettings(measurementScreen.getTopic() + string, longActuator, valueArray);
        this.markerSettings.refresh();
    }

    protected void setupMarkerButtons() {
        int n;
        this.selectedMarker = this.markerSettings.getSelectedMarker();
        this.markerTypeButtons = new TrimodeActuatorButton[this.markers.length];
        for (n = 0; n < this.markerTypeButtons.length; ++n) {
            this.markerTypeButtons[n] = this.makeMarkerTypeButton(this.markers[n]);
            this.markerTypeButtons[n].setEnabled(false);
        }
        this.markerTraceButtons = new ActuatorSubMenuButton[this.markers.length];
        for (n = 0; n < this.markerTraceButtons.length; ++n) {
            this.markerTraceButtons[n] = this.makeMarkerTraceButton(this.markers[n]);
            this.markerTraceButtons[n].setEnabled(false);
        }
        this.addValueListeners();
    }

    private void createListeners(final MeasurementScreen measurementScreen) {
        this.selectedMarkerListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = measurementScreen.getListenerBaseName() + ".selectedMarkerListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                MarkerButtonFactory.this.setSelectedMarker(valueInterface.intValue());
            }
        };
        this.modeListeners = new ValueListener[this.markers.length];
        this.markerUpdatedListeners = new ValueListener[this.markers.length];
        for (int i = 0; i < this.markers.length; ++i) {
            this.modeListeners[i] = this.createModeListener(measurementScreen.getTraceAnalyzer(), this.markers[i]);
            this.markerUpdatedListeners[i] = this.createMarkerUpdatedListener(measurementScreen.getTraceAnalyzer(), i);
        }
    }

    protected ValueListener createMarkerUpdatedListener(final TraceAnalyzer traceAnalyzer, final int n) {
        return new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = traceAnalyzer.getMarkerListenerBaseName() + ".marker" + n + "UpdatedListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                MarkerButtonFactory.this.updateActivity();
                traceAnalyzer.markerUpdated();
            }
        };
    }

    public void addValueListeners() {
        this.createListeners(this.screen);
        this.selectedMarker.addValueListener(this.selectedMarkerListener);
        for (int i = 0; i < this.markers.length; ++i) {
            this.markers[i].getModel().getMode().addValueListener(this.markerUpdatedListeners[i]);
            this.markers[i].getModel().getMode().addValueListener(this.modeListeners[i]);
            this.markers[i].getModel().getNormalValue().addValueListener(this.markerUpdatedListeners[i]);
            this.markers[i].getModel().getDeltaValue().addValueListener(this.markerUpdatedListeners[i]);
        }
    }

    private void removeValueListeners() {
        this.selectedMarker.removeValueListener(this.selectedMarkerListener);
        for (int i = 0; i < this.markers.length; ++i) {
            this.markers[i].getModel().getMode().removeValueListener(this.markerUpdatedListeners[i]);
            this.markers[i].getModel().getMode().removeValueListener(this.modeListeners[i]);
            this.markers[i].getModel().getNormalValue().removeValueListener(this.markerUpdatedListeners[i]);
            this.markers[i].getModel().getDeltaValue().removeValueListener(this.markerUpdatedListeners[i]);
            this.markerUpdatedListeners[i] = null;
            this.modeListeners[i] = null;
        }
        this.selectedMarkerListener = null;
    }

    private Marker[] createMarkers(TraceAnalyzer traceAnalyzer, MarkerSettings markerSettings) {
        Marker[] markerArray = new Marker[4];
        this.normalValidator = new IndexSteppingValidator(traceAnalyzer);
        for (int i = 0; i < markerArray.length; ++i) {
            MarkerModel markerModel = markerSettings.getModel(i);
            markerModel.getNormalValue().setValidator(this.normalValidator);
            this.deltaValidators[i] = new RelativeSteppingValidator(traceAnalyzer, markerModel.getNormalValue());
            IndexSteppingValidator indexSteppingValidator = this.relativeDelta ? this.deltaValidators[i] : this.normalValidator;
            markerModel.getDeltaValue().setValidator(indexSteppingValidator);
            markerArray[i] = new Marker(traceAnalyzer, markerModel, this.relativeDelta);
        }
        return markerArray;
    }

    protected void disposeMarkers(Marker[] markerArray) {
        for (int i = 0; i < markerArray.length; ++i) {
            MarkerModel markerModel = this.markerSettings.getModel(i);
            this.markers[i].dispose();
            this.markers[i] = null;
            this.deltaValidators[i].dispose();
            this.deltaValidators[i] = null;
        }
        this.normalValidator.dispose();
        this.normalValidator = null;
        this.deltaValidators = null;
    }

    private ValueListener createModeListener(final TraceAnalyzer traceAnalyzer, final Marker marker) {
        return new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = traceAnalyzer.getListenerBaseName() + ".markerModeListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (!marker.getModel().hasNormMarkerBeenShown() && valueInterface != MarkerModel.OFF) {
                    marker.getModel().getNormValueShown().send(1L);
                    if (traceAnalyzer.getTraceMeasurement() != null) {
                        long l;
                        long l2 = traceAnalyzer.getViewStartValue();
                        long l3 = traceAnalyzer.getViewStopValue();
                        if (MarkerButtonFactory.this.relativeDelta) {
                            l = l2 + (l3 - l2) / 2L;
                        } else {
                            TraceMeasurement traceMeasurement = traceAnalyzer.getTraceMeasurement();
                            int n = traceMeasurement.getIndexForXValue(l2);
                            int n2 = traceMeasurement.getIndexForXValue(l3);
                            int n3 = n + (n2 - n) / 2;
                            l = traceMeasurement.getXValueForIndex(n3);
                        }
                        marker.getModel().getNormalValue().send(l);
                    }
                }
                if (!marker.getModel().hasDeltaMarkerBeenShown() && valueInterface == MarkerModel.DELTA) {
                    marker.getModel().getDeltaValueShown().send(1L);
                    marker.setDeltaValue(marker.getModel().getNormalValue().longValue());
                }
                MarkerButtonFactory.this.updateMarkerActionButtonEnabledStates();
                MarkerButtonFactory.this.updateActivity();
            }
        };
    }

    public void updateMarkerXValueUnits() {
        for (int i = 0; i < this.markers.length; ++i) {
            Marker marker = this.markers[i];
            marker.getModel().configureValues();
        }
    }

    public Marker[] getMarkers() {
        return (Marker[])this.markers.clone();
    }

    public int getCurrentMarkerActiveIndex() {
        return this.activeData.peakIndex.value;
    }

    public boolean getCurrentMarkerAtActiveIndex(TraceAnalyzer traceAnalyzer) {
        if (this.activeData.activeFinder != null && this.activeData.activeFinder.getNumPeaks() > 0) {
            TraceMeasurement traceMeasurement = traceAnalyzer.getTraceMeasurement();
            return traceMeasurement.getIndexForXValue(this.getCurrentMarker().getAbsoluteValue()) == traceMeasurement.getIndexForXValue(this.activeData.activeFinder.getPeakXValue(this.activeData.peakIndex.value));
        }
        return false;
    }

    protected MenuItem createMarkerSelectButton() {
        return new MultiStateActuatorButton(this.selectedMarker, "", this.screen.getListenerBaseName() + ".markerSelectButton");
    }

    public MenuButton getMenuButton() {
        return this.createMenuButton();
    }

    protected MenuButton createMenuButton() {
        this.makeMarkerToMaxPeakButtons();
        MenuItem[] menuItemArray = new MenuItem[]{this.createMarkerSelectButton(), null, this.maxPeakData.peakButton, this.maxPeakData.nextPeakRightButton, this.xCenterValue != null ? this.makeMarkerToCenterFrequencyButton() : null, this.yTopValue != null ? this.makeMarkerToRefLevelButton() : null};
        MenuButton menuButton = this.makeMenuButton(menuItemArray);
        this.setSelectedMarker(0);
        return menuButton;
    }

    public MenuButton getMenuButtonWithMinPeaks() {
        return this.createMenuButtonWithMinPeaks();
    }

    private MenuButton createMenuButtonWithMinPeaks() {
        this.makeMarkerToMinPeakButtons();
        this.makeMarkerToMaxPeakButtons();
        MenuItem[] menuItemArray = new MenuItem[]{this.createMarkerSelectButton(), null, this.maxPeakData.peakButton, this.maxPeakData.nextPeakRightButton, this.minPeakData.peakButton, this.minPeakData.nextPeakRightButton};
        MenuButton menuButton = this.makeMenuButton(menuItemArray);
        this.setSelectedMarker(0);
        return menuButton;
    }

    public MenuButton getMenuButtonWithTrace() {
        return this.createMenuButtonWithTrace();
    }

    protected MenuButton createMenuButtonWithTrace() {
        this.makeMarkerToMaxPeakButtons();
        MenuItem[] menuItemArray = new MenuItem[]{this.createMarkerSelectButton(), null, null, this.maxPeakData.peakButton, this.maxPeakData.nextPeakRightButton, this.xCenterValue != null ? this.makeMarkerToCenterFrequencyButton() : null, this.yTopValue != null ? this.makeMarkerToRefLevelButton() : null};
        MenuButton menuButton = this.makeMenuButton(menuItemArray);
        this.setSelectedMarker(0);
        return menuButton;
    }

    protected MenuButton makeMenuButton(MenuItem[] menuItemArray) {
        if (this.markerMenu != null) {
            throw new RuntimeException("You already made a menu with this MarkerButtonFactory; you can't make another");
        }
        this.markerMenu = new Menu(Text.Marker, menuItemArray, 1);
        if (ModelTypeMgr.instance().getModelType() == 0) {
            return new SimpleMenuButton(Text.Marker, this.getScreen().getContextString("marker"), this.markerMenu);
        }
        return new SubMenuButton(Text.Marker, this.getScreen().getContextString("marker"), this.markerMenu);
    }

    public void updateActivity() {
        TraceAnalyzer traceAnalyzer = this.screen.getTraceAnalyzer();
        TraceMeasurement traceMeasurement = traceAnalyzer.getTraceMeasurement();
        if (this.activeData != null && traceMeasurement != null) {
            if (this.activeData.activeFinder == null) {
                this.activeData.activeFinder = traceMeasurement.createActivityFinder();
            }
            if (this.activeData.activeFinder != null) {
                Marker marker = this.getCurrentMarker();
                int[] nArray = traceMeasurement.getActivityTrace();
                this.activeData.activeFinder.processTrace(nArray, 0, 0, traceMeasurement);
                if (this.activeData.activeFinder.getNumPeaks() > 0 && marker != null && this.activeData.peakIndex != null) {
                    this.activeData.peakIndex.setValue(this.activeData.activeFinder.findPeakIndex(marker.getAbsoluteValue()));
                    this.activeData.peakButton = this.maxPeakData.peakButton;
                    if (this.markerMenu != null) {
                        MenuItem[] menuItemArray = this.markerMenu.getItems();
                        boolean bl = menuItemArray[1].isEnabled() && marker.getMarkerModel().showingNormal();
                        this.activeData.nextPeakRightButton.setEnabled(bl);
                        this.activeData.nextPeakLeftButton.setEnabled(bl);
                    }
                }
            }
        }
    }

    private void updateMaxPeakIndex() {
        if (this.maxPeakData.peakFinder != null) {
            int n = this.maxPeakData.peakFinder.getIndexForAbsoluteValue(this.getCurrentMarker().getAbsoluteValue());
            this.maxPeakData.peakIndex.setValue(n);
        }
        String string = this.maxPeakData.peakIndex.value >= 0 && this.maxPeakData.peakIndex.value <= this.maxPeakData.activeFinder.getNumPeaks() ? this.maxPeakData.peakIndex.value + 1 + "/" + this.maxPeakData.peakFinder.getNumPeaks() : "";
        this.maxPeakData.peakButton.setBodyText(string);
    }

    private void updateActivePeakIndex(long l) {
        if (this.activeData.activeFinder != null) {
            int n = this.activeData.activeFinder.findPeakIndex(l);
            this.activeData.peakIndex.setValue(n);
        }
    }

    private void makeMarkerToMinPeakButtons() {
        this.minPeakData.peakIndex = new MutableInteger(-1);
        this.minPeakData.nextPeakRightButton = new PushButton(Text.Marker_To_n_Next_Min, "marker.toNextMinPeak");
        this.minPeakData.nextPeakRightAction = new MarkerToNextPeakRightAction(this.minPeakData);
        this.minPeakData.nextPeakRightButton.addActionListener(this.minPeakData.nextPeakRightAction);
        this.minPeakData.nextPeakRightButton.setEnabled(false);
        this.minPeakData.peakButton = new PushButton(Text.Marker_To_n_Min, "marker.toMinPeak", new MarkerToPeakAction(this.minPeakData, this.activeData, true));
    }

    protected void makeMarkerToMaxPeakButtons() {
        this.maxPeakData.peakIndex = new MutableInteger(-1);
        this.maxPeakData.nextPeakRightButton = new PushButton(Text.Marker_To_n_Next_Peak, "marker.toNextPeak");
        this.maxPeakData.nextPeakRightAction = new MarkerToNextPeakRightAction(this.maxPeakData);
        this.maxPeakData.nextPeakRightButton.addActionListener(this.maxPeakData.nextPeakRightAction);
        this.maxPeakData.nextPeakRightButton.setEnabled(false);
        this.maxPeakData.peakButton = new PushButton(Text.Marker_To_n_Peak, "marker.toPeak", new MarkerToPeakAction(this.maxPeakData, this.activeData, false));
    }

    protected void makeMarkerToActiveButtons() {
        this.activeData.peakIndex = new MutableInteger(-1);
        this.activeData.nextPeakRightButton = new PushButton(Text.Marker_To_n_Next_Active_n_Ch_Right, "marker.toNextActiveRight");
        this.activeData.nextPeakRightAction = new MarkerToNextActiveRightAction(this.activeData);
        this.activeData.nextPeakRightButton.addActionListener(this.activeData.nextPeakRightAction);
        this.activeData.nextPeakRightButton.setEnabled(false);
        this.activeData.nextPeakLeftButton = new PushButton(Text.Marker_To_n_Next_Active_n_Ch_Left, "marker.toNextActiveRight");
        this.activeData.nextPeakLeftAction = new MarkerToNextActiveLeftAction(this.activeData);
        this.activeData.nextPeakLeftButton.addActionListener(this.activeData.nextPeakLeftAction);
        this.activeData.nextPeakLeftButton.setEnabled(false);
    }

    PushButton makeMarkerToCenterFrequencyButton() {
        if (this.xCenterValue == null) {
            return null;
        }
        return new PushButton(Text.Center_Freq_n_To_Marker, "marker.to.cf", new MarkerToCenterFrequencyAction());
    }

    public PushButton makeMarkerToRefLevelButton() {
        if (this.yTopValue == null) {
            return null;
        }
        return new PushButton(Text.Ref_Level_n_To_Marker, "marker.toRefLevel", new MarkerToRefLevelAction());
    }

    protected ActuatorSubMenuButton makeMarkerTraceButton(Marker marker) {
        MarkerModel markerModel = marker.getModel();
        return new ActuatorSubMenuButton(markerModel.getMarkerTrace(), "marker.markerTrace", true, "marker.markerTrace");
    }

    public Marker getCurrentMarker() {
        if (this.selectedMarker != null) {
            return this.markers[this.selectedMarker.intValue()];
        }
        return this.markers[0];
    }

    protected void setSelectedMarker(int n) {
        if (this.markerMenu.getItems()[1] != null) {
            this.markerMenu.getItems()[1].removeNotify();
        }
        this.markerMenu.getItems()[1] = this.markerTypeButtons[n];
        if (this.markerMenu.getItems()[2] != null) {
            this.markerMenu.getItems()[2].removeNotify();
        }
        if (this.markerTraceButtons != null) {
            this.markerMenu.getItems()[2] = this.markerTraceButtons[n];
        }
        this.updateMarkerActionButtonEnabledStates();
        this.getScreen().getTraceAnalyzer().markerUpdated();
        MenuPanel menuPanel = this.screen.getScreenManager().getRightMenuPanel();
        if (menuPanel.getMenu() == this.markerMenu) {
            menuPanel.installMenu(this.markerMenu);
        }
        menuPanel.repaint();
    }

    private TrimodeActuatorButton makeMarkerTypeButton(Marker marker) {
        MarkerModel markerModel = marker.getModel();
        return new TrimodeActuatorButton((ValueListInterface)markerModel.getMode(), "", new ValueInterface[]{null, markerModel.getNormalValue(), markerModel.getDeltaValue()}, this.screen.getListenerBaseName() + ".markerTypeButton");
    }

    protected void updateMarkerActionButtonEnabledStates() {
        if (this.markerMenu == null) {
            return;
        }
        MenuItem[] menuItemArray = this.markerMenu.getItems();
        boolean bl = menuItemArray[1].isEnabled() && this.getCurrentMarker().getMarkerModel().showingNormal();
        for (int i = 2; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            if (menuItem == null) continue;
            menuItem.setEnabled(bl);
        }
        if (bl && this.minPeakData.nextPeakRightAction != null) {
            this.minPeakData.nextPeakRightAction.updateEnabledState();
        }
        if (bl && this.maxPeakData.nextPeakRightAction != null) {
            this.maxPeakData.nextPeakRightAction.updateEnabledState();
        }
        if (bl && this.activeData.nextPeakLeftAction != null) {
            this.activeData.nextPeakLeftAction.updateEnabledState();
        }
        if (bl && this.activeData.nextPeakRightAction != null) {
            this.activeData.nextPeakRightAction.updateEnabledState();
        }
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        Marker[] markerArray = this.getMarkers();
        for (int i = 0; i < markerArray.length; ++i) {
            Marker marker = markerArray[i];
            marker.setMeasurement(traceMeasurement);
            if (this.markerTypeButtons[i].isEnabled()) continue;
            this.markerTypeButtons[i].setEnabled(true);
            if (this.markerMenu == null || this.markerTypeButtons[i] != this.markerMenu.getItems()[1]) continue;
            this.updateMarkerActionButtonEnabledStates();
        }
    }

    protected MeasurementScreen getScreen() {
        return this.screen;
    }

    public void dispose() {
        this.removeValueListeners();
        this.disposeMarkers(this.markers);
        this.selectedMarker = null;
        this.markerSettings = null;
        this.screen = null;
        this.xCenterValue = null;
        this.yTopValue = null;
    }

    public void disposeMarkers() {
        for (int i = 0; i < this.markers.length; ++i) {
            this.markers[i].getModel().getMode().removeValueListener(this.markerUpdatedListeners[i]);
            this.markers[i].getModel().getMode().removeValueListener(this.modeListeners[i]);
            this.markers[i].getModel().getNormalValue().removeValueListener(this.markerUpdatedListeners[i]);
            this.markers[i].getModel().getDeltaValue().removeValueListener(this.markerUpdatedListeners[i]);
            this.markers[i].dispose();
            this.markers[i] = null;
        }
    }

    static class MutableInteger {
        public int value;

        public MutableInteger(int n) {
            this.value = n;
        }

        public void setValue(int n) {
            this.value = n;
        }
    }

    class MarkerToRefLevelAction
    implements ActionListener {
        MarkerToRefLevelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Marker marker = MarkerButtonFactory.this.getCurrentMarker();
            MarkerButtonFactory.this.yTopValue.setValue(marker.getAbsolutePowerLevel());
            MarkerButtonFactory.this.yTopValue.send();
        }
    }

    class MarkerToCenterFrequencyAction
    implements ActionListener {
        MarkerToCenterFrequencyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Marker marker = MarkerButtonFactory.this.getCurrentMarker();
            MarkerButtonFactory.this.xCenterValue.setValue(marker.getAbsoluteValue());
            MarkerButtonFactory.this.xCenterValue.send();
        }
    }

    protected class MarkerToNextActiveRightAction
    extends MarkerToNextPeakRightAction {
        public MarkerToNextActiveRightAction(PeakButtonData peakButtonData) {
            super(peakButtonData);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Marker marker = MarkerButtonFactory.this.getCurrentMarker();
            int n = this.data.activeFinder.getNumPeaks();
            ++this.data.peakIndex.value;
            if (this.data.peakIndex.value >= n) {
                this.data.peakIndex.setValue(n - 1);
            }
            marker.setAbsoluteValue(this.data.activeFinder.getPeakXValue(this.data.peakIndex.value));
            MarkerButtonFactory.this.updateMaxPeakIndex();
            this.updateEnabledState();
        }

        void updateEnabledState() {
            boolean bl = this.data.peakIndex.value >= 1 && this.data.peakIndex.value < this.data.activeFinder.getNumPeaks();
            this.data.nextPeakRightButton.setEnabled(bl);
        }
    }

    protected class MarkerToNextActiveLeftAction
    extends MarkerToNextPeakLeftAction {
        public MarkerToNextActiveLeftAction(PeakButtonData peakButtonData) {
            super(peakButtonData);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2;
            Marker marker = MarkerButtonFactory.this.getCurrentMarker();
            int n = MarkerButtonFactory.this.activeData.peakIndex.value;
            this.data.peakIndex.value = n == this.data.activeFinder.getNumPeaks() - 1 ? ((l2 = marker.getAbsoluteValue()) > (l = this.data.activeFinder.getPeakXValue(this.data.peakIndex.value)) ? n : --this.data.peakIndex.value) : --this.data.peakIndex.value;
            if (this.data.peakIndex.value < 0) {
                this.data.peakIndex.setValue(0);
            }
            marker.setAbsoluteValue(this.data.activeFinder.getPeakXValue(this.data.peakIndex.value));
            MarkerButtonFactory.this.updateMaxPeakIndex();
            this.updateEnabledState();
        }

        void updateEnabledState() {
            boolean bl = this.data.peakIndex.value >= 0;
            this.data.nextPeakLeftButton.setEnabled(bl);
        }
    }

    protected class MarkerToNextPeakRightAction
    implements ActionListener {
        protected final PeakButtonData data;

        public MarkerToNextPeakRightAction(PeakButtonData peakButtonData) {
            this.data = peakButtonData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Marker marker = MarkerButtonFactory.this.getCurrentMarker();
            String string = this.data.peakIndex.value >= 0 && this.data.peakIndex.value <= this.data.peakFinder.getNumPeaks() ? this.data.peakIndex.value + 1 + "/" + this.data.peakFinder.getNumPeaks() : "";
            this.data.peakButton.setBodyText(string);
            long l = this.data.peakFinder.getPeakXValue(this.data.peakIndex.value++);
            MarkerButtonFactory.this.updateActivePeakIndex(l);
            marker.setAbsoluteValue(l);
            this.updateEnabledState();
        }

        void updateEnabledState() {
            boolean bl = this.data.peakIndex.value >= 0 && this.data.peakIndex.value < this.data.peakFinder.getNumPeaks();
            this.data.nextPeakRightButton.setEnabled(bl);
        }
    }

    protected class MarkerToNextPeakLeftAction
    implements ActionListener {
        protected final PeakButtonData data;

        public MarkerToNextPeakLeftAction(PeakButtonData peakButtonData) {
            this.data = peakButtonData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Marker marker = MarkerButtonFactory.this.getCurrentMarker();
            String string = this.data.peakIndex.value >= 0 && this.data.peakIndex.value <= this.data.peakFinder.getNumPeaks() ? this.data.peakIndex.value + 1 + "/" + this.data.peakFinder.getNumPeaks() : "";
            this.data.peakButton.setBodyText(string);
            marker.setAbsoluteValue(this.data.peakFinder.getPeakXValue(this.data.peakIndex.value--));
            this.updateEnabledState();
        }

        void updateEnabledState() {
            boolean bl = this.data.peakIndex.value >= 0 && this.data.peakIndex.value < this.data.peakFinder.getNumPeaks();
            this.data.nextPeakRightButton.setEnabled(bl);
        }
    }

    protected static class PeakButtonData {
        PeakFinder peakFinder;
        ActivityFinder activeFinder;
        MutableInteger peakIndex;
        ActionButton peakButton;
        ActionButton nextPeakRightButton;
        ActionButton nextPeakLeftButton;
        MarkerToNextPeakRightAction nextPeakRightAction;
        MarkerToNextPeakLeftAction nextPeakLeftAction;

        protected PeakButtonData() {
        }
    }

    private class MarkerToPeakAction
    implements ActionListener {
        private final PeakButtonData data;
        private final boolean shouldFindMinPeaks;

        MarkerToPeakAction(PeakButtonData peakButtonData, PeakButtonData peakButtonData2, boolean bl) {
            this.data = peakButtonData;
            this.shouldFindMinPeaks = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TraceAnalyzer traceAnalyzer = MarkerButtonFactory.this.screen.getTraceAnalyzer();
            TraceMeasurement traceMeasurement = traceAnalyzer.getTraceMeasurement();
            if (this.data.peakFinder == null) {
                this.data.peakFinder = traceMeasurement.createPeakFinder();
            }
            boolean bl = traceMeasurement.isTraceInverted();
            boolean bl2 = bl ^ this.shouldFindMinPeaks;
            int[] nArray = traceMeasurement.getMarkerTrace(MarkerButtonFactory.this.getCurrentMarker().getMarkerModel().getMarkerTraceIndex());
            if (bl2) {
                nArray = TraceMeasurement.inverted(nArray);
            }
            int n = traceMeasurement.getIndexForXValue(traceAnalyzer.getViewStartValue());
            int n2 = traceMeasurement.getIndexForXValue(traceAnalyzer.getViewStopValue());
            int n3 = n2 - n + 1;
            this.data.peakFinder.processTrace(nArray, n, n3, traceMeasurement);
            this.data.peakIndex.value = 0;
            this.data.nextPeakRightButton.setEnabled(true);
            if (this.data.activeFinder == null) {
                this.data.activeFinder = traceMeasurement.createActivityFinder();
            }
            if (this.data.activeFinder != null) {
                int[] nArray2 = traceMeasurement.getActivityTrace();
                this.data.activeFinder.setMaxPeakIndex(this.data.peakFinder.getFirstPeakIndex());
                this.data.activeFinder.processTrace(nArray2, 0, 0, traceMeasurement);
                MarkerButtonFactory.this.activeData.peakIndex.setValue(this.data.activeFinder.getMaxPeakIndex());
                MarkerButtonFactory.this.activeData.peakButton = this.data.peakButton;
                MarkerButtonFactory.this.activeData.activeFinder = this.data.activeFinder;
            }
            this.data.nextPeakRightAction.actionPerformed(actionEvent);
        }
    }
}

