/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.marker;

import elgato.infrastructure.widgets.ImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.Icon;

public class MarkerIcon
implements Icon {
    public static final int TEXT_ABOVE = 0;
    public static final int TEXT_RIGHT = 1;
    public static final int TEXT_BELOW = 2;
    public static final int TEXT_LEFT = 3;
    private static final int[] markerColors = new int[]{0xFFFFFF, 0xFFAAAA, 0xFFFFAA, 0xAAAAFF};
    private static final Image[] markerImages = new Image[]{null, null, null, null};
    private static final Font font = new Font("SansSerif", 0, 10);
    private static final int textHeight = 12;
    private static final int spaceAbovePointer = 1;
    private static final int stringWidthFudgeFactor = 1;
    private final Color color;
    private final String label;
    private final javax.swing.ImageIcon pointer;

    public static MarkerIcon getIcon(int n, boolean bl, Component component) {
        return new MarkerIcon(n, bl, component);
    }

    private MarkerIcon(int n, boolean bl, Component component) {
        String string = String.valueOf(n + 1);
        if (bl) {
            string = "\u0394" + string;
        }
        this.label = string;
        int n2 = markerColors[n];
        this.color = new Color(n2);
        if (markerImages[n] == null) {
            Image image = ImageIcon.loadImage("images/Marker.png", component);
            Image image2 = MarkerIcon.colorize(image, n2);
            ImageIcon.waitForImage(image2, component);
            MarkerIcon.markerImages[n] = image2;
            this.pointer = new javax.swing.ImageIcon(image2);
        } else {
            this.pointer = new javax.swing.ImageIcon(markerImages[n]);
        }
    }

    private static Image colorize(Image image, int n) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int[] nArray = new int[n2 * n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n3, nArray, 0, n2);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while grabbing pixels from marker image");
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] & 0xFF000000 | n;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3, nArray, 0, n2);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public String getLabel() {
        return this.label;
    }

    public int getIconHeight() {
        return this.pointer.getIconHeight() + 12;
    }

    public int getIconWidth() {
        return this.pointer.getIconWidth();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.color);
        int n3 = fontMetrics.stringWidth(this.label) - 1;
        int n4 = n + (this.getIconWidth() - n3) / 2;
        int n5 = n2 + 12 - 1;
        graphics.drawString(this.label, n4, n5);
        this.pointer.paintIcon(component, graphics, n, n2 + 12);
    }

    public void paintIconText(Component component, Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.color);
        int n6 = fontMetrics.stringWidth(this.label) - 1;
        switch (n3) {
            case 1: {
                n5 = n;
                n4 = n2 - 1 + 6;
                break;
            }
            case 2: {
                n5 = n - n6 / 2;
                n4 = n2 + 12 - 1;
                break;
            }
            case 3: {
                n5 = n - n6;
                n4 = n2 - 6;
                break;
            }
            default: {
                n5 = n - n6 / 2;
                n4 = n2 - 2;
            }
        }
        Dimension dimension = component.getSize();
        int n7 = dimension.width;
        int n8 = dimension.height;
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 + n6 + 1 > n7) {
            n5 = n7 - n6 - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > n8) {
            n4 = n8 - 12;
        }
        graphics.drawString(this.label, n5, n4);
    }

    public Color getColor() {
        return this.color;
    }
}

