/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.marker;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;

public class MarkerModel {
    static final Value OFF = Value.createValue(Text.Off, 0);
    static final Value NORMAL = Value.createValue(Text.Normal, 1);
    static final Value DELTA = Value.createValue(Text.DELTA_SYMBOL, 2);
    private ListActuator mode;
    private LongActuator normalValue;
    private LongActuator deltaValue;
    private final int markerIndex;
    private LongActuator xPrototypeValue;
    private LongActuator normValueShown;
    private LongActuator deltaValueShown;
    private ListActuator trace;

    MarkerModel(String string, int n, LongActuator longActuator) {
        this(string, n, longActuator, null);
    }

    MarkerModel(String string, int n, LongActuator longActuator, Value[] valueArray) {
        this.mode = new ListActuator(string, "mkrMode" + n, Text.Type, new Value[]{OFF, NORMAL, DELTA});
        this.xPrototypeValue = longActuator;
        String string2 = Text.MKR + " " + (n + 1) + " ";
        this.normalValue = this.createMarkerXValue(string2 + Text.Normal, string, "mkr" + n + "XValue");
        this.deltaValue = this.createMarkerXValue(string2 + Text.DELTA_SYMBOL, string, "mkr" + n + "DeltaXValue");
        this.markerIndex = n;
        this.normValueShown = new LongActuator(string, "mkrNormValueShown" + n, "", 0L);
        this.deltaValueShown = new LongActuator(string, "mkrDeltaValueShown" + n, "", 0L);
        this.trace = null;
        if (valueArray != null) {
            this.trace = new ListActuator(string, "mkr" + n + "Trace", Text.Trace, valueArray);
        }
    }

    public void dispose() {
        this.normValueShown.dispose();
        this.normValueShown = null;
        this.deltaValueShown.dispose();
        this.deltaValueShown = null;
        this.normalValue.dispose();
        this.normalValue = null;
        this.deltaValue.dispose();
        this.deltaValue = null;
        if (this.trace != null) {
            this.trace.dispose();
            this.trace = null;
        }
        this.mode.dispose();
        this.mode = null;
        this.xPrototypeValue = null;
    }

    public ListActuator getMode() {
        return this.mode;
    }

    public boolean showingNormal() {
        return this.mode.getSelectedValue() == NORMAL || this.mode.getSelectedValue() == DELTA;
    }

    public boolean showingDelta() {
        return this.mode.getSelectedValue() == DELTA;
    }

    public LongActuator getNormalValue() {
        return this.normalValue;
    }

    public LongActuator getDeltaValue() {
        return this.deltaValue;
    }

    public int getMarkerIndex() {
        return this.markerIndex;
    }

    public ListActuator getMarkerTrace() {
        return this.trace;
    }

    public int getMarkerTraceIndex() {
        if (this.trace == null) {
            return 0;
        }
        return this.trace.intValue();
    }

    protected LongActuator createMarkerXValue(String string, String string2, String string3) {
        LongActuator longActuator = new LongActuator(string2, string3, string){

            public void decrement(int n) {
                this.setValue(this.getValidator().decrement(this.longValue(), n));
            }

            public void increment(int n) {
                this.setValue(this.getValidator().increment(this.longValue(), n));
            }
        };
        this.configureMarkerXValue(longActuator);
        return longActuator;
    }

    private void configureMarkerXValue(LongActuator longActuator) {
        longActuator.setUnitsFactory(this.xPrototypeValue.getUnitsFactory());
        longActuator.setConversion(this.xPrototypeValue.getConversion());
        longActuator.setPalette(this.xPrototypeValue.getPalette());
    }

    public void configureValues() {
        this.configureMarkerXValue(this.getNormalValue());
        this.configureMarkerXValue(this.getDeltaValue());
    }

    public LongActuator getDeltaValueShown() {
        return this.deltaValueShown;
    }

    public LongActuator getNormValueShown() {
        return this.normValueShown;
    }

    public boolean hasNormMarkerBeenShown() {
        return this.normValueShown.intValue() == 1;
    }

    public boolean hasDeltaMarkerBeenShown() {
        return this.deltaValueShown.intValue() == 1;
    }
}

