/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.marker;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.marker.MarkerModel;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;

public class MarkerSettings
extends MeasurementSettings {
    private static final String KEY_SELECTED_MARKER = "selectedMarker";
    ListActuator selectedMarker;
    MarkerModel[] markerModels;

    protected MarkerSettings(String string, LongActuator longActuator, Value[] valueArray) {
        super(string);
        int n;
        String string2 = "display." + string;
        this.markerModels = new MarkerModel[4];
        ValueInterface[] valueInterfaceArray = new Value[this.markerModels.length];
        for (n = 0; n < valueInterfaceArray.length; ++n) {
            int n2 = n;
            valueInterfaceArray[n] = Value.createValue(String.valueOf(n2 + 1), n2);
            this.markerModels[n] = new MarkerModel(string2, n, longActuator, valueArray);
        }
        this.selectedMarker = new ListActuator(string2, KEY_SELECTED_MARKER, Text.Marker, valueInterfaceArray);
        this.add(this.selectedMarker);
        for (n = 0; n < this.markerModels.length; ++n) {
            MarkerModel markerModel = this.markerModels[n];
            this.add(markerModel.getDeltaValue());
            this.add(markerModel.getMode());
            this.add(markerModel.getNormalValue());
            this.add(markerModel.getDeltaValueShown());
            this.add(markerModel.getNormValueShown());
            if (markerModel.getMarkerTrace() == null) continue;
            this.add(markerModel.getMarkerTrace());
        }
        this.refresh();
    }

    public ListActuator getSelectedMarker() {
        return this.selectedMarker;
    }

    public MarkerModel getModel(int n) {
        return this.markerModels[n];
    }

    public void dispose() {
        this.cleanup();
        this.clearActuators();
        this.selectedMarker.dispose();
        this.selectedMarker = null;
        for (int i = 0; i < this.markerModels.length; ++i) {
            MarkerModel markerModel = this.markerModels[i];
            markerModel.dispose();
            this.markerModels[i] = null;
        }
    }
}

