/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.marker;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.marker.MarkerSettings;
import elgato.infrastructure.valueobject.Value;
import java.util.Enumeration;
import java.util.Hashtable;

public class MarkerSettingsFactory {
    private static MarkerSettingsFactory factory;
    private Hashtable settingsTable = new Hashtable();

    private MarkerSettingsFactory() {
    }

    public static MarkerSettingsFactory instance() {
        if (factory == null) {
            factory = new MarkerSettingsFactory();
        }
        return factory;
    }

    public void dispose() {
        Enumeration enumeration = this.settingsTable.elements();
        while (enumeration.hasMoreElements()) {
            ((MarkerSettings)enumeration.nextElement()).dispose();
        }
        this.settingsTable.clear();
    }

    public static void clearInstance() {
        factory = null;
    }

    public MarkerSettings getMarkerSettings(String string, LongActuator longActuator) {
        return this.getMarkerSettings(string, longActuator, null);
    }

    public MarkerSettings getMarkerSettings(String string, LongActuator longActuator, Value[] valueArray) {
        MarkerSettings markerSettings = (MarkerSettings)this.settingsTable.get(string);
        if (markerSettings != null) {
            if (markerSettings.isNeedsRefresh()) {
                markerSettings.refresh();
            }
        } else {
            markerSettings = new MarkerSettings(string, longActuator, valueArray);
            this.settingsTable.put(string, markerSettings);
        }
        return markerSettings;
    }
}

