/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.measurement.Validator;
import elgato.infrastructure.strategies.AdjustmentStrategy;

public abstract class AbstractValidator
implements Validator {
    protected AdjustmentStrategy adjustmentStrategy;
    protected int rounding = 1;

    protected abstract long doIncrement(long var1, int var3);

    protected abstract long doDecrement(long var1, int var3);

    public long increment(long l, int n) {
        if (this.adjustmentStrategy != null) {
            return this.stepValue(l, n);
        }
        return this.doIncrement(l, n);
    }

    public long decrement(long l, int n) {
        if (this.adjustmentStrategy != null) {
            return this.stepValue(l, -n);
        }
        return this.doDecrement(l, n);
    }

    private long stepValue(long l, int n) {
        long l2 = l;
        int n2 = Math.abs(n);
        while (n2-- > 0) {
            if (n < 0) {
                l2 = this.adjustmentStrategy.stepDown(l2);
                l2 = this.roundDown(l2);
                continue;
            }
            l2 = this.adjustmentStrategy.stepUp(l2);
            l2 = this.roundUp(l2);
        }
        return this.validValue(l2);
    }

    private long roundDown(long l) {
        long l2 = l % (long)this.rounding;
        if (l2 == 0L) {
            return l;
        }
        return (l / (long)this.rounding - 1L) * (long)this.rounding;
    }

    private long roundUp(long l) {
        long l2 = l % (long)this.rounding;
        if (l2 == 0L) {
            return l;
        }
        return (l / (long)this.rounding + 1L) * (long)this.rounding;
    }

    public void setAdjustmentStrategy(AdjustmentStrategy adjustmentStrategy) {
        this.adjustmentStrategy = adjustmentStrategy;
    }

    protected long round(long l) {
        int n = l > 0L ? this.rounding / 2 : -1 * (this.rounding / 2);
        return (l + (long)n) / (long)this.rounding * (long)this.rounding;
    }

    public abstract /* synthetic */ long validValue(long var1);

    public abstract /* synthetic */ boolean isValid(String var1);

    public abstract /* synthetic */ boolean isValid(long var1);
}

