/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.PercentValueListener;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public class CommonLossMeasurementSettings
extends MeasurementSettings {
    private final String TOPIC = this.getTopic();
    protected final String DISPLAY_TOPIC = "display." + this.TOPIC;
    protected ScaleDivActuator scaleDiv = new ScaleDivActuator(this.DISPLAY_TOPIC);
    protected LongActuator refLevel = LongActuator.createRefLevelActuator(this.DISPLAY_TOPIC, 0, "dB", -10000, 150000, this.scaleDiv);
    private LongActuator numAverages = LongActuator.createNumAverages(this.TOPIC, 100);
    private ListActuator averaging = ListActuator.createStandardAveraging(this.TOPIC);
    private ListActuator interferenceRejection = ListActuator.createInterferenceRejection(this.TOPIC);
    private final LongActuator mode = new LongActuator(this.TOPIC, "mode", "", 8L);
    private FrequencyActuator startFreq = FrequencyActuator.createGlobalKilohertz(this.TOPIC, "start", Text.Start_Freq);
    private FrequencyActuator stopFreq = FrequencyActuator.createGlobalKilohertz(this.TOPIC, "stop", Text.Stop_Freq);

    protected CommonLossMeasurementSettings(String string) {
        super(string);
        this.add(this.mode);
        this.add(this.scaleDiv);
        this.add(this.numAverages);
        this.add(this.interferenceRejection);
        this.add(this.averaging);
        this.add(this.startFreq);
        this.add(this.stopFreq);
        this.setValidatorToFreqSrcLimits(this.startFreq, 3);
        this.setValidatorToFreqSrcLimits(this.stopFreq, 3);
        this.startFreq.setValue(1850000000L);
        this.stopFreq.setValue(1990000000L);
        PercentValueListener percentValueListener = PercentValueListener.createTenPercentValueListener(this.startFreq, this.stopFreq, string + ".startStop10PctListener");
        this.startFreq.addValueListener(percentValueListener);
        this.stopFreq.addValueListener(percentValueListener);
        this.addAdditionalActuators();
        this.refresh();
    }

    protected void addAdditionalActuators() {
    }

    public ScaleDivActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public LongActuator getRefLevel() {
        return this.refLevel;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public FrequencyActuator getStartFrequency() {
        return this.startFreq;
    }

    public FrequencyActuator getStopFrequency() {
        return this.stopFreq;
    }

    public ListActuator getInterferenceRejection() {
        return this.interferenceRejection;
    }

    public LongActuator getMode() {
        return this.mode;
    }

    protected abstract class CommonLossValueListener
    implements ValueListener {
        private final String listenerName;

        public CommonLossValueListener(String string) {
            this.listenerName = CommonLossMeasurementSettings.this.TOPIC + "." + string + ".listener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public abstract /* synthetic */ void valueChanged(ValueInterface var1);
    }
}

