/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.measurement.CommonLossMeasurementSettings;
import elgato.infrastructure.measurement.CommonLossScreen;
import elgato.infrastructure.menu.ClearCalButton;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;

public abstract class CommonLossMenuMgr
extends MeasurementMenuMgr {
    static final String COMMAND_PROCESSOR_KEY_SRCLVL = "srcAmp";
    static final String COMMAND_PROCESSOR_KEY_SRCLVL_AUTO = "autoSrcAmp";
    protected final TraceAnalyzer analyzer;
    protected final CommonLossMeasurementSettings settings;
    protected MarkerButtonFactory markerButtonFactory;

    public CommonLossMenuMgr(CommonLossScreen commonLossScreen, CommonLossMeasurementSettings commonLossMeasurementSettings, TraceAnalyzer traceAnalyzer) {
        super(commonLossScreen);
        this.settings = commonLossMeasurementSettings;
        this.analyzer = traceAnalyzer;
    }

    protected abstract MenuItem createCalFreqChanButton(CommonLossMeasurementSettings var1, String var2, String var3);

    protected abstract MenuItem createCalButton();

    protected abstract ClearCalButton createClearCalButton();

    protected abstract MenuItem createSourceLevelButton();

    protected abstract MenuItem createSetupButton(CommonLossMeasurementSettings var1);

    protected abstract MenuItem createLimitsButton();

    protected MenuButton createAverageSweepButton(CommonLossMeasurementSettings commonLossMeasurementSettings) {
        return this.createAverageSweepButton(commonLossMeasurementSettings.getNumAverages(), commonLossMeasurementSettings.getAveraging());
    }

    protected MenuButton createLevelButton(CommonLossMeasurementSettings commonLossMeasurementSettings) {
        LevelButtonFactory levelButtonFactory = new LevelButtonFactory(this.scn, this.analyzer, commonLossMeasurementSettings.getRefLevel(), commonLossMeasurementSettings.getScaleDiv(), false);
        return levelButtonFactory.createMinimalLevelMenu();
    }

    protected ActuatorEditor createStopFreqButton(CommonLossMeasurementSettings commonLossMeasurementSettings) {
        return new ActuatorEditor(commonLossMeasurementSettings.getStopFrequency(), this.getContextString("insertionLossCalibrate.stopFrequency"), this.getListenerBaseName() + ".stopFreqButton");
    }

    protected ActuatorEditor createStartFreqButton(CommonLossMeasurementSettings commonLossMeasurementSettings) {
        return new ActuatorEditor(commonLossMeasurementSettings.getStartFrequency(), this.getContextString("insertionLossCalibrate.startFrequency"), this.getListenerBaseName() + "startFreqButton");
    }
}

