/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.gui.ModelTypeMgr;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.commChannel.CommandTimeoutException;
import elgato.infrastructure.commChannel.DefaultCommandProcessor;
import elgato.infrastructure.commChannel.UDPMeasurementReader;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementReader;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.systemFunctions.SavedState;
import elgato.infrastructure.systemFunctions.SavedStateList;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.LogClient;
import elgato.measurement.acp.ACPMeasurement;
import elgato.measurement.acp.ACPScreen;
import elgato.measurement.backhaul.E1Measurement;
import elgato.measurement.backhaul.E1Screen;
import elgato.measurement.backhaul.T1Measurement;
import elgato.measurement.backhaul.T1Screen;
import elgato.measurement.cdma.CdmaMeasurement;
import elgato.measurement.cdma.CdmaOverAirMeasurement;
import elgato.measurement.cdma.CdmaOverAirScreen;
import elgato.measurement.cdma.CdmaScreen;
import elgato.measurement.cdma1xev.Cdma1xevMeasurement;
import elgato.measurement.cdma1xev.Cdma1xevScreen;
import elgato.measurement.channelScanner.ChannelScannerMeasurement;
import elgato.measurement.channelScanner.ChannelScannerScreen;
import elgato.measurement.dtf.DistanceToFaultMeasurement;
import elgato.measurement.dtf.DistanceToFaultScreen;
import elgato.measurement.gsm.GsmMeasurement;
import elgato.measurement.gsm.GsmScreen;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurement;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossScreen;
import elgato.measurement.powerMeter.PowerMeterMeasurement;
import elgato.measurement.powerMeter.PowerMeterScreen;
import elgato.measurement.powerSupply.PowerSupplyMeasurement;
import elgato.measurement.returnLoss.ReturnLossMeasurement;
import elgato.measurement.returnLoss.ReturnLossScreen;
import elgato.measurement.sigGen.SigGenMeasurement;
import elgato.measurement.sigGen.SigGenScreen;
import elgato.measurement.spectrum.SpectrumMeasurement;
import elgato.measurement.spectrum.SpectrumScreen;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurement;
import elgato.measurement.timeLicense.TimeLicenseMeasurement;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurement;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossScreen;
import elgato.measurement.umts.UMTSMeasurement;
import elgato.measurement.umts.UMTSOverAirMeasurement;
import elgato.measurement.umts.UMTSOverAirScreen;
import elgato.measurement.umts.UMTSScreen;
import java.io.DataInput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultMeasurementFactory
extends MeasurementFactory {
    private CommandProcessor commandProcessor;
    private MeasurementReader measurementReader;
    private ScreenManager screenManager;
    private Hashtable settingsModels;
    protected Hashtable licenses;
    private Hashtable workingHardware;
    protected Hashtable hardwareFeatures;
    private Hashtable creators;
    protected String model;
    protected String host;
    protected String serial;
    protected String ethernetNumber;
    private Vector revisionComponentNames;
    private Hashtable componentRevisionMap;
    private final Latch revisionInfoRetrived = new Latch();

    public DefaultMeasurementFactory() {
        this.measurementReader = new UDPMeasurementReader();
        this.createMeasurementSettingsModelCache();
        this.createCreators();
    }

    private void createMeasurementSettingsModelCache() {
        this.settingsModels = new Hashtable(20);
        this.createAndAddNewSettingsModelToCacheForTopic("antInsLoss");
        this.createAndAddNewSettingsModelToCacheForTopic("antSpInsLoss");
        this.createAndAddNewSettingsModelToCacheForTopic("antDtf");
        this.createAndAddNewSettingsModelToCacheForTopic("antRetLoss");
        this.createAndAddNewSettingsModelToCacheForTopic("spectrum");
        this.createAndAddNewSettingsModelToCacheForTopic("chScan");
        this.createAndAddNewSettingsModelToCacheForTopic("source");
        this.createAndAddNewSettingsModelToCacheForTopic("pwrMeter");
        this.createAndAddNewSettingsModelToCacheForTopic("t1Analyzer");
        this.createAndAddNewSettingsModelToCacheForTopic("e1Analyzer");
        this.createAndAddNewSettingsModelToCacheForTopic("umtsAn");
        this.createAndAddNewSettingsModelToCacheForTopic("umtsOa");
        this.createAndAddNewSettingsModelToCacheForTopic("cdmaAn");
        this.createAndAddNewSettingsModelToCacheForTopic("cdmaOa");
        this.createAndAddNewSettingsModelToCacheForTopic("cdma1xEvdoAn");
        this.createAndAddNewSettingsModelToCacheForTopic("gsmAn");
        this.createAndAddNewSettingsModelToCacheForTopic("timeFreqRef");
        this.createAndAddNewSettingsModelToCacheForTopic("display.global");
        this.createAndAddNewSettingsModelToCacheForTopic("system");
    }

    private void createAndAddNewSettingsModelToCacheForTopic(String string) {
        this.settingsModels.put(string, new SettingsModel(string));
    }

    private void createCreators() {
        MeasurementCreator[] measurementCreatorArray = new MeasurementCreator[]{new MeasurementCreator("antInsLoss"){

            public Measurement create(DataInput dataInput) throws IOException {
                return TwoPortInsertionLossMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("antSpInsLoss"){

            public Measurement create(DataInput dataInput) throws IOException {
                return OnePortInsertionLossMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("antRetLoss"){

            public Measurement create(DataInput dataInput) throws IOException {
                return ReturnLossMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("antDtf"){

            public Measurement create(DataInput dataInput) throws IOException {
                return DistanceToFaultMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("spectrum"){

            public Measurement create(DataInput dataInput) throws IOException {
                return SpectrumMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("chScan"){

            public Measurement create(DataInput dataInput) throws IOException {
                return ChannelScannerMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("pwrMeter"){

            public Measurement create(DataInput dataInput) throws IOException {
                return PowerMeterMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("t1Analyzer"){

            public Measurement create(DataInput dataInput) throws IOException {
                return T1Measurement.unpack(dataInput);
            }
        }, new MeasurementCreator("e1Analyzer"){

            public Measurement create(DataInput dataInput) throws IOException {
                return E1Measurement.unpack(dataInput);
            }
        }, new MeasurementCreator("umtsAn"){

            public Measurement create(DataInput dataInput) throws IOException {
                return UMTSMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("umtsOa"){

            public Measurement create(DataInput dataInput) throws IOException {
                return UMTSOverAirMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("cdmaAn"){

            public Measurement create(DataInput dataInput) throws IOException {
                return CdmaMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("cdmaOa"){

            public Measurement create(DataInput dataInput) throws IOException {
                return CdmaOverAirMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("cdma1xEvdoAn"){

            public Measurement create(DataInput dataInput) throws IOException {
                return Cdma1xevMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("gsmAn"){

            public Measurement create(DataInput dataInput) throws IOException {
                return GsmMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("timeFreqRef"){

            public Measurement create(DataInput dataInput) throws IOException {
                return TimeFreqRefMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("pwrSupply"){

            public Measurement create(DataInput dataInput) throws IOException {
                return PowerSupplyMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("source"){

            public Measurement create(DataInput dataInput) throws IOException {
                return SigGenMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("adjChan"){

            public Measurement create(DataInput dataInput) throws IOException {
                return ACPMeasurement.unpack(dataInput);
            }
        }, new MeasurementCreator("timeLicense"){

            public Measurement create(DataInput dataInput) throws IOException {
                return TimeLicenseMeasurement.unpack(dataInput);
            }
        }};
        this.creators = new Hashtable(measurementCreatorArray.length);
        for (int i = 0; i < measurementCreatorArray.length; ++i) {
            this.creators.put(measurementCreatorArray[i].getName(), measurementCreatorArray[i]);
        }
    }

    public Measurement createMeasurement(String string, DataInput dataInput) throws IOException {
        MeasurementCreator measurementCreator = (MeasurementCreator)this.creators.get(string);
        if (measurementCreator == null) {
            throw new IOException("Unknown Measurement type: '" + string + "'");
        }
        return measurementCreator.create(dataInput);
    }

    public synchronized CommandProcessor getCommandProcessor() {
        if (this.commandProcessor == null) {
            this.commandProcessor = new DefaultCommandProcessor();
        }
        return this.commandProcessor;
    }

    public MeasurementReader getMeasurementReader() {
        return this.measurementReader;
    }

    public void setScreenManager(ScreenManager screenManager) {
        if (this.screenManager != null) {
            throw new IllegalStateException("ScreenManager already defined");
        }
        this.screenManager = screenManager;
    }

    public ScreenManager getScreenManager() {
        if (this.screenManager == null) {
            throw new IllegalStateException("ScreenManager not yet defined");
        }
        return this.screenManager;
    }

    public void dumpSettingsModels() {
        try {
            Enumeration enumeration = this.settingsModels.keys();
            while (enumeration.hasMoreElements()) {
                LogClient.log("DefaultMeasurmentFactory: settingsModels key = " + enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SettingsModel getSettingsModel(String string) {
        SettingsModel settingsModel = (SettingsModel)this.settingsModels.get(string);
        if (settingsModel == null) {
            throw new IllegalArgumentException("Model not pre-cached for topic name: " + string);
        }
        return settingsModel;
    }

    public SettingsModel[] getAllSettingsModels() {
        SettingsModel[] settingsModelArray = new SettingsModel[this.settingsModels.size()];
        Enumeration enumeration = this.settingsModels.elements();
        for (int i = 0; i < settingsModelArray.length; ++i) {
            settingsModelArray[i] = (SettingsModel)enumeration.nextElement();
        }
        return settingsModelArray;
    }

    public void setLicensesAndWorkingHardware() {
        this.licenses = new Hashtable();
        this.workingHardware = new Hashtable();
        String[] stringArray = this.retrieveLicenses();
        for (int i = 0; i < stringArray.length; ++i) {
            this.licenses.put(stringArray[i], new Boolean(true));
            this.workingHardware.put(stringArray[i], new Boolean(true));
        }
    }

    public boolean isHardwareFeatureAvailable(String string) {
        return this.hardwareFeatures.get(string) != null && (Boolean)this.hardwareFeatures.get(string) != false;
    }

    public void removeHardwareFromList(String string) {
        this.workingHardware.remove(string);
    }

    public void addBogusEntry() {
        this.licenses.put("8675309", new Boolean(true));
    }

    public void retrieveSystemId() {
        MeasurementFactory.instance().getCommandProcessor().sendSystemIdCommand(new SystemIdListener());
    }

    protected String[] retrieveLicenses() {
        CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
        Command command = new Command("getLicenses");
        try {
            Command command2 = commandProcessor.call(command, "setLicenses");
            return command2.getPropertiesArray("meas");
        }
        catch (CommandTimeoutException commandTimeoutException) {
            throw new RuntimeException("Unable to get license list: No reponse from server: " + commandTimeoutException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Unable to get license list: Interrupted");
        }
    }

    public boolean isDcBiasHardwareAvailable() {
        return (Boolean)this.hardwareFeatures.get("dcOut");
    }

    public boolean isDcBiasOptionAvailable() {
        return this.licenses.get("dcOut") != null;
    }

    public int getDtfFloor() {
        return (Integer)this.hardwareFeatures.get("dtfFloor");
    }

    public int getRlFloor() {
        return (Integer)this.hardwareFeatures.get("rlFloor");
    }

    public int getOnePortFloor() {
        return (Integer)this.hardwareFeatures.get("rlFloor") / 2;
    }

    public long getFreqLimit(String string) {
        return (Long)this.hardwareFeatures.get(string);
    }

    public void retrieveHardwareFeatures() {
        CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
        Command command = new Command("getHwFeatures");
        this.hardwareFeatures = new Hashtable();
        try {
            Command command2 = commandProcessor.call(command, "setHwFeatures");
            int n = Integer.parseInt(command2.getProperty("extRefFreqMask"));
            int n2 = Integer.parseInt(command2.getProperty("dcBiasTeeHw"));
            this.hardwareFeatures.put("dcOut", new Boolean(n2 == 1));
            this.hardwareFeatures.put("10MHz", new Boolean((n & 1) != 0));
            this.hardwareFeatures.put("1966MHz", new Boolean((n & 2) != 0));
            this.hardwareFeatures.put("1MHz", new Boolean((n & 4) != 0));
            this.hardwareFeatures.put("495MHz", new Boolean((n & 8) != 0));
            this.hardwareFeatures.put("13MHz", new Boolean((n & 0x10) != 0));
            this.hardwareFeatures.put("15MHz", new Boolean((n & 0x20) != 0));
            this.hardwareFeatures.put("2048MHz", new Boolean((n & 0x40) != 0));
            this.hardwareFeatures.put("dtfFloor", new Integer(command2.getProperty("dtfFloor")));
            this.hardwareFeatures.put("rlFloor", new Integer(command2.getProperty("rlFloor")));
            this.hardwareFeatures.put("freqSrcLLimit", new Long(command2.getProperty("freqSrcLLimit")));
            this.hardwareFeatures.put("freqSrcULimit", new Long(command2.getProperty("freqSrcULimit")));
            this.hardwareFeatures.put("freqCalLLimit", new Long(command2.getProperty("freqCalLLimit")));
            this.hardwareFeatures.put("freqCalULimit", new Long(command2.getProperty("freqCalULimit")));
            this.hardwareFeatures.put("freqExtLLimit", new Long(command2.getProperty("freqExtLLimit")));
            this.hardwareFeatures.put("freqExtULimit", new Long(command2.getProperty("freqExtULimit")));
        }
        catch (CommandTimeoutException commandTimeoutException) {
            throw new RuntimeException("Unable to get hardware feature list: No reponse from server: " + commandTimeoutException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Unable to get hardware feature list: Interrupted");
        }
    }

    static Integer extractNumber(String string, String string2) {
        return new Integer(string2.substring(string.length()));
    }

    public void retrieveRevisionInfo() {
        if (this.revisionInfoRetrived.isLatched()) {
            this.revisionInfoRetrived.clearLatch();
        }
        final CommandProcessor commandProcessor = this.getCommandProcessor();
        CommandListener commandListener = new CommandListener(){

            public void commandReceived(Command command) {
                String string;
                Object object;
                int n;
                KeyValuePair[] keyValuePairArray = command.getProperties();
                Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
                for (n = 0; n < keyValuePairArray.length; ++n) {
                    if (!keyValuePairArray[n].getKey().startsWith("ver")) continue;
                    object = DefaultMeasurementFactory.extractNumber("ver", keyValuePairArray[n].getKey());
                    string = keyValuePairArray[n].getValue();
                    hashtable.put((Integer)object, string);
                }
                DefaultMeasurementFactory.this.revisionComponentNames = new Vector();
                DefaultMeasurementFactory.this.componentRevisionMap = new Hashtable();
                for (n = 0; n < keyValuePairArray.length; ++n) {
                    object = keyValuePairArray[n];
                    if (!((KeyValuePair)object).getKey().startsWith("cmp")) continue;
                    string = ((KeyValuePair)object).getValue();
                    DefaultMeasurementFactory.this.revisionComponentNames.addElement(string);
                    Integer n2 = DefaultMeasurementFactory.extractNumber("cmp", ((KeyValuePair)object).getKey());
                    String string2 = (String)hashtable.get(n2);
                    DefaultMeasurementFactory.this.componentRevisionMap.put(string, string2);
                }
                commandProcessor.removeCommandListener("setVersionInfo", this);
                DefaultMeasurementFactory.this.revisionInfoRetrived.release();
            }
        };
        commandProcessor.addCommandListener("setVersionInfo", commandListener);
        commandProcessor.send(new Command("getVersionInfo"));
    }

    public String[] getRevisionComponentNames() {
        try {
            this.revisionInfoRetrived.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted getting component revision info: " + interruptedException);
        }
        Object[] objectArray = new String[this.revisionComponentNames.size()];
        this.revisionComponentNames.copyInto(objectArray);
        return objectArray;
    }

    public String getComponentRevision(String string) {
        try {
            this.revisionInfoRetrived.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted getting component revision info: " + interruptedException);
        }
        return (String)this.componentRevisionMap.get(string);
    }

    public boolean measurementAvailable(String string) {
        if (this.licenses == null) {
            throw new IllegalStateException("licenses not initialized");
        }
        return this.licenses.get(string) != null && this.workingHardware.get(string) != null;
    }

    public boolean optionAvailable(String string) {
        return this.measurementAvailable(string);
    }

    public String[] getLicensedList() {
        Enumeration enumeration = this.licenses.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public SavedState[] getWritableSavedStates() {
        return this.getSavedStateList().getWritableStates();
    }

    public SavedState[] getDeletableSavedStates() {
        return this.getSavedStateList().getDeletableStates();
    }

    public SavedStateList getSavedStateList() {
        try {
            Command command = this.getCommandProcessor().call(new Command("getStateList"), "setStateList");
            String[] stringArray = command.getPropertiesArray("config");
            SavedState[] savedStateArray = new SavedState[stringArray.length + 1];
            savedStateArray[0] = new SavedState("FactoryDefaults", false);
            for (int i = 0; i < stringArray.length; ++i) {
                savedStateArray[i + 1] = new SavedState(stringArray[i], true);
            }
            return new SavedStateList(command.getProperty("current"), "Powerup", savedStateArray);
        }
        catch (CommandTimeoutException commandTimeoutException) {
            throw new RuntimeException("Couldn't get saved state list: no response from server: " + commandTimeoutException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Couldn't get saved state list: thread interrupted: " + interruptedException);
        }
    }

    public Screen getScreenForMeasurementType(String string) {
        return DefaultMeasurementFactory.makeProperScreen(string);
    }

    public static Screen makeProperScreen(String string) {
        if ("spectrum".equals(string)) {
            return new SpectrumScreen();
        }
        if ("antRetLoss".equals(string)) {
            return new ReturnLossScreen();
        }
        if ("cdmaAn".equals(string)) {
            return new CdmaScreen();
        }
        if ("cdmaOa".equals(string)) {
            return new CdmaOverAirScreen();
        }
        if ("cdma1xEvdoAn".equals(string)) {
            return new Cdma1xevScreen();
        }
        if ("chScan".equals(string)) {
            return new ChannelScannerScreen();
        }
        if ("gsmAn".equals(string)) {
            return new GsmScreen();
        }
        if ("antDtf".equals(string)) {
            return new DistanceToFaultScreen();
        }
        if ("antInsLoss".equals(string)) {
            return new TwoPortInsertionLossScreen();
        }
        if ("antSpInsLoss".equals(string)) {
            return new OnePortInsertionLossScreen();
        }
        if ("pwrMeter".equals(string)) {
            return new PowerMeterScreen();
        }
        if ("source".equals(string)) {
            return new SigGenScreen();
        }
        if ("t1Analyzer".equals(string)) {
            return new T1Screen();
        }
        if ("e1Analyzer".equals(string)) {
            return new E1Screen();
        }
        if ("umtsAn".equals(string)) {
            return new UMTSScreen();
        }
        if ("umtsOa".equals(string)) {
            return new UMTSOverAirScreen();
        }
        if ("adjChan".equals(string)) {
            return new ACPScreen();
        }
        throw new IllegalArgumentException("Unknown measurement type: " + string);
    }

    public boolean validMeasurementType(String string) {
        for (int i = 0; i < MeasurementFactory.MEASUREMENT_TYPES.length; ++i) {
            if (string != MeasurementFactory.MEASUREMENT_TYPES[i]) continue;
            return true;
        }
        return false;
    }

    public String getModel() {
        return this.model;
    }

    public String getHost() {
        return this.host;
    }

    public String getSerial() {
        return this.serial;
    }

    private static class Latch {
        private boolean latched;

        private Latch() {
        }

        public synchronized void release() {
            this.latched = true;
            this.notifyAll();
        }

        public synchronized void acquire() throws InterruptedException {
            while (!this.latched) {
                this.wait();
            }
        }

        public synchronized boolean isLatched() {
            return this.latched;
        }

        public synchronized void clearLatch() {
            if (!this.isLatched()) {
                throw new RuntimeException("Latch already cleared");
            }
            this.latched = false;
        }
    }

    private class SystemIdListener
    implements CommandListener {
        private SystemIdListener() {
        }

        public void commandReceived(Command command) {
            DefaultMeasurementFactory.this.model = command.getProperty("model");
            DefaultMeasurementFactory.this.host = command.getProperty("hostId");
            DefaultMeasurementFactory.this.serial = command.getProperty("serialNum");
            DefaultMeasurementFactory.this.ethernetNumber = command.getProperty("ethernetNumber");
            ModelTypeMgr.instance().setModelType(DefaultMeasurementFactory.this.model);
            ModelTypeMgr.instance().setEthernetNumber(DefaultMeasurementFactory.this.ethernetNumber);
            MeasurementFactory.instance().getCommandProcessor().removeCommandListener("getSystemId", this);
        }
    }

    private static abstract class MeasurementCreator {
        final String name;

        MeasurementCreator(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        abstract Measurement create(DataInput var1) throws IOException;
    }
}

