/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.LocationMonitorWindow;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public class DisplayGlobalMeasurementSettings
extends MeasurementSettings {
    private static final String TOPIC = "display.global";
    private static DisplayGlobalMeasurementSettings instance;
    private LongActuator channelStep = new LongActuator("display.global", "ccStep", Text.Chan_Step, 50L){

        public void send(long l) {
            if (this.longValue() != l) {
                super.send(l);
            }
        }
    };
    private FrequencyActuator frequencyStep = new FrequencyActuator("display.global", "cfStep", Text.Freq_Step);
    private ListActuator frequencyAutoStepEnabled = new ListActuator("display.global", "cfStepAuto", Text.Freq_Step, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private ListActuator chanFreqUnits = new ListActuator("display.global", "freqChanUnits", Text.Units, new Value[]{Value.createValue("Freq", 0), Value.createValue("Chan", 1)});
    private ListActuator chanStd = DisplayGlobalMeasurementSettings.createChanStd("display.global", "chanStd", Text.Chan_Std);
    private static final int US_PCS = 1;
    private ListActuator gpsLocationToggle = new ListActuator("display.global", "location", Text.Show_GPS_n_Location, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private LongActuator stashingInLoss = LongActuator.createStashingLoss("display.global", "atten", 0);
    private ListActuator inLossToggle = new ListActuator("display.global", "inLossToggle", Text.RF_IN_Loss, this.createOnOffValueSet());

    private DisplayGlobalMeasurementSettings() {
        super(TOPIC);
        this.add(this.channelStep);
        this.add(this.frequencyStep);
        this.add(this.frequencyAutoStepEnabled);
        this.add(this.chanFreqUnits);
        this.add(this.chanStd);
        this.add(this.inLossToggle);
        this.add(this.stashingInLoss);
        this.gpsLocationToggle.setValue(0);
        this.gpsLocationToggle.setWebPlugConversion(WebplugConversions.createNull());
        this.gpsLocationToggle.addValueListener(new ValueListener(){
            private final String listenerName = "DisplayGlobalMeasurementSettings.gspLocationToggleListener";

            public String getListenerName() {
                return "DisplayGlobalMeasurementSettings.gspLocationToggleListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.booleanValue()) {
                    LocationMonitorWindow.showWindow();
                } else {
                    LocationMonitorWindow.hideWindow();
                }
            }
        });
        this.frequencyStep.setWebPlugConversion(WebplugConversions.createHectohertz(this.frequencyStep, this.frequencyStep.getTopic(), this.frequencyStep.getPropertyName()));
        this.frequencyStep.setIncrement(100);
        this.frequencyStep.setValue(50000);
        this.frequencyStep.setValidator(new RangeValidator(100L, 1000000000L, 2));
        this.frequencyStep.setPalette(Palette.createUnsignedDecimal());
        this.channelStep.setValidator(new RangeValidator(1L, 100L));
        this.chanFreqUnits.setValue(1);
        this.chanStd.setValue(1);
        this.refresh();
    }

    public static ListActuator createChanStd(String string, String string2, String string3) {
        ValueInterface[] valueInterfaceArray = new Value[Band.getBands().length];
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            valueInterfaceArray[i] = Value.createValue(Band.getBands()[i].toString(), i);
            ((Value)valueInterfaceArray[i]).setLongLabel(Band.getBands()[i].getLongName());
        }
        return new ListActuator(string, string2, string3, valueInterfaceArray);
    }

    public static DisplayGlobalMeasurementSettings instance() {
        if (instance == null) {
            instance = new DisplayGlobalMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public LongActuator getChannelStep() {
        return this.channelStep;
    }

    public FrequencyActuator getFrequencyStep() {
        return this.frequencyStep;
    }

    public ListActuator getFrequencyAutoStepEnabled() {
        return this.frequencyAutoStepEnabled;
    }

    public ListActuator getChanFreqUnits() {
        return this.chanFreqUnits;
    }

    public boolean isChannelSelected() {
        return this.getChanFreqUnits().intValue() == 1;
    }

    public ListActuator getChanStd() {
        return this.chanStd;
    }

    public ListActuator getGpsLocationToggle() {
        return this.gpsLocationToggle;
    }

    public ListActuator getInLossToggle() {
        return this.inLossToggle;
    }

    public LongActuator getStashingInLoss() {
        return this.stashingInLoss;
    }
}

