/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementReader;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.systemFunctions.SavedState;
import elgato.infrastructure.systemFunctions.SavedStateList;
import java.io.DataInput;
import java.io.IOException;

public abstract class MeasurementFactory {
    public static final String MEASUREMENT_NAME_SPECTRUM = "spectrum";
    public static final String MEASUREMENT_NAME_SIGNAL_GENERATOR = "source";
    public static final String MEASUREMENT_NAME_RETURNLOSS = "antRetLoss";
    public static final String MEASUREMENT_NAME_GATED_RETURNLOSS = "antGated";
    public static final String MEASUREMENT_NAME_CDMA = "cdmaAn";
    public static final String MEASUREMENT_NAME_CDMA_OA = "cdmaOa";
    public static final String MEASUREMENT_NAME_CDMA1XEVDO = "cdma1xEvdoAn";
    public static final String MEASUREMENT_NAME_UMTS = "umtsAn";
    public static final String MEASUREMENT_NAME_UMTS_OA = "umtsOa";
    public static final String MEASUREMENT_NAME_GSM = "gsmAn";
    public static final String MEASUREMENT_NAME_TWO_PORT_INSERTIONLOSS = "antInsLoss";
    public static final String MEASUREMENT_NAME_ONE_PORT_INSERTIONLOSS = "antSpInsLoss";
    public static final String MEASUREMENT_NAME_POWER_METER = "pwrMeter";
    public static final String MEASUREMENT_NAME_DTF = "antDtf";
    public static final String MEASUREMENT_NAME_CHANNEL_SCANNER = "chScan";
    public static final String MEASUREMENT_NAME_ACP = "adjChan";
    public static final String MEASUREMENT_NAME_GPS = "timeFreqRef";
    public static final String MEASUREMENT_NAME_POWER_SUPPLY = "pwrSupply";
    public static final String MEASUREMENT_NAME_T1ANALYZER = "t1Analyzer";
    public static final String MEASUREMENT_NAME_E1ANALYZER = "e1Analyzer";
    public static final String MEASUREMENT_NAME_DC_OUT = "dcOut";
    public static final String MEASUREMENT_NAME_TIME_LICENSE = "timeLicense";
    public static final String TEST_SCRIPTS_NAME_NORTEL = "script330";
    public static final String[] MEASUREMENT_TYPES = new String[]{"cdmaAn", "cdmaOa", "cdma1xEvdoAn", "gsmAn", "chScan", "antDtf", "e1Analyzer", "antGated", "antSpInsLoss", "pwrMeter", "pwrSupply", "antRetLoss", "source", "spectrum", "t1Analyzer", "antInsLoss", "umtsAn", "timeFreqRef", "adjChan", "umtsOa", "timeLicense"};
    public static final String OPTION_COMPLEX_SOURCE = "cdmaSource";
    public static final String OPTION_SPECTROGRAM = "spectrogram";
    public static final String OPTION_INTERFERENCE_ANALYSIS = "interferenceAn";
    public static final String OPTION_HSDPA_ANALYSIS = "hsdpaAn";
    public static final String OPTION_EDGE_ANALYSIS = "edgeAn";
    private static MeasurementFactory instance;
    public static final String KEY_HW_FEATURE_10MHz = "10MHz";
    public static final String KEY_HW_FEATURE_1966Hz = "1966MHz";
    public static final String KEY_HW_FEATURE_1MHz = "1MHz";
    public static final String KEY_HW_FEATURE_495MHz = "495MHz";
    public static final String KEY_HW_FEATURE_13MHz = "13MHz";
    public static final String KEY_HW_FEATURE_15MHz = "15MHz";
    public static final String KEY_HW_FEATURE_2048MHz = "2048MHz";
    public static final String KEY_HW_FEATURE_DTF_FLOOR = "dtfFloor";
    public static final String KEY_HW_FEATURE_RL_FLOOR = "rlFloor";
    public static final String KEY_HW_FEATURE_FREQ_SRC_LOWER_LIMIT = "freqSrcLLimit";
    public static final String KEY_HW_FEATURE_FREQ_SRC_UPPER_LIMIT = "freqSrcULimit";
    public static final String KEY_HW_FEATURE_FREQ_CAL_LOWER_LIMIT = "freqCalLLimit";
    public static final String KEY_HW_FEATURE_FREQ_CAL_UPPER_LIMIT = "freqCalULimit";
    public static final String KEY_HW_FEATURE_FREQ_EXT_LOWER_LIMIT = "freqExtLLimit";
    public static final String KEY_HW_FEATURE_FREQ_EXT_UPPER_LIMIT = "freqExtULimit";
    public static final String POWER_UP_STATE_KEY = "Powerup";
    public static final String USER_STATE_KEY = "User";
    public static final String VALUE_FACTORY_DEFAULTS = "FactoryDefaults";
    public static final String VALUE_MODEL_A = "E7495A";

    public static MeasurementFactory instance() {
        return instance;
    }

    public static void registerInstance(MeasurementFactory measurementFactory) {
        instance = measurementFactory;
    }

    public abstract Measurement createMeasurement(String var1, DataInput var2) throws IOException;

    public abstract CommandProcessor getCommandProcessor();

    public abstract MeasurementReader getMeasurementReader();

    public abstract void setScreenManager(ScreenManager var1);

    public abstract ScreenManager getScreenManager();

    public abstract SettingsModel getSettingsModel(String var1);

    public abstract SettingsModel[] getAllSettingsModels();

    public abstract boolean measurementAvailable(String var1);

    public boolean testScriptsAvailable(String string) {
        return this.measurementAvailable(string);
    }

    public abstract boolean optionAvailable(String var1);

    public abstract void setLicensesAndWorkingHardware();

    public abstract String[] getLicensedList();

    public abstract void retrieveRevisionInfo();

    public abstract SavedStateList getSavedStateList();

    public abstract SavedState[] getWritableSavedStates();

    public abstract SavedState[] getDeletableSavedStates();

    public abstract Screen getScreenForMeasurementType(String var1);

    public abstract boolean validMeasurementType(String var1);

    public abstract String[] getRevisionComponentNames();

    public abstract String getComponentRevision(String var1);

    public abstract void removeHardwareFromList(String var1);

    public abstract boolean isHardwareFeatureAvailable(String var1);

    public abstract void retrieveHardwareFeatures();

    public abstract void retrieveSystemId();

    public abstract String getModel();

    public abstract String getHost();

    public abstract String getSerial();

    public abstract boolean isDcBiasHardwareAvailable();

    public abstract boolean isDcBiasOptionAvailable();

    public abstract int getDtfFloor();

    public abstract int getRlFloor();

    public abstract int getOnePortFloor();
}

