/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.measurement.Measurement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class MeasurementGenerator {
    private static final int INTERFACE_VERSION = 1;
    private static final int MESSAGE_NUMBER = 5;
    private static final int MEASUREMENT_NAME_SIZE = 23;
    private final OpenByteArrayOutputStream byteArrayStream = new OpenByteArrayOutputStream(1500);

    public DataInputStream generateMeasurementDataInputStream(final String string) throws IOException {
        return this.createInputStream(new DataSource(){

            public void write(DataOutput dataOutput) throws IOException {
                MeasurementGenerator.writeHeader(dataOutput, 0x7FFE7FFE, 1, 5, string);
                MeasurementGenerator.this.writePayload(dataOutput);
                MeasurementGenerator.writeTrailer(dataOutput, 5, 0x7FFD7FFD);
            }
        });
    }

    public DataInputStream generatePayloadDataInputStream() throws IOException {
        return this.createInputStream(new DataSource(){

            public void write(DataOutput dataOutput) throws IOException {
                MeasurementGenerator.this.writePayload(dataOutput);
            }
        });
    }

    static void writeHeader(DataOutput dataOutput, int n, int n2, int n3, String string) throws IOException {
        dataOutput.writeInt(n);
        dataOutput.writeShort(n2);
        dataOutput.writeShort(n3);
        MeasurementGenerator.writeStringAsByteArray(dataOutput, string, 23);
    }

    static void writeData(DataOutput dataOutput, byte[] byArray) throws IOException {
        dataOutput.writeShort(byArray.length);
        dataOutput.write(byArray);
    }

    static void writeTrailer(DataOutput dataOutput, int n, int n2) throws IOException {
        dataOutput.writeShort(n);
        dataOutput.writeInt(n2);
    }

    protected abstract void writePayload(DataOutput var1) throws IOException;

    static void writeIntArray(DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeInt(n - i);
        }
    }

    public static void writeStringAsByteArray(DataOutput dataOutput, String string, int n) throws IOException {
        if (n > 255) {
            throw new IllegalArgumentException("maxLength " + n + " cannot be greater than 255");
        }
        if (string.length() > n) {
            throw new IllegalArgumentException("String size " + string.length() + " cannot be greater than maxLength of " + n);
        }
        dataOutput.writeByte(string.length());
        byte[] byArray = string.getBytes("US-ASCII");
        dataOutput.write(byArray);
        for (int i = byArray.length; i < n; ++i) {
            dataOutput.writeByte(0);
        }
    }

    public Measurement generate() {
        try {
            return this.unpack(this.generatePayloadDataInputStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected IO exception: " + iOException);
        }
    }

    protected abstract Measurement unpack(DataInput var1) throws IOException;

    public static byte[] makeEmptyPacket(int n, int n2, int n3, String string, int n4, int n5) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        MeasurementGenerator.writeHeader(dataOutputStream, n, n2, n3, string);
        MeasurementGenerator.writeData(dataOutputStream, new byte[0]);
        MeasurementGenerator.writeTrailer(dataOutputStream, n4, n5);
        return byteArrayOutputStream.toByteArray();
    }

    private DataInputStream createInputStream(DataSource dataSource) throws IOException {
        this.byteArrayStream.reset();
        DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayStream);
        dataSource.write(dataOutputStream);
        return new DataInputStream(new ByteArrayInputStream(this.byteArrayStream.getBuffer()));
    }

    private static class OpenByteArrayOutputStream
    extends ByteArrayOutputStream {
        public OpenByteArrayOutputStream(int n) {
            super(n);
        }

        public final byte[] getBuffer() {
            return this.buf;
        }
    }

    private static interface DataSource {
        public void write(DataOutput var1) throws IOException;
    }
}

