/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Timer;
import elgato.infrastructure.util.VectorMap;
import java.util.Vector;

public abstract class MeasurementReader {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$measurement$MeasurementReader == null ? (class$elgato$infrastructure$measurement$MeasurementReader = MeasurementReader.class$("elgato.infrastructure.measurement.MeasurementReader")) : class$elgato$infrastructure$measurement$MeasurementReader);
    private VectorMap listenerMap = new VectorMap();
    private final Timer fireMeasOverhead = new Timer("MeasurementReader/fireMeasurementReceivedOverhead");
    static /* synthetic */ Class class$elgato$infrastructure$measurement$MeasurementReader;

    public void start() {
        this.doStart();
    }

    public void stop() {
        this.doStop();
    }

    protected abstract void doStart();

    protected abstract void doStop();

    public abstract void resetDataChannel();

    protected final void readyToReceive() {
        MeasurementFactory.instance().getCommandProcessor().readyToReceive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasurementListener(MeasurementListener measurementListener, Class clazz) {
        if (measurementListener != null) {
            VectorMap vectorMap = this.listenerMap;
            synchronized (vectorMap) {
                if (logger.isDebugEnabled()) {
                    logger.debug("addMeasurementListener() listeners=" + this.listenerMap.size());
                }
                this.listenerMap.addItem(clazz, measurementListener);
            }
            this.readyToReceive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasurementListener removeMeasurementListener(MeasurementListener measurementListener, Class clazz) {
        VectorMap vectorMap = this.listenerMap;
        synchronized (vectorMap) {
            if (logger.isDebugEnabled()) {
                logger.debug("removeMeasurementListener() listeners=" + this.listenerMap.size());
            }
            return (MeasurementListener)this.listenerMap.removeItem(clazz, measurementListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMeasurementListeners(Class clazz) {
        VectorMap vectorMap = this.listenerMap;
        synchronized (vectorMap) {
            this.listenerMap.removeAll(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMeasurementReceived(Measurement measurement) {
        Object object;
        this.fireMeasOverhead.start();
        Object[] objectArray = null;
        VectorMap vectorMap = this.listenerMap;
        synchronized (vectorMap) {
            object = this.listenerMap.getItems(measurement.getClass());
            if (((Vector)object).size() == 0) {
                objectArray = new MeasurementListener[]{};
            } else {
                objectArray = new MeasurementListener[((Vector)object).size()];
                ((Vector)object).copyInto(objectArray);
            }
        }
        this.fireMeasOverhead.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("fireMeasurementReceived() firing measurement event for class: " + measurement.getClass() + " to " + objectArray.length + " listeners");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            object.measurementReceived(measurement);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

