/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.UnitsConversion;
import elgato.infrastructure.units.UnitsFactory;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MeasurementSettings
extends SettingsModel {
    protected static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$measurement$MeasurementSettings == null ? (class$elgato$infrastructure$measurement$MeasurementSettings = MeasurementSettings.class$("elgato.infrastructure.measurement.MeasurementSettings")) : class$elgato$infrastructure$measurement$MeasurementSettings);
    private static final Vector allMeasurementSettings = new Vector();
    private Hashtable actuators = new Hashtable();
    private boolean needsRefresh = true;
    public static final int VALUE_AVERAGING_OFF = 0;
    public static final int VALUE_AVERAGING_RUN = 1;
    public static final int VALUE_AVERAGING_MAX = 2;
    public static final int VALUE_AVERAGING_GROUP = 3;
    public static final int VALUE_AVERAGING_GROUP_MAX = 4;
    public static final int VALUE_CHAN_SCANNER_DISPVALUE_OFF = 0;
    public static final int VALUE_CHAN_SCANNER_DISPVALUE_FREQ = 1;
    public static final int VALUE_CHAN_SCANNER_DISPVALUE_PWR = 2;
    public static String KEY_PEAK_POWER_DETECTOR = "peakPwr";
    public static final String KEY_RANGE_UPDOWN = "rangeUpDown";
    public static final String KEY_RANGE_HOLD = "rangeHold";
    public static final int VALUE_RANGE_AUTO = 0;
    public static final int VALUE_RANGE_HOLD = 1;
    public static final int VALUE_RANGE_MAX_HOLD = 2;
    private final CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
    public static final int VALUE_POWER_AVERAGE = 0;
    public static final int VALUE_POWER_PEAK = 1;
    public static final String KEY_THRESH_LVL = "threshLv";
    public static final String KEY_PN = "pn";
    public static final String KEY_PN_INC = "pnInc";
    public static final String KEY_THRESH_OFFSET = "threshOffset";
    public static final String KEY_MEAS_TIME = "measTime";
    public static final String KEY_QPAGE = "qPageChs";
    public static final String KEY_REF_LEVEL = "refLevel";
    public static final int FORMAT_TYPE_LIST_SELECTED = 1;
    public static final int FORMAT_TYPE_CUST_SELECTED = 2;
    public static final int FORMAT_TYPE_CHAN_SELECTED = 0;
    public static final String KEY_FORMATTYPE = "formatType";
    public static final String KEY_SELECTED_FORMAT = "selectedFormat";
    public static final int VALUE_RETURN_LOSS_FLOOR_A_UNIT = 35000;
    public static final int VALUE_RETURN_LOSS_FLOOR_B_UNIT = 42000;
    public static final int VALUE_DTF_FLOOR_A_UNIT = 45000;
    public static final int VALUE_DTF_FLOOR_B_UNIT = 55000;
    public static final int AUTO = 1;
    public static final int MANUAL = 0;
    public static boolean suspendValidation = false;
    static /* synthetic */ Class class$elgato$infrastructure$measurement$MeasurementSettings;

    public MeasurementSettings(String string) {
        super(string);
        allMeasurementSettings.addElement(this);
        this.commandProcessor.addSetCommandListener(this.getTopic(), this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new RuntimeException("Method MeasurementSettings.addPropertyChangeListener() not implemented");
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new RuntimeException("Method MeasurementSettings.removePropertyChangeListener() not implemented");
    }

    public void set(String string, long l) {
        throw new RuntimeException("Method MeasurementSettings.set() not implemented");
    }

    public void set(String string, String string2) {
        throw new RuntimeException("Method MeasurementSettings.set() not implemented");
    }

    public String getString(String string) {
        throw new RuntimeException("Method MeasurementSettings.getString() not implemented");
    }

    public long getLong(String string) {
        throw new RuntimeException("Method MeasurementSettings.getLong() not implemented");
    }

    public int getInt(String string) {
        throw new RuntimeException("Method MeasurementSettings.getInt() not implemented");
    }

    public boolean propertyExists(String string) {
        throw new RuntimeException("Method MeasurementSettings.propertyExists() not implemented");
    }

    public void set(String string, boolean bl) {
        throw new RuntimeException("Method MeasurementSettings.set() not implemented");
    }

    public boolean getBoolean(String string) {
        throw new RuntimeException("Method MeasurementSettings.getBoolean() not implemented");
    }

    public void commandReceived(final Command command) {
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                if (logger.isDebugEnabled()) {
                    logger.debug("command received for MeasurementSettings with topic " + command.getProperty("topic"));
                    logger.debug("command " + command);
                }
                KeyValuePair[] keyValuePairArray = command.getProperties();
                for (int i = 0; i < keyValuePairArray.length; ++i) {
                    KeyValuePair keyValuePair = keyValuePairArray[i];
                    Actuator actuator = MeasurementSettings.this.get(keyValuePair.getKey());
                    if (actuator == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("setting actuator " + actuator.getPropertyName() + " to value " + keyValuePair.getValue());
                    }
                    try {
                        if (actuator.isSafeToChange()) {
                            actuator.receive(command);
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("actuator " + actuator.getPropertyName() + " is not yet active");
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        logger.error("Error doing actuator.receive for actuator: " + actuator.getPropertyName(), runtimeException);
                    }
                }
            }
        }, this.getClass().getName() + ".commandReceived");
    }

    protected Actuator get(String string) {
        return (Actuator)this.actuators.get(string);
    }

    public Actuator add(Actuator actuator) {
        this.actuators.put(actuator.getPropertyName(), actuator);
        return actuator;
    }

    public void clearActuators() {
        this.actuators.clear();
    }

    public void cleanup() {
        int n = allMeasurementSettings.indexOf(this);
        allMeasurementSettings.removeElementAt(n);
        this.commandProcessor.removeSetCommandListener(this.getTopic(), this);
    }

    public void refresh() {
        if (this.needsRefresh) {
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = this.actuators.elements();
            while (enumeration.hasMoreElements()) {
                Actuator actuator = (Actuator)enumeration.nextElement();
                if (vector.contains(actuator.getTopic())) continue;
                vector.addElement(actuator.getTopic());
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                Command command = Command.makeGetCommand(string);
                enumeration = this.actuators.elements();
                while (enumeration.hasMoreElements()) {
                    Actuator actuator = (Actuator)enumeration.nextElement();
                    if (logger.isDebugEnabled()) {
                        logger.debug("actuator name: " + actuator.getPropertyName());
                    }
                    if (!actuator.getTopic().equals(string)) continue;
                    actuator.buildInitialGet(command);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending inital get for " + this.getClass().getName() + "\n" + command.toString());
                }
                this.commandProcessor.send(command);
            }
            this.needsRefresh = false;
        }
    }

    public void invalidate() {
        this.needsRefresh = true;
    }

    public static void makeAllMeasurementSettingsInvalid() {
        for (int i = 0; i < allMeasurementSettings.size(); ++i) {
            MeasurementSettings measurementSettings = (MeasurementSettings)allMeasurementSettings.elementAt(i);
            measurementSettings.invalidate();
        }
    }

    protected void createHardwareFeatureListener(final LongActuator longActuator, final LongActuator longActuator2, final String string) {
        final CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
        commandProcessor.addCommandListener("setHwFeatures", new CommandListener(){

            public void commandReceived(Command command) {
                longActuator.setValue(MeasurementSettings.this.calculateDefaultRefLevel(command, string));
                MeasurementSettings.this.add(longActuator);
                MeasurementSettings.this.refreshActuator(commandProcessor, longActuator);
                longActuator2.setValue(MeasurementSettings.this.calculateDefaultScaleDiv(command, string));
                MeasurementSettings.this.add(longActuator2);
                MeasurementSettings.this.refreshActuator(commandProcessor, longActuator2);
                commandProcessor.removeCommandListener("setHwFeatures", this);
            }
        });
        commandProcessor.send(new Command("getHwFeatures"));
    }

    protected void setValidatorToFreqExtLimits(LongActuator longActuator) {
        this.setFreqLimits(longActuator, "freqExtLLimit", "freqExtULimit", 0);
    }

    protected void setValidatorToFreqSrcLimits(LongActuator longActuator) {
        this.setFreqLimits(longActuator, "freqSrcLLimit", "freqSrcULimit", 0);
    }

    protected void setValidatorToFreqCalLimits(LongActuator longActuator) {
        this.setFreqLimits(longActuator, "freqCalLLimit", "freqCalULimit", 0);
    }

    protected void setValidatorToFreqExtLimits(LongActuator longActuator, int n) {
        this.setFreqLimits(longActuator, "freqExtLLimit", "freqExtULimit", n);
    }

    protected void setValidatorToFreqSrcLimits(LongActuator longActuator, int n) {
        this.setFreqLimits(longActuator, "freqSrcLLimit", "freqSrcULimit", n);
    }

    protected void setValidatorToFreqCalLimits(LongActuator longActuator, int n) {
        this.setFreqLimits(longActuator, "freqCalLLimit", "freqCalULimit", n);
    }

    private void setFreqLimits(final LongActuator longActuator, final String string, final String string2, int n) {
        final CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
        final int n2 = n;
        longActuator.setValidator(new RangeValidator(Long.MIN_VALUE, Long.MAX_VALUE, n2));
        commandProcessor.addCommandListener("setHwFeatures", new CommandListener(){

            public void commandReceived(Command command) {
                long l = Long.parseLong(command.getProperty(string)) * 1000L;
                long l2 = Long.parseLong(command.getProperty(string2)) * 1000L;
                longActuator.setValidator(new RangeValidator(l, l2, n2));
                commandProcessor.removeCommandListener("setHwFeatures", this);
            }
        });
        commandProcessor.send(new Command("getHwFeatures"));
    }

    public int calculateDefaultRefLevel(Command command, String string) {
        if (string.equals("antDtf")) {
            if (Integer.parseInt(command.getProperty("dtfFloor")) == 45000) {
                return -5000;
            }
            if (Integer.parseInt(command.getProperty("dtfFloor")) == 55000) {
                return 5000;
            }
        } else if (string.equals("antRetLoss")) {
            if (Integer.parseInt(command.getProperty("rlFloor")) == 35000) {
                return -5000;
            }
            if (Integer.parseInt(command.getProperty("rlFloor")) == 42000) {
                return -5000;
            }
        } else if (string.equals("antSpInsLoss")) {
            if (Integer.parseInt(command.getProperty("rlFloor")) == 35000) {
                return -4000;
            }
            if (Integer.parseInt(command.getProperty("rlFloor")) == 42000) {
                return -3000;
            }
        }
        return 999;
    }

    public int calculateDefaultScaleDiv(Command command, String string) {
        if (string.equals("antDtf")) {
            if (Integer.parseInt(command.getProperty("dtfFloor")) == 45000) {
                return 5000;
            }
            if (Integer.parseInt(command.getProperty("dtfFloor")) == 55000) {
                return 5000;
            }
        } else if (string.equals("antRetLoss")) {
            if (Integer.parseInt(command.getProperty("rlFloor")) == 35000) {
                return 5000;
            }
            if (Integer.parseInt(command.getProperty("rlFloor")) == 42000) {
                return 5000;
            }
        } else if (string.equals("antSpInsLoss")) {
            if (Integer.parseInt(command.getProperty("rlFloor")) == 35000) {
                return 2000;
            }
            if (Integer.parseInt(command.getProperty("rlFloor")) == 42000) {
                return 3000;
            }
        }
        return 999;
    }

    private void refreshActuator(CommandProcessor commandProcessor, LongActuator longActuator) {
        Command command = Command.makeGetCommand(longActuator.getTopic());
        longActuator.getWebPlugConversion().buildInitialGet(command);
        commandProcessor.send(command);
    }

    public boolean isNeedsRefresh() {
        return this.needsRefresh;
    }

    private void localStashedActuatorSet(final Actuator actuator, final LongActuator longActuator, final Actuator actuator2, final int n, final boolean bl, final String string) {
        actuator2.setLabel(longActuator.getLabel());
        actuator2.addValueListener(new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = string + ".stashingActuatorListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (actuator.intValue() == n) {
                    if (MeasurementSettings.this.reallyChanged(longActuator, actuator2)) {
                        longActuator.setValue(valueInterface.longValue());
                        longActuator.send();
                        actuator2.send();
                    }
                } else if (bl) {
                    longActuator.setValue(0);
                    longActuator.send();
                }
            }
        });
        actuator.addValueListener(new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = string + ".toggleListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() == n) {
                    actuator.send();
                }
                actuator2.fireValueChanged();
            }
        });
    }

    protected void makeStashedActuatorSet(Actuator actuator, LongActuator longActuator, Actuator actuator2, int n, String string) {
        this.localStashedActuatorSet(actuator, longActuator, actuator2, n, false, string);
    }

    public void makeStashedLossActuatorSet(Actuator actuator, LongActuator longActuator, Actuator actuator2, String string) {
        this.localStashedActuatorSet(actuator, longActuator, actuator2, 1, true, string);
    }

    private boolean reallyChanged(Actuator actuator, Actuator actuator2) {
        return actuator.longValue() != actuator2.longValue();
    }

    protected Value[] createOnOffValueSet() {
        return new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)};
    }

    public void setAllLimits() {
    }

    public LongActuator[] getStorableActuators() {
        return new LongActuator[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class UpdateIntervalUnitSystem
    extends UnitsFactory {
        private final Conversion seconds = new UnitsConversion("sec");
        private final Conversion maxSpeed = new Conversion(this){
            private static final String maxSpeedStr = "Max Speed";
            private final /* synthetic */ UpdateIntervalUnitSystem this$0;
            {
                this.this$0 = updateIntervalUnitSystem;
            }

            public long increment(int n, int n2) {
                return 0L;
            }

            public String getLabel() {
                return "Max Speed";
            }

            public long longValue(String string) {
                return 0L;
            }

            public String toString(long l) {
                return "Max Speed";
            }
        };

        public void setDefaultUnits(Conversion conversion) {
        }

        public Conversion[] getUnits() {
            return new Conversion[]{this.seconds, this.maxSpeed};
        }

        public Conversion getDefaultUnits() {
            return this.seconds;
        }

        public String toString(long l) {
            if (l == 0L) {
                return this.maxSpeed.getLabel();
            }
            return this.seconds.toString(l);
        }
    }
}

