/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

public class Palette {
    private final String palette;

    private Palette(String string) {
        this.palette = string;
    }

    public String getString() {
        return this.palette;
    }

    public static Palette createUnsignedInteger() {
        return new Palette("0123456789");
    }

    public static Palette createDefault() {
        return new Palette("abcdefghijklmnopqrstuvwxyz._-ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890");
    }

    public static Palette createUnsignedDecimal() {
        return new Palette("0123456789.");
    }

    public static Palette createHex() {
        return new Palette("0123456789ABCDEF");
    }

    public static Palette createSignedInteger() {
        return new Palette("0123456789-");
    }

    public static Palette createSignedDecimal() {
        return new Palette("0123456789-.");
    }

    public static Palette createHostName() {
        char c;
        StringBuffer stringBuffer = new StringBuffer(37);
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            stringBuffer.append(c);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            stringBuffer.append(c);
        }
        stringBuffer.append('-');
        return new Palette(stringBuffer.toString());
    }

    public boolean containsCharacter(char c) {
        return this.palette.indexOf(c) != -1;
    }
}

