/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.RuntimeConfiguration;

public abstract class PerishableMeasurement
implements Measurement {
    public boolean hasCurrentSettings() {
        if (RuntimeConfiguration.isUnitTestMode()) {
            return true;
        }
        return this.actuatorsMatchCurrentSettings();
    }

    protected boolean actuatorsMatchCurrentSettings() {
        return true;
    }

    protected boolean resultEqualsSetting(Logger logger, Actuator actuator, long l) {
        if (actuator == null) {
            return true;
        }
        if (actuator.longValue() != l) {
            if (logger != null && logger.isInfoEnabled()) {
                logger.info("result/setting mismatch for " + actuator.getPropertyName() + ": result=" + l + ", setting=" + actuator.longValue());
            }
            return false;
        }
        return true;
    }

    public abstract /* synthetic */ String getMeasurementTitle();

    public abstract /* synthetic */ float getFloatReadingValue(int var1);

    public abstract /* synthetic */ long getLongReadingValue(int var1);

    public abstract /* synthetic */ double getDoubleReadingValue(int var1);

    public abstract /* synthetic */ int getIntegerArrayReadingValue(int var1, int var2);

    public abstract /* synthetic */ int getIntegerReadingValue(int var1);

    public abstract /* synthetic */ void recycle();
}

