/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.measurement.AbstractValidator;
import elgato.infrastructure.util.FastMath;

public class RangeValidator
extends AbstractValidator {
    private final long max;
    private final long min;

    public RangeValidator(long l, long l2) {
        this(l, l2, 0);
    }

    public RangeValidator(long l, long l2, int n) {
        this.min = l;
        this.max = l2;
        this.rounding = FastMath.pow10(n);
    }

    protected long doIncrement(long l, int n) {
        long l2 = this.max;
        long l3 = l + (long)n;
        if (this.isValid(l3)) {
            l2 = l3;
        }
        return l2;
    }

    protected long doDecrement(long l, int n) {
        long l2 = this.min;
        long l3 = l - (long)n;
        if (this.isValid(l3)) {
            l2 = l3;
        }
        return l2;
    }

    public boolean isValid(long l) {
        return l <= this.max && l >= this.min;
    }

    public boolean isValid(String string) {
        try {
            return this.isValid(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public long validValue(long l) {
        if (l >= this.max) {
            return this.max;
        }
        if (l <= this.min) {
            return this.min;
        }
        return this.round(l);
    }
}

