/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;

public class SettingsModel
implements CommandListener {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$measurement$SettingsModel == null ? (class$elgato$infrastructure$measurement$SettingsModel = SettingsModel.class$("elgato.infrastructure.measurement.SettingsModel")) : class$elgato$infrastructure$measurement$SettingsModel);
    public static final String DISPLAY_TOPIC_PREFIX = "display.";
    public static final String TOPIC_DISPLAY_GLOBAL = "display.global";
    public static final String TOPIC_TIME_FREQ_REF = "timeFreqRef";
    public static final String KEY_TIME_REF = "timeRef";
    public static final String KEY_FREQ_REF = "freqRef";
    public static final String KEY_AVERAGE_NUM = "numAvg";
    public static final String KEY_CENTER_FREQUENCY = "cf";
    public static final String KEY_CENTER_FREQUENCY_OFFSET = "cfOffset";
    public static final String KEY_CENTER_FREQUENCY_STEP = "cfStep";
    public static final String KEY_CENTER_FREQUENCY_STEP_AUTO = "cfStepAuto";
    public static final String KEY_CENTER_CHANNEL_STEP = "ccStep";
    public static final String KEY_MODE = "mode";
    public static final String KEY_SPAN = "span";
    public static final String KEY_START = "start";
    public static final String KEY_STOP = "stop";
    public static final String KEY_DB_REFERENCE_LEVEL = "dbReferenceLevel";
    public static final String KEY_DB_SCALE_DIV = "dbScaleDiv";
    public static final String KEY_INTERFERECE_REJECTION = "intfrMode";
    public static final String KEY_RFIN_LOSS = "atten";
    public static final String KEY_AVERAGE_TYPE = "avgType";
    public static final String KEY_SYSTEM_GPS_LOCATION = "systemGpsLocation";
    public static final String KEY_SENSITIVITY = "sensitivity";
    public static final String KEY_FREQCHAN_UNITS = "freqChanUnits";
    public static final String KEY_GLOBAL_CHANSTD = "chanStd";
    public static final String KEY_GLOBAL_OPT_TO_INSTALL = "optToInstall";
    public static final String KEY_MARKER_CURRENT = "currentMarker";
    public static int VALUE_INTERNAL_GPS = 0;
    public static int VALUE_EXTERNAL_EVEN_SEC = 1;
    public static int VALUE_INT_10M = 0;
    public static int VALUE_EXT_10M = 1;
    public static int VALUE_EXT_13M = 6;
    public static int VALUE_EXT_19M = 2;
    public static int VALUE_USE_TIME_REF = 3;
    public static final int VALUE_CHAN_UNITS_SELECTED = 1;
    public static final int VALUE_FREQ_UNITS_SELECTED = 0;
    public static final int VALUE_OFF = 0;
    public static final int VALUE_ON = 1;
    public static final int VALUE_SENSITIVITY_LOW = 0;
    public static final int VALUE_SENSITIVITY_HIGH = 1;
    private static final Hashtable commandHandlers = new Hashtable(16);
    private static final Hashtable propertyHandlers;
    private String topic;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private final Hashtable properties = new Hashtable(64);
    private int numListeners;
    static /* synthetic */ Class class$elgato$infrastructure$measurement$SettingsModel;

    public SettingsModel(String string) {
        this.topic = string;
    }

    public String getTopic() {
        return this.topic;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ++this.numListeners;
        if (this.numListeners > 10) {
            logger.error("Suspicious number of property change listeners added to settings model with topic: " + this.getTopic() + " number of changeListeners: " + this.numListeners);
        }
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        --this.numListeners;
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    PropertyChangeSupport getPropertySupportForTesting() {
        return this.propertySupport;
    }

    public void set(String string, long l) {
        this.setPropertySkipDeps(string, new Long(l));
        this.updateDependentProperties(string, l);
    }

    public void set(String string, String string2) {
        this.setPropertySkipDeps(string, string2);
    }

    public String getString(String string) {
        Object v = this.properties.get(string);
        return v == null ? null : v.toString();
    }

    public long getLong(String string) {
        Long l;
        if (string != null && (l = (Long)this.properties.get(string)) != null) {
            return l;
        }
        return 0L;
    }

    public int getInt(String string) {
        return (int)this.getLong(string);
    }

    public boolean propertyExists(String string) {
        if (string == null) {
            return false;
        }
        return this.properties.get(string) != null;
    }

    public void set(String string, boolean bl) {
        this.set(string, bl ? 1L : 0L);
    }

    public boolean getBoolean(String string) {
        long l = this.getLong(string);
        return l == 1L;
    }

    private void setPropertySkipDeps(String string, Object object) {
        Object v = this.properties.get(string);
        this.properties.put(string, object);
        this.propertySupport.firePropertyChange(string, v, object);
    }

    private void updateDependentProperties(String string, long l) {
        SpecialPropertyHandler specialPropertyHandler = (SpecialPropertyHandler)propertyHandlers.get(string);
        if (specialPropertyHandler != null) {
            specialPropertyHandler.handle(l, this);
        }
    }

    public void commandReceived(Command command) {
        int n;
        if (!command.isSetCommand()) {
            throw new IllegalArgumentException("SettingsModel.commandReceived() only processes set commands");
        }
        String string = command.getProperty("topic");
        if (string == null) {
            throw new IllegalArgumentException("SettingsModel.commandReceived() was missing a topic");
        }
        KeyValuePair[] keyValuePairArray = command.getProperties();
        for (int i = n = 1; i < keyValuePairArray.length; ++i) {
            KeyValuePair keyValuePair = keyValuePairArray[i];
            CommandHandler commandHandler = (CommandHandler)commandHandlers.get(keyValuePair.getKey());
            if (commandHandler == null) {
                try {
                    this.set(keyValuePair.getKey(), Long.parseLong(keyValuePair.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.set(keyValuePair.getKey(), keyValuePair.getValue());
                }
                continue;
            }
            commandHandler.handle(command, this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--------------------------------\n");
        stringBuffer.append("SettingsModel Dump: TOPIC=" + this.getTopic() + "\n");
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("   " + string + "=" + this.properties.get(string) + "\n");
        }
        stringBuffer.append("--------------------------------\n");
        return stringBuffer.toString();
    }

    private void setStartAndStop(long l, long l2) {
        long l3 = l2 / 2L;
        this.setPropertySkipDeps(KEY_START, new Long(l - l3));
        this.setPropertySkipDeps(KEY_STOP, new Long(l + l3));
    }

    private void setCenterFrequencyAndSpan(long l, long l2) {
        long l3 = l2 - l;
        this.setPropertySkipDeps(KEY_SPAN, new Long(l3));
        this.setPropertySkipDeps(KEY_CENTER_FREQUENCY, new Long(l + l3 / 2L));
    }

    public static final SettingsModel getGlobalSettingsModel() {
        if (FileSystemHelper.globalSettingsModel == null) {
            FileSystemHelper.globalSettingsModel = MeasurementFactory.instance().getSettingsModel(TOPIC_DISPLAY_GLOBAL);
        }
        return FileSystemHelper.globalSettingsModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        commandHandlers.put(KEY_CENTER_FREQUENCY, new CenterFrequencyHandler(KEY_CENTER_FREQUENCY, KEY_CENTER_FREQUENCY_OFFSET));
        commandHandlers.put("srcCf", new CenterFrequencyHandler("srcCf", "srcCfOffset"));
        commandHandlers.put("srcCfOffset", new CenterFrequencyOffsetIgnorer("srcCf"));
        commandHandlers.put(KEY_SPAN, new KilohertzHandler(KEY_SPAN));
        commandHandlers.put(KEY_START, new KilohertzHandler(KEY_START));
        commandHandlers.put(KEY_STOP, new KilohertzHandler(KEY_STOP));
        commandHandlers.put(KEY_CENTER_FREQUENCY_STEP, new KilohertzHandler(KEY_CENTER_FREQUENCY_STEP));
        commandHandlers.put("startCf", new HectohertzHandler("startCf"));
        commandHandlers.put("chStep", new HectohertzHandler("chStep"));
        commandHandlers.put("chanWidth", new HectohertzHandler("chanWidth"));
        commandHandlers.put("chFreqList", new StringHandler("chFreqList"));
        propertyHandlers = new Hashtable(16);
        propertyHandlers.put(KEY_CENTER_FREQUENCY, new CenterFrequencyHandler(KEY_CENTER_FREQUENCY, KEY_CENTER_FREQUENCY_OFFSET));
        propertyHandlers.put(KEY_SPAN, new SpanFrequencyHandler());
        propertyHandlers.put(KEY_START, new StartFrequencyHandler());
        propertyHandlers.put(KEY_STOP, new StopFrequencyHandler());
    }

    private static class StringHandler
    implements CommandHandler {
        private final String propertyName;

        public StringHandler(String string) {
            this.propertyName = string;
        }

        public void handle(Command command, SettingsModel settingsModel) {
            settingsModel.set(this.propertyName, command.getProperty(this.propertyName));
        }
    }

    private static class HectohertzHandler
    implements CommandHandler {
        private final String propertyName;

        HectohertzHandler(String string) {
            this.propertyName = string;
        }

        public void handle(Command command, SettingsModel settingsModel) {
            settingsModel.set(this.propertyName, command.getLong(this.propertyName) * 100L);
        }
    }

    private static class KilohertzHandler
    implements CommandHandler {
        private final String propertyName;

        KilohertzHandler(String string) {
            this.propertyName = string;
        }

        public void handle(Command command, SettingsModel settingsModel) {
            settingsModel.set(this.propertyName, command.getLong(this.propertyName) * 1000L);
        }
    }

    private static class CenterFrequencyOffsetIgnorer
    implements CommandHandler {
        private String keyCenterFrequency;

        public CenterFrequencyOffsetIgnorer(String string) {
            this.keyCenterFrequency = string;
        }

        public void handle(Command command, SettingsModel settingsModel) {
            if (!command.propertyExists(this.keyCenterFrequency)) {
                throw new IllegalArgumentException("'cfOffset' requires 'cf' property in command.");
            }
        }
    }

    private static class StopFrequencyHandler
    implements SpecialPropertyHandler {
        private StopFrequencyHandler() {
        }

        public void handle(long l, SettingsModel settingsModel) {
            if (settingsModel.propertyExists(SettingsModel.KEY_START)) {
                settingsModel.setCenterFrequencyAndSpan(settingsModel.getLong(SettingsModel.KEY_START), l);
            }
        }
    }

    private static class StartFrequencyHandler
    implements SpecialPropertyHandler {
        private StartFrequencyHandler() {
        }

        public void handle(long l, SettingsModel settingsModel) {
            if (settingsModel.propertyExists(SettingsModel.KEY_STOP)) {
                settingsModel.setCenterFrequencyAndSpan(l, settingsModel.getLong(SettingsModel.KEY_STOP));
            }
        }
    }

    private static class SpanFrequencyHandler
    implements SpecialPropertyHandler {
        private SpanFrequencyHandler() {
        }

        public void handle(long l, SettingsModel settingsModel) {
            if (settingsModel.propertyExists(SettingsModel.KEY_CENTER_FREQUENCY)) {
                settingsModel.setStartAndStop(settingsModel.getLong(SettingsModel.KEY_CENTER_FREQUENCY), l);
            }
        }
    }

    private static class CenterFrequencyHandler
    implements SpecialPropertyHandler,
    CommandHandler {
        private String keyCenterFrequency;
        private String keyCenterFrequencyOffset;

        public CenterFrequencyHandler(String string, String string2) {
            this.keyCenterFrequency = string;
            this.keyCenterFrequencyOffset = string2;
        }

        public void handle(long l, SettingsModel settingsModel) {
            if (settingsModel.propertyExists(SettingsModel.KEY_SPAN)) {
                settingsModel.setStartAndStop(l, settingsModel.getLong(SettingsModel.KEY_SPAN));
            }
        }

        public void handle(Command command, SettingsModel settingsModel) {
            if (!command.propertyExists(this.keyCenterFrequency)) {
                throw new IllegalArgumentException("could not find 'cf' property in command.");
            }
            long l = command.getLong(this.keyCenterFrequency);
            long l2 = command.propertyExists(this.keyCenterFrequencyOffset) ? command.getLong(this.keyCenterFrequencyOffset) : 0L;
            if (l < 0L) {
                throw new IllegalArgumentException("cf out of range: " + l);
            }
            if (l2 < 0L || l2 > 999L) {
                throw new IllegalArgumentException("cfOffset out of range: " + l2);
            }
            settingsModel.set(this.keyCenterFrequency, l * 1000L + l2);
        }
    }

    private static interface SpecialPropertyHandler {
        public void handle(long var1, SettingsModel var3);
    }

    private static interface CommandHandler {
        public void handle(Command var1, SettingsModel var2);
    }
}

