/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandChannelEmulator;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.infrastructure.measurement.MeasurementReader;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.measurement.acp.ACPMeasurement;
import elgato.measurement.acp.ACPMeasurementGenerator;
import elgato.measurement.backhaul.E1Measurement;
import elgato.measurement.backhaul.E1MeasurementGenerator;
import elgato.measurement.backhaul.T1Measurement;
import elgato.measurement.backhaul.T1MeasurementGenerator;
import elgato.measurement.cdma.CdmaMeasurement;
import elgato.measurement.cdma.CdmaMeasurementGenerator;
import elgato.measurement.cdma.CdmaOverAirMeasurement;
import elgato.measurement.cdma.CdmaOverAirMeasurementGenerator;
import elgato.measurement.channelScanner.ChannelScannerMeasurement;
import elgato.measurement.channelScanner.ChannelScannerMeasurementGenerator;
import elgato.measurement.dtf.DistanceToFaultMeasurement;
import elgato.measurement.dtf.DistanceToFaultMeasurementGenerator;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurement;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurementGenerator;
import elgato.measurement.powerMeter.PowerMeterMeasurement;
import elgato.measurement.powerMeter.PowerMeterMeasurementGenerator;
import elgato.measurement.powerSupply.PowerSupplyMeasurement;
import elgato.measurement.powerSupply.PowerSupplyMeasurementGenerator;
import elgato.measurement.returnLoss.ReturnLossMeasurement;
import elgato.measurement.returnLoss.ReturnLossMeasurementGenerator;
import elgato.measurement.sigGen.SigGenMeasurement;
import elgato.measurement.sigGen.SigGenMeasurementGenerator;
import elgato.measurement.spectrum.SpectrumMeasurement;
import elgato.measurement.spectrum.SpectrumMeasurementGenerator;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurement;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementGenerator;
import elgato.measurement.twoPortInsertionLoss.InsertionLossMeasurementGenerator;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurement;
import elgato.measurement.umts.UMTSMeasurement;
import elgato.measurement.umts.UMTSMeasurementGenerator;
import elgato.measurement.umts.UMTSOverAirMeasurement;
import elgato.measurement.umts.UMTSOverAirMeasurementGenerator;

public class StubMeasurementReader
extends MeasurementReader {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$measurement$StubMeasurementReader == null ? (class$elgato$infrastructure$measurement$StubMeasurementReader = StubMeasurementReader.class$("elgato.infrastructure.measurement.StubMeasurementReader")) : class$elgato$infrastructure$measurement$StubMeasurementReader);
    private int delay;
    private long runDuration;
    private Runner runner;
    private MeasurementGenerator spectrumGenerator = new SpectrumMeasurementGenerator();
    private ReturnLossMeasurementGenerator returnLossGenerator = new ReturnLossMeasurementGenerator();
    private MeasurementGenerator insertionLossGenerator = new InsertionLossMeasurementGenerator();
    private MeasurementGenerator cdmaGenerator = new CdmaMeasurementGenerator();
    private MeasurementGenerator cdmaOaGenerator = new CdmaOverAirMeasurementGenerator();
    private MeasurementGenerator pwrMeterGenerator = new PowerMeterMeasurementGenerator();
    private MeasurementGenerator distanceToFaultMeasurementGenerator = new DistanceToFaultMeasurementGenerator();
    private MeasurementGenerator channelScannerMeasurementGenerator = new ChannelScannerMeasurementGenerator();
    private MeasurementGenerator t1MeasurementGenerator = new T1MeasurementGenerator();
    private MeasurementGenerator e1MeasurementGenerator = new E1MeasurementGenerator();
    private MeasurementGenerator sigGenMeasurementGenerator = new SigGenMeasurementGenerator();
    private MeasurementGenerator umtsMeasurementGenerator = new UMTSMeasurementGenerator();
    private MeasurementGenerator umtsOverAirMeasurementGenerator = new UMTSOverAirMeasurementGenerator();
    private MeasurementGenerator onePortMeasurementGenerator = new OnePortInsertionLossMeasurementGenerator();
    private MeasurementGenerator acpMeasurementGenerator = new ACPMeasurementGenerator();
    private CommandChannelEmulator emulator;
    static /* synthetic */ Class class$elgato$infrastructure$measurement$StubMeasurementReader;

    public StubMeasurementReader(int n, long l, CommandChannelEmulator commandChannelEmulator) {
        this.delay = n;
        this.runDuration = l;
        this.emulator = commandChannelEmulator;
        this.returnLossGenerator.setCommandChannelEmulator(commandChannelEmulator);
    }

    protected void doStart() {
        if (this.runner != null) {
            throw new IllegalArgumentException("Already started");
        }
        this.runner = new Runner();
        this.runner.start();
    }

    protected void doStop() {
        if (this.runner == null) {
            throw new IllegalArgumentException("Not started");
        }
        this.runner.shutdown();
    }

    public void resetDataChannel() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Runner
    extends Thread {
        private volatile boolean running;

        Runner() {
            super("StubReader");
            this.setDaemon(true);
        }

        public void run() {
            this.running = true;
            boolean bl = StubMeasurementReader.this.runDuration == 0L;
            long l = 0L;
            if (!bl) {
                l = System.currentTimeMillis() + StubMeasurementReader.this.runDuration;
            }
            long l2 = 0L;
            TimeFreqRefMeasurementGenerator timeFreqRefMeasurementGenerator = new TimeFreqRefMeasurementGenerator();
            timeFreqRefMeasurementGenerator.setRandomMode(true);
            long l3 = 0L;
            PowerSupplyMeasurementGenerator powerSupplyMeasurementGenerator = new PowerSupplyMeasurementGenerator();
            StubMeasurementReader.this.emulator.echo(new Command("notifyEvent", "event", "startupInProcess"));
            StubMeasurementReader.this.emulator.echo(new Command("setActive"));
            StubMeasurementReader.this.emulator.echo(new Command("notifyEvent", "event", "startupComplete"));
            while (this.running && bl || System.currentTimeMillis() < l) {
                try {
                    if (!StubMeasurementReader.this.emulator.isPaused()) {
                        String string;
                        long l4 = System.currentTimeMillis();
                        if (l4 >= l2) {
                            StubMeasurementReader.this.fireMeasurementReceived(TimeFreqRefMeasurement.unpack(timeFreqRefMeasurementGenerator.generatePayloadDataInputStream()));
                            l2 = l4 + 5000L;
                        }
                        if (l4 >= l3) {
                            StubMeasurementReader.this.fireMeasurementReceived(PowerSupplyMeasurement.unpack(powerSupplyMeasurementGenerator.generatePayloadDataInputStream()));
                            l3 = l4 + 3000L;
                        }
                        if ((string = StubMeasurementReader.this.emulator.getActiveMeasurement()) == null) {
                            Thread.sleep(1800L);
                            continue;
                        }
                        if (!StubMeasurementReader.this.emulator.inSingleMode()) {
                            if (string.equals("spectrum")) {
                                StubMeasurementReader.this.fireMeasurementReceived(SpectrumMeasurement.unpack(StubMeasurementReader.this.spectrumGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("antRetLoss")) {
                                StubMeasurementReader.this.fireMeasurementReceived(ReturnLossMeasurement.unpack(StubMeasurementReader.this.returnLossGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("antInsLoss")) {
                                StubMeasurementReader.this.fireMeasurementReceived(TwoPortInsertionLossMeasurement.unpack(StubMeasurementReader.this.insertionLossGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("antSpInsLoss")) {
                                StubMeasurementReader.this.fireMeasurementReceived(OnePortInsertionLossMeasurement.unpack(StubMeasurementReader.this.onePortMeasurementGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("cdmaAn")) {
                                StubMeasurementReader.this.fireMeasurementReceived(CdmaMeasurement.unpack(StubMeasurementReader.this.cdmaGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("cdmaOa")) {
                                StubMeasurementReader.this.fireMeasurementReceived(CdmaOverAirMeasurement.unpack(StubMeasurementReader.this.cdmaOaGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("pwrMeter")) {
                                StubMeasurementReader.this.fireMeasurementReceived(PowerMeterMeasurement.unpack(StubMeasurementReader.this.pwrMeterGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("chScan")) {
                                StubMeasurementReader.this.fireMeasurementReceived(ChannelScannerMeasurement.unpack(StubMeasurementReader.this.channelScannerMeasurementGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("antDtf")) {
                                StubMeasurementReader.this.fireMeasurementReceived(DistanceToFaultMeasurement.unpack(StubMeasurementReader.this.distanceToFaultMeasurementGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("t1Analyzer")) {
                                StubMeasurementReader.this.fireMeasurementReceived(T1Measurement.unpack(StubMeasurementReader.this.t1MeasurementGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("e1Analyzer")) {
                                StubMeasurementReader.this.fireMeasurementReceived(E1Measurement.unpack(StubMeasurementReader.this.e1MeasurementGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("source")) {
                                StubMeasurementReader.this.fireMeasurementReceived(SigGenMeasurement.unpack(StubMeasurementReader.this.sigGenMeasurementGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("umtsAn")) {
                                StubMeasurementReader.this.fireMeasurementReceived(UMTSMeasurement.unpack(StubMeasurementReader.this.umtsMeasurementGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("umtsOa")) {
                                StubMeasurementReader.this.fireMeasurementReceived(UMTSOverAirMeasurement.unpack(StubMeasurementReader.this.umtsOverAirMeasurementGenerator.generatePayloadDataInputStream()));
                            } else if (string.equals("adjChan")) {
                                StubMeasurementReader.this.fireMeasurementReceived(ACPMeasurement.unpack(StubMeasurementReader.this.acpMeasurementGenerator.generatePayloadDataInputStream()));
                            } else {
                                logger.warn("Unknown active measurement type: " + string);
                            }
                        }
                    }
                    if (StubMeasurementReader.this.delay <= 0) continue;
                    Thread.sleep(StubMeasurementReader.this.delay);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    logger.error("Error firing measurement", exception);
                }
            }
            System.exit(0);
        }

        void shutdown() {
            this.running = false;
            this.interrupt();
        }
    }
}

