/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.strategies.DistanceFeetStrategy;
import elgato.infrastructure.strategies.DistanceMetersStrategy;
import elgato.infrastructure.strategies.DistanceStrategy;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class SystemMeasurementSettings
extends MeasurementSettings {
    public static final String TOPIC = "system";
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$measurement$SystemMeasurementSettings == null ? (class$elgato$infrastructure$measurement$SystemMeasurementSettings = SystemMeasurementSettings.class$("elgato.infrastructure.measurement.SystemMeasurementSettings")) : class$elgato$infrastructure$measurement$SystemMeasurementSettings);
    public static final String KEY_SYSTEM_SCREEN_AUTONAME_FILE = "screenAutoNameFile";
    public static final String KEY_SYSTEM_SCREEN_FILE_LOCATION = "screenFileLocation";
    public static final String KEY_SYSTEM_SCREEN_FILE_EXISTS = "screenFileExists";
    public static final String KEY_SYSTEM_SCREEN_FILENAME = "screenFilename";
    public static final String KEY_SYSTEM_DATA_AUTONAME_FILE = "dataAutoNameFile";
    public static final String KEY_SYSTEM_DATA_FILE_LOCATION = "dataFileLocation";
    public static final String KEY_SYSTEM_DATA_FILE_EXISTS = "dataFileExists";
    public static final String KEY_SYSTEM_DATA_FILENAME = "dataFilename";
    public static final String KEY_SYSTEM_PRINT_FILTER = "printFilter";
    public static final String KEY_SYSTEM_SAVE_INCLUDE_TRACE = "saveDataIncludeTrace";
    private static SystemMeasurementSettings instance;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    public static int VALUE_METERS;
    public static int VALUE_FEET;
    private final ListActuator feetMeterUnits = new ListActuator("system", "units", Text.Units, new Value[]{Value.createValue(Text.Feet, VALUE_FEET), Value.createValue(Text.Meters, VALUE_METERS)});
    public static final int AMP_CAP_OFF = 0;
    public static final int AMP_CAP_ON = 1;
    private final ListActuator ampCap = new ListActuator("system", "ampCapState", Text.Amp_Cap, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private final StringActuator screenFilenameActuator = StringActuator.makeStringActuator("system", "screenFilename", "Screen Filename", Text.printScreen);
    private final StringActuator dataFilenameActuator = StringActuator.makeStringActuator("system", "dataFilename", "Data Filename", Text.saveData);
    private final LongActuator screenFileExistsActuator = new LongActuator("system", "screenFileExists", "Screen File Exists", 0L);
    private final LongActuator dataFileExistsActuator = new LongActuator("system", "dataFileExists", "Data File Exists", 0L);
    private final LongActuator screenFileLocationActuator = new LongActuator("system", "screenFileLocation", "Screen File Location", 0L);
    private final LongActuator dataFileLocationActuator = new LongActuator("system", "dataFileLocation", "Data File Location", 0L);
    private final ListActuator saveIncludeTraceActuator = new ListActuator("display.global", "saveDataIncludeTrace", Text.Include_n_Trace, this.createOnOffValueSet());
    private final ListActuator printSchemeActuator = new ListActuator("display.global", "printFilter", Text.Light_n_Background, this.createOnOffValueSet());
    public static final int RPG_SMOOTH = 0;
    public static final int RPG_BUMPY = 1;
    private final ListActuator rpgType = new ListActuator("system", "rpgType", Text.Installed_n_Knob_Type, new Value[]{Value.createValue(Text.Smooth, 0), Value.createValue(Text.Stepped, 1)});
    private ListActuator screenAutoFileName = new ListActuator("system", "screenAutoNameFile", Text.Filename, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.User, 0), Value.createValue(Text.Ask, 2)});
    private ListActuator dataAutoFileName = new ListActuator("system", "dataAutoNameFile", Text.Filename, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.User, 0), Value.createValue(Text.Ask, 2)});
    private ListActuator screenFileLocation = new ListActuator("system", "screenFileLocation", Text.File_n_Location, new Value[]{Value.createValue(Text.PCMCIA, 0), Value.createValue(Text.CF, 1)});
    private ListActuator dataFileLocation = new ListActuator("system", "dataFileLocation", Text.File_n_Location, new Value[]{Value.createValue(Text.PCMCIA, 0), Value.createValue(Text.CF, 1)});
    private ValueInterface[] autoDimValues = new ValueInterface[]{Value.createValue(Text.Disabled, 0), Value.createValue("15 sec", 15000), Value.createValue("30 sec", 30000), Value.createValue("1 min", 60000), Value.createValue("2 min", 120000), Value.createValue("3 min", 180000), Value.createValue("4 min", 240000), Value.createValue("5 min", 300000), Value.createValue("10 min", 600000), Value.createValue("15 min", 900000), Value.createValue("30 min", 1800000), Value.createValue("45 min", 2700000), Value.createValue("60 min", 3600000)};
    private ListActuator backlightAutoDimBattery = new ListActuator("system", "blAutoDimBatt", Text.Scr_Save_n_leftBanana_Battery_rightBanana, this.autoDimValues);
    private ListActuator backlightAutoDimAC = new ListActuator("system", "blAutoDimAC", Text.Scr_Save_n_leftBanana_Ext_DC_rightBanana, this.autoDimValues);
    static /* synthetic */ Class class$elgato$infrastructure$measurement$SystemMeasurementSettings;

    private SystemMeasurementSettings() {
        super(TOPIC);
        this.add(this.feetMeterUnits);
        this.add(this.ampCap);
        this.add(this.screenFilenameActuator);
        this.add(this.dataFilenameActuator);
        this.add(this.screenFileExistsActuator);
        this.add(this.dataFileExistsActuator);
        this.add(this.screenAutoFileName);
        this.add(this.dataAutoFileName);
        this.add(this.screenFileLocationActuator);
        this.add(this.dataFileLocationActuator);
        this.add(this.rpgType);
        this.add(this.backlightAutoDimBattery);
        this.add(this.backlightAutoDimAC);
        this.add(this.printSchemeActuator);
        this.add(this.saveIncludeTraceActuator);
        this.ampCap.setValue(0);
        this.feetMeterUnits.addValueListener(new ValueListener(){
            private final String listenerName = "system.feetMetersUnitsListener";

            public String getListenerName() {
                return "system.feetMetersUnitsListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() == VALUE_METERS) {
                    DistanceStrategy.registerInstance(DistanceMetersStrategy.INSTANCE);
                } else {
                    DistanceStrategy.registerInstance(DistanceFeetStrategy.INSTANCE);
                }
            }
        });
        this.feetMeterUnits.fireValueChanged();
        this.refresh();
    }

    public static SystemMeasurementSettings instance() {
        if (instance == null) {
            instance = new SystemMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public ListActuator getDtfUnits() {
        return this.feetMeterUnits;
    }

    public ListActuator getAmpCap() {
        return this.ampCap;
    }

    public static boolean displayAmpCap() {
        return SystemMeasurementSettings.instance().getAmpCap().intValue() == 1;
    }

    public int getInt(String string) {
        try {
            Actuator actuator = this.get(string);
            if (actuator == null) {
                return 0;
            }
            if (actuator instanceof LongActuator) {
                return actuator.intValue();
            }
            if (actuator instanceof ListActuator) {
                return actuator.intValue();
            }
        }
        catch (Exception exception) {
            logger.error("Unable to find actuator for key " + string);
        }
        return 0;
    }

    public String getString(String string) {
        try {
            Actuator actuator = this.get(string);
            if (actuator == null) {
                return "";
            }
            return actuator.toString();
        }
        catch (Exception exception) {
            logger.error("Unable to get actuator for key " + string);
            return "";
        }
    }

    public void set(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    public void set(String string, long l) {
        this.set(string, String.valueOf(l));
    }

    public void set(String string, boolean bl) {
        this.set(string, bl ? "1" : "0");
    }

    public void set(String string, String string2) {
        Actuator actuator = this.get(string);
        if (actuator == null) {
            logger.warn("set: No actuator");
            return;
        }
        if (actuator instanceof LongActuator) {
            actuator.setValue(string2);
        }
        if (actuator instanceof ListActuator) {
            actuator.setValue(string2);
        }
        if (actuator instanceof StringActuator) {
            actuator.setValue(string2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    PropertyChangeSupport getPropertySupportForTesting() {
        return this.propertySupport;
    }

    public boolean isFeetSelected() {
        return this.feetMeterUnits.getSelectedValueIndex() == 0;
    }

    public void sendScreenFilename(String string) {
        this.screenFilenameActuator.setValue(string);
        this.screenFilenameActuator.send();
    }

    public void sendDataFilename(String string) {
        this.dataFilenameActuator.setValue(string);
        this.dataFilenameActuator.send();
    }

    public LongActuator getScreenFileExists() {
        return this.screenFileExistsActuator;
    }

    public LongActuator getDataFileExists() {
        return this.dataFileExistsActuator;
    }

    public ListActuator getRPGType() {
        return this.rpgType;
    }

    public void setScreenFilename(String string) {
        this.screenFilenameActuator.setValue(string);
    }

    public void setDataFilename(String string) {
        this.dataFilenameActuator.setValue(string);
    }

    public String getFilename(String string) {
        return this.getString(string);
    }

    public String getScreenFilename() {
        return this.screenFilenameActuator.toString();
    }

    public String getDataFilename() {
        return this.dataFilenameActuator.toString();
    }

    public int getScreenDeviceType() {
        return this.screenFileLocationActuator.intValue();
    }

    public int getDataDeviceType() {
        return this.dataFileLocationActuator.intValue();
    }

    public boolean isAutonameScreenFileUser() {
        return this.screenAutoFileName.intValue() == 0;
    }

    public boolean isAutonameDataFileUser() {
        return this.dataAutoFileName.intValue() == 0;
    }

    public ListActuator getScreenAutoNameFile() {
        return this.screenAutoFileName;
    }

    public ListActuator getDataAutoNameFile() {
        return this.dataAutoFileName;
    }

    public ListActuator getScreenFileLocation() {
        return this.screenFileLocation;
    }

    public ListActuator getDataFileLocation() {
        return this.dataFileLocation;
    }

    public ListActuator getBacklightAutoDimBattery() {
        return this.backlightAutoDimBattery;
    }

    public ListActuator getBacklightAutoDimAC() {
        return this.backlightAutoDimAC;
    }

    public ListActuator getPrintSchemeActuator() {
        return this.printSchemeActuator;
    }

    public ListActuator getSaveIncludeTraceActuator() {
        return this.saveIncludeTraceActuator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        VALUE_METERS = 1;
        VALUE_FEET = 0;
    }
}

