/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.measurement;

import elgato.infrastructure.analyzer.IndexToValueMapper;
import elgato.infrastructure.measurement.PerishableMeasurement;
import elgato.infrastructure.peakSearch.ActivityFinder;
import elgato.infrastructure.peakSearch.EverestPeakFinder;
import elgato.infrastructure.peakSearch.PeakFinder;

public abstract class TraceMeasurement
extends PerishableMeasurement
implements IndexToValueMapper {
    static final long serialVersionUID = 5556608269358243090L;
    private boolean traceInverted;

    public int[] getTraceMinMax() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int[] nArray = this.getActiveTrace();
        for (int i = this.getTraceLength() - 1; i >= 0; --i) {
            int n3 = nArray[i];
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        return new int[]{n, n2};
    }

    public int getTraceLength() {
        return this.getTrace().length;
    }

    public PeakFinder createPeakFinder() {
        return new EverestPeakFinder();
    }

    public ActivityFinder createActivityFinder() {
        return null;
    }

    public int getIndexForXValue(long l) {
        long l2 = this.getTraceStartValue();
        long l3 = this.getTraceStopValue();
        long l4 = l3 - l2;
        if (l4 == 0L) {
            return 0;
        }
        long l5 = (l - l2) * (long)(this.getTraceLength() - 1);
        int n = (int)(l5 / l4);
        long l6 = l5 % l4;
        if (l6 >= l4 / 2L) {
            ++n;
        }
        return n;
    }

    public int linearizeXValue(int n) {
        return n;
    }

    public long getXValueForIndex(int n) {
        long l = this.getTraceStartValue();
        long l2 = Math.round((double)n * (double)(this.getTraceStopValue() - l) / (double)(this.getTraceLength() - 1));
        return l + l2;
    }

    public long getXValueForIndex(int n, long l, long l2, int n2) {
        long l3 = Math.round((double)n * (double)(l2 - l) / (double)(n2 - 1));
        return l + l3;
    }

    public static int[] inverted(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = -nArray[i];
        }
        return nArray2;
    }

    public boolean isTraceInverted() {
        return this.traceInverted;
    }

    public void setTraceInverted(boolean bl) {
        this.traceInverted = bl;
    }

    public long getTraceCenterValue() {
        return this.getTraceStartValue() + this.getSpan() / 2L;
    }

    public long getSpan() {
        return this.getTraceStopValue() - this.getTraceStartValue();
    }

    public abstract int[] getTrace();

    public int[] getActiveTrace() {
        return this.getTrace();
    }

    public int[] getMarkerTrace(int n) {
        return this.getTrace();
    }

    public int[] getActivityTrace() {
        return null;
    }

    public abstract long getTraceStartValue();

    public abstract long getTraceStopValue();

    public long getTraceStartValue(long l) {
        return 0L;
    }

    public long getTraceStopValue(long l) {
        return 0L;
    }

    public long getPvtRiseStopValue() {
        return 0L;
    }

    public long getPvtFallStartValue() {
        return 0L;
    }

    public abstract int getIntegerReadingValue(int var1);

    public abstract int getIntegerArrayReadingValue(int var1, int var2);

    public abstract double getDoubleReadingValue(int var1);

    public abstract long getLongReadingValue(int var1);
}

