/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.util.Resources;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.widgets.HydroBorderPainter;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class AlphaEditField
extends JComponent {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$menu$AlphaEditField == null ? (class$elgato$infrastructure$menu$AlphaEditField = AlphaEditField.class$("elgato.infrastructure.menu.AlphaEditField")) : class$elgato$infrastructure$menu$AlphaEditField).getName());
    private static final HydroBorderPainterConfig TEXTBOX_BORDER = res.getBorderConfig("textBoxBorder");
    private static final Font VALUE_FONT = res.getFont("valueFont");
    private static final Color VALUE_TEXT_COLOR = res.getColor("valueTextColor");
    private static final Font PALETTE_FONT = res.getFont("paletteFont");
    private static final HydroBorderPainterConfig PALETTE_BORDER = res.getBorderConfig("paletteBorder");
    private static final Color PALETTE_TEXT_COLOR = res.getColor("paletteTextColor");
    private static final HydroBorderPainterConfig CURSOR_BORDER = res.getBorderConfig("cursorBorder");
    private static final Color CURSOR_TEXT_COLOR = res.getColor("cursorTextColor");
    private static final Font CURSOR_FONT = res.getFont("cursorFont");
    private static final int SIDE_MARGIN = 25;
    private static final int TEXTBOX_INSET = 5;
    private static final int MINIMUM_PALETTE_VERTICAL_SPACE = 16;
    static final int DEFAULT_MAX_LENGTH = 50;
    private final StringModel buffer;
    private int maxLength = 50;
    private int cursorPosition;
    private int paletteIndex;
    private ValueChangeListener listener;
    private char[] palette;
    private Rectangle paletteBounds;
    static /* synthetic */ Class class$elgato$infrastructure$menu$AlphaEditField;

    public AlphaEditField(ValueInterface valueInterface, ValueChangeListener valueChangeListener) {
        this.buffer = new StringModel(((Object)valueInterface).toString());
        this.listener = valueChangeListener;
        this.setPalette(valueInterface.getPalette().getString().toCharArray());
        this.setBackground(Color.green);
    }

    protected void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics(CURSOR_FONT);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(PALETTE_FONT);
        graphics.setFont(VALUE_FONT);
        FontMetrics fontMetrics3 = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(25, (dimension.height - fontMetrics3.getHeight()) / 2, dimension.width - 50, fontMetrics3.getHeight() + 10);
        HydroBorderPainter.paintBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true, TEXTBOX_BORDER);
        graphics.setColor(VALUE_TEXT_COLOR);
        char[] cArray = this.buffer.toString().toCharArray();
        int n = fontMetrics.charWidth('W') + 2;
        int n2 = rectangle.y + 5 + fontMetrics3.getAscent();
        int n3 = rectangle.x + 5;
        graphics.drawChars(cArray, 0, this.cursorPosition, n3, n2);
        int n4 = n3 + fontMetrics3.charsWidth(cArray, 0, this.cursorPosition);
        int n5 = cArray.length - this.cursorPosition;
        if (n5 > 0) {
            graphics.drawChars(cArray, this.cursorPosition, n5, n4 + n, n2);
        }
        int n6 = fontMetrics2.getHeight();
        int n7 = this.palette.length - 1;
        int n8 = n7 / 2;
        int n9 = n7 - n8;
        int n10 = rectangle.y - 1 - 16;
        int n11 = dimension.height - (rectangle.y + rectangle.height) - 16;
        int n12 = Math.min(n10 / n6, n8);
        int n13 = Math.min(n11 / n6, n9);
        this.paletteBounds = new Rectangle(n4, rectangle.y - n12 * n6, n, (n12 + n13) * n6 + rectangle.height);
        HydroBorderPainter.paintBorder(graphics, this.paletteBounds.x, this.paletteBounds.y, this.paletteBounds.width, this.paletteBounds.height, false, PALETTE_BORDER);
        HydroBorderPainter.paintBorder(graphics, n4, rectangle.y, n, rectangle.height, false, CURSOR_BORDER);
        graphics.setColor(CURSOR_TEXT_COLOR);
        graphics.setFont(CURSOR_FONT);
        this.drawPaletteChar(graphics, n4, n, fontMetrics, this.paletteIndex, n2);
        graphics.setFont(PALETTE_FONT);
        graphics.setColor(PALETTE_TEXT_COLOR);
        this.drawPaletteChars(graphics, fontMetrics2, n6, n4, n, n12, rectangle.y - fontMetrics2.getDescent(), -1);
        this.drawPaletteChars(graphics, fontMetrics2, n6, n4, n, n12, rectangle.y + rectangle.height + fontMetrics2.getAscent(), 1);
    }

    private void drawPaletteChars(Graphics graphics, FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = this.paletteIndex;
        for (int i = 0; i < n4; ++i) {
            if ((n8 += n6) < 0) {
                n8 += this.palette.length;
            } else if (n8 >= this.palette.length) {
                n8 -= this.palette.length;
            }
            this.drawPaletteChar(graphics, n2, n3, fontMetrics, n8, n7);
            n7 += n6 * n;
        }
    }

    private void drawPaletteChar(Graphics graphics, int n, int n2, FontMetrics fontMetrics, int n3, int n4) {
        graphics.drawChars(this.palette, n3, 1, n + (n2 - fontMetrics.charWidth(this.palette[n3])) / 2, n4);
    }

    private void repaintPalette() {
        if (this.paletteBounds == null) {
            this.repaint();
        } else {
            this.repaint(this.paletteBounds.x, this.paletteBounds.y, this.paletteBounds.width, this.paletteBounds.height);
        }
    }

    public void setValue(String string) {
        this.buffer.setLength(0);
        this.buffer.append(string);
        this.clipBuffer();
        this.cursorToEnd();
        this.fireValueChanged();
    }

    public String getValue() {
        return this.buffer.toString();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
        this.clipBuffer();
    }

    private void clipBuffer() {
        if (this.getLength() > this.maxLength) {
            this.buffer.setLength(this.maxLength);
            if (this.cursorPosition > this.maxLength) {
                this.cursorToEnd();
            }
            this.fireValueChanged();
        }
    }

    public int getLength() {
        return this.buffer.length();
    }

    public void gotoEnd() {
        this.setCursorPosition(this.getLength());
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int n) {
        if (n < 0 || n > this.getLength()) {
            throw new IndexOutOfBoundsException("Invalid cursor position " + n);
        }
        this.cursorPosition = n;
        this.repaint();
    }

    public void cursorBack() {
        if (this.cursorPosition > 0) {
            this.setCursorPosition(this.cursorPosition - 1);
        }
    }

    public void cursorForward() {
        if (this.cursorPosition < this.getLength()) {
            this.setCursorPosition(this.cursorPosition + 1);
        }
    }

    public void cursorToEnd() {
        this.setCursorPosition(this.getLength());
    }

    public void deleteChar() {
        int n = this.getLength();
        if (this.cursorPosition < n) {
            this.buffer.deleteCharAt(this.cursorPosition);
            this.repaint();
            this.fireValueChanged();
        }
    }

    public void backspace() {
        if (this.cursorPosition > 0) {
            this.buffer.deleteCharAt(--this.cursorPosition);
            this.fireValueChanged();
            this.repaint();
        }
    }

    public char[] getPalette() {
        return this.palette;
    }

    public void setPalette(char[] cArray) {
        this.palette = cArray;
        this.repaint();
    }

    public int getPaletteIndex() {
        return this.paletteIndex;
    }

    public void setPaletteIndex(int n) {
        if (n < 0 || n >= this.palette.length) {
            throw new IndexOutOfBoundsException("Invalid palette index " + n);
        }
        this.paletteIndex = n;
        this.repaintPalette();
    }

    public void scrollPalette(int n) {
        int n2 = this.paletteIndex;
        n2 += n;
        while (n2 < 0) {
            n2 += this.palette.length;
        }
        this.setPaletteIndex(n2 %= this.palette.length);
    }

    public boolean enterChar(char c) {
        if (!this.selectChar(c)) {
            return false;
        }
        this.enter();
        return true;
    }

    public void enter() {
        if (this.getLength() < this.maxLength) {
            this.buffer.insert(this.cursorPosition++, this.palette[this.paletteIndex]);
            this.fireValueChanged();
            this.repaint();
        }
    }

    private boolean selectChar(char c) {
        for (int i = 0; i < this.palette.length; ++i) {
            if (this.palette[i] != c) continue;
            this.paletteIndex = i;
            return true;
        }
        return false;
    }

    private void fireValueChanged() {
        this.listener.valueChanged(this.buffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class StringModel {
        private final StringBuffer delegate;

        StringModel(String string) {
            this.delegate = new StringBuffer(string);
        }

        public void setLength(int n) {
            this.delegate.setLength(n);
        }

        public void deleteCharAt(int n) {
            String string = this.delegate.toString();
            int n2 = string.length();
            String string2 = string.substring(n + 1, n2);
            this.delegate.setLength(n);
            this.delegate.append(string2);
        }

        public int length() {
            return this.delegate.length();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public StringBuffer append(String string) {
            return this.delegate.append(string);
        }

        public void insert(int n, char c) {
            this.delegate.insert(n, c);
        }
    }

    static interface ValueChangeListener {
        public void valueChanged(String var1);
    }
}

