/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.AlphaEditField;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;

public class AlphaEditScreen
extends Screen
implements ScrollWheelListener,
AlphaEditField.ValueChangeListener {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$menu$AlphaEditScreen == null ? (class$elgato$infrastructure$menu$AlphaEditScreen = AlphaEditScreen.class$("elgato.infrastructure.menu.AlphaEditScreen")) : class$elgato$infrastructure$menu$AlphaEditScreen).getName());
    private static final Color TITLE_COLOR = res.getColor("titleColor");
    private static final Font TITLE_FONT = res.getFont("titleFont");
    private static final HydroBorderPainterConfig BORDER = res.getBorderConfig("border");
    public static final int EXIT_OK = 0;
    public static final int EXIT_CANCEL = 1;
    private final ValueInterface value;
    final EntryListener entryListener;
    AlphaEditField editField;
    private MenuItem secondRightMenuItem;
    private MenuItem okButton;
    private Vector alphaEditScreenExitListeners = null;
    private PushButton cancelButton;
    private boolean clearField = false;
    static /* synthetic */ Class class$elgato$infrastructure$menu$AlphaEditScreen;

    public AlphaEditScreen(ValueInterface valueInterface) {
        this(valueInterface, new ValueEntryListener(valueInterface));
    }

    public AlphaEditScreen(ValueInterface valueInterface, boolean bl) {
        this(valueInterface, new ValueEntryListener(valueInterface));
        this.clearField = bl;
    }

    public AlphaEditScreen(ValueInterface valueInterface, EntryListener entryListener) {
        this.value = valueInterface;
        this.entryListener = entryListener;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        screenManager.getLeftMenuPanel().installMenu(this.createLeftMenu());
        screenManager.getRightMenuPanel().installMenu(this.createRightMenu());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new ELabel(this.value.getLabel(), TITLE_COLOR, TITLE_FONT), "North");
        this.editField = new AlphaEditField(this.value, this);
        this.editField.gotoEnd();
        if (this.clearField) {
            this.clearEditField();
        }
        jPanel.add(this.editField);
        screenManager.installDisplay(new BorderWrapper(jPanel, BORDER, true));
        ScrollWheelManager.instance().addScrollWheelListener(this);
        GlobalKeyManager.makeInstance(screenManager);
    }

    private Menu createLeftMenu() {
        return new Menu("", new MenuItem[]{this.createEnterButton(), this.createBackspaceButton(), this.createDeleteButton(), this.createLeftButton(), this.createRightButton(), this.createHomeButton(), this.createEndButton()});
    }

    private MenuItem createEnterButton() {
        return new PushButton(Text.Enter, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.editField.enter();
            }
        });
    }

    private MenuItem createBackspaceButton() {
        return new PushButton(Text.Backspace, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.editField.backspace();
            }
        });
    }

    private MenuItem createDeleteButton() {
        return new PushButton(Text.Delete, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.editField.deleteChar();
            }
        });
    }

    private MenuItem createLeftButton() {
        return new PushButton(Text.Left, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.editField.cursorBack();
            }
        });
    }

    private MenuItem createRightButton() {
        return new PushButton(Text.Right, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.editField.cursorForward();
            }
        });
    }

    private MenuItem createHomeButton() {
        return new PushButton(Text.Home, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.editField.setCursorPosition(0);
            }
        });
    }

    private MenuItem createEndButton() {
        return new PushButton(Text.End, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.editField.cursorToEnd();
            }
        });
    }

    private Menu createRightMenu() {
        this.okButton = this.createOKButton();
        return new Menu("", new MenuItem[]{this.okButton, this.secondRightMenuItem, null, null, null, this.createClearButton(), this.createCancelButton()});
    }

    MenuItem getOkButton() {
        return this.okButton;
    }

    public void uninstallScreen(ScreenManager screenManager) {
        ScrollWheelManager.instance().removeScrollWheelListener(this);
        super.uninstallScreen(screenManager);
    }

    private MenuItem createClearButton() {
        return new PushButton(Text.Clear, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.clearEditField();
            }
        });
    }

    public void clearEditField() {
        this.editField.setValue("");
    }

    private MenuItem createOKButton() {
        return new PushButton(Text.Ok, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AlphaEditScreen.this.clearField && AlphaEditScreen.this.editField.getValue().equals("")) {
                    AlphaEditScreen.this.editField.setValue("0");
                }
                AlphaEditScreen.this.getScreenManager().popScreen();
                AlphaEditScreen.this.entryListener.valueEntered(AlphaEditScreen.this.editField.getValue());
                AlphaEditScreen.this.fireAlphaEditScreenExit(0, AlphaEditScreen.this.editField.getValue());
            }
        });
    }

    private MenuItem createCancelButton() {
        this.cancelButton = new PushButton(Text.Cancel, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaEditScreen.this.getScreenManager().popScreen();
                AlphaEditScreen.this.fireAlphaEditScreenExit(1, null);
            }
        });
        return this.cancelButton;
    }

    public void setSecondRightMenuItem(MenuItem menuItem) {
        this.secondRightMenuItem = menuItem;
    }

    public MenuItem getSecondRightMenuItem() {
        return this.secondRightMenuItem;
    }

    public ValueInterface getValueObject() {
        return this.value;
    }

    public String getValue() {
        return this.editField.getValue();
    }

    public void setValue(String string) {
        this.editField.setValue(string);
    }

    public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
        this.editField.scrollPalette(scrollWheelEvent.getUnitsMoved());
        scrollWheelEvent.consume();
    }

    public void scrollWheelMoveComplete() {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 8) {
            this.editField.backspace();
            keyEvent.consume();
        } else if (n == 40) {
            this.editField.scrollPalette(1);
            keyEvent.consume();
        } else if (n == 38) {
            this.editField.scrollPalette(-1);
            keyEvent.consume();
        } else if (n == 27 || n == 76 && RuntimeConfiguration.isEmbedded()) {
            this.cancelButton.press();
            keyEvent.consume();
        } else {
            char c = keyEvent.getKeyChar();
            if (this.editField.enterChar(c)) {
                keyEvent.consume();
            }
        }
    }

    public void valueChanged(String string) {
        this.getOkButton().setEnabled(this.value.isValid(string));
    }

    void fireAlphaEditScreenExit(int n, String string) {
        if (this.alphaEditScreenExitListeners == null) {
            return;
        }
        int n2 = this.alphaEditScreenExitListeners.size();
        for (int i = 0; i < n2; ++i) {
            ((AlphaEditScreenExitListener)this.alphaEditScreenExitListeners.elementAt(i)).alphaEditScreenExit(n, string);
        }
    }

    public void addExitListener(AlphaEditScreenExitListener alphaEditScreenExitListener) {
        if (alphaEditScreenExitListener == null) {
            return;
        }
        if (this.alphaEditScreenExitListeners == null) {
            this.alphaEditScreenExitListeners = new Vector();
        }
        this.alphaEditScreenExitListeners.addElement(alphaEditScreenExitListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ValueEntryListener
    implements EntryListener {
        private ValueInterface value;

        ValueEntryListener(ValueInterface valueInterface) {
            this.value = valueInterface;
        }

        public void valueEntered(String string) {
            this.value.setValue(string);
        }
    }

    public static interface AlphaEditScreenExitListener {
        public void alphaEditScreenExit(int var1, String var2);
    }

    public static interface EntryListener {
        public void valueEntered(String var1);
    }
}

