/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.menu.PushButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class AutoscaleButton
extends PushButton
implements ActionListener {
    private final TraceAnalyzer analyzer;
    private boolean invertedScale;
    private boolean dtfMode;
    private LongActuator scaleDiv;
    private LongActuator refLevel;

    public AutoscaleButton(String string, String string2, LongActuator longActuator, LongActuator longActuator2, TraceAnalyzer traceAnalyzer, boolean bl) {
        super(string, string2);
        this.analyzer = traceAnalyzer;
        this.invertedScale = bl;
        this.addActionListener(this);
        this.refLevel = longActuator;
        this.scaleDiv = longActuator2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        int n3;
        int[] nArray = this.analyzer.getTraceMinMax();
        if (nArray == null) {
            return;
        }
        int n4 = this.dtfMode ? 55000 : nArray[1];
        int n5 = n4 - (n3 = nArray[0]);
        int n6 = n5 / (10 - (n2 = 1) - (n = this.dtfMode ? 0 : 1));
        if (n6 <= 0) {
            n6 = 1;
        }
        n6 = AutoscaleButton.thousandRoundUp(n6);
        int n7 = this.dtfMode ? AutoscaleButton.thousandRoundDown(n4) - 10 * n6 : (this.invertedScale ? AutoscaleButton.thousandRoundUp(n4) + n6 * n2 : AutoscaleButton.thousandRoundDown(n3) - n6 * n2);
        this.refLevel.send(n7);
        this.scaleDiv.send(n6);
    }

    static int thousandRoundUp(int n) {
        return AutoscaleButton.round(n, 1);
    }

    static int thousandRoundDown(int n) {
        return AutoscaleButton.round(n, -1);
    }

    private static int round(int n, int n2) {
        int n3;
        int n4 = n % 1000;
        int n5 = n3 = n < 0 ? -1 : 1;
        if (n4 == 0) {
            return n;
        }
        if (n3 != n2) {
            return n / 1000 * 1000;
        }
        return (n / 1000 + n2) * 1000;
    }

    public void setInverted(boolean bl) {
        this.invertedScale = bl;
    }

    public void setDtfMode(boolean bl) {
        this.dtfMode = bl;
    }

    public boolean isDtfMode() {
        return this.dtfMode;
    }
}

