/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.FileSelectModelGetter;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListButton;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.widgets.EListModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FileSelectButton
extends ListButton {
    private final String screenTitle;
    private AlphaEditScreen alphaEditScreen;
    private AlphaEditScreen.AlphaEditScreenExitListener exitListener = null;

    public FileSelectButton(String string, String string2, String string3, SettingsModel settingsModel, String string4, String string5) {
        this(string, string2, string3, settingsModel, string4, string5, null);
    }

    public FileSelectButton(String string, String string2, String string3, SettingsModel settingsModel, String string4, String[] stringArray) {
        this(string, string2, string3, settingsModel, string4, stringArray, null);
    }

    public FileSelectButton(String string, String string2, String string3, SettingsModel settingsModel, String string4, String string5, AlphaEditScreen.AlphaEditScreenExitListener alphaEditScreenExitListener) {
        super(string, string3, settingsModel, string4);
        this.screenTitle = string2;
        this.exitListener = alphaEditScreenExitListener;
        this.setModelGetter(this.createModelGetter(string5, null, null));
        this.setSelectionListener(new MySelectListener());
    }

    public FileSelectButton(String string, String string2, String string3, SettingsModel settingsModel, String string4, String string5, AlphaEditScreen.AlphaEditScreenExitListener alphaEditScreenExitListener, String string6) {
        super(string, string3, settingsModel, string4);
        this.screenTitle = string2;
        this.exitListener = alphaEditScreenExitListener;
        this.setModelGetter(this.createModelGetter(string5, string6, null));
        this.setSelectionListener(new MySelectListener());
    }

    public FileSelectButton(String string, String string2, String string3, SettingsModel settingsModel, String string4, String[] stringArray, AlphaEditScreen.AlphaEditScreenExitListener alphaEditScreenExitListener) {
        super(string, string3, settingsModel, string4);
        this.screenTitle = string2;
        this.exitListener = alphaEditScreenExitListener;
        this.setModelGetter(this.createModelGetter(null, null, stringArray));
        this.setSelectionListener(new MySelectListener());
    }

    private ListButton.ModelGetter createModelGetter(String string, String string2, String[] stringArray) {
        return new FileSelectModelGetter(string, string2, stringArray);
    }

    protected Screen createPopupScreen() {
        return this.createAlphaEditScreen(this.getSelectedFile());
    }

    private AlphaEditScreen createAlphaEditScreen(String string) {
        AlphaEditScreen alphaEditScreen = new AlphaEditScreen((ValueInterface)Value.createValue(this.screenTitle, string), this.makeCustomEntryListener());
        alphaEditScreen.addExitListener(this.exitListener);
        alphaEditScreen.setSecondRightMenuItem(this.createShowListButton(alphaEditScreen));
        this.alphaEditScreen = alphaEditScreen;
        return alphaEditScreen;
    }

    private MenuItem createShowListButton(final AlphaEditScreen alphaEditScreen) {
        return new PushButton(Text.Choose_n_File_dotdotdot, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FileSelectButton.this.indexOfItemInModel(alphaEditScreen.getValue());
                ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
                screenManager.pushScreen(new ListScreen(FileSelectButton.this.getModel(), n, FileSelectButton.this.selectionListener, FileSelectButton.this.screenTitle, FileSelectButton.this.cellRenderer));
            }
        });
    }

    private AlphaEditScreen.EntryListener makeCustomEntryListener() {
        return new AlphaEditScreen.EntryListener(){

            public void valueEntered(String string) {
                FileSelectButton.this.setSelectedFile(string);
            }
        };
    }

    private int indexOfItemInModel(Object object) {
        EListModel eListModel = this.getModel();
        for (int i = 0; i < eListModel.size(); ++i) {
            if (!eListModel.getItem(i).equals(object)) continue;
            return i;
        }
        return -1;
    }

    protected int getSelectedIndexFromModel() {
        return this.indexOfItemInModel(this.getSelectedFile());
    }

    private String getSelectedFile() {
        String string = this.getSettingsModel().getString(this.getSettingsModelProperty());
        return string != null ? string : "";
    }

    private void setSelectedFile(String string) {
        this.getSettingsModel().set(this.getSettingsModelProperty(), string);
    }

    protected String getSelectedItemText() {
        return this.getSelectedFile();
    }

    private class MySelectListener
    implements ItemSelectionListener {
        private MySelectListener() {
        }

        public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
            int n = itemSelectionEvent.getIndex();
            if (n != -1) {
                String string = (String)FileSelectButton.this.getModel().getItem(n);
                FileSelectButton.this.alphaEditScreen.setValue(string);
            }
        }
    }
}

