/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.menu.ListButton;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.FileSystemHelper;
import elgato.infrastructure.util.StringComparator;
import elgato.infrastructure.widgets.AbstractEListModel;
import elgato.infrastructure.widgets.EListModel;
import java.io.File;

public class FileSelectModelGetter
implements ListButton.ModelGetter {
    private final String directory;
    private final String endsWithPattern;
    private final String[] fileList;

    public FileSelectModelGetter(String string) {
        this(string, null, null);
    }

    public FileSelectModelGetter(String string, String string2) {
        this(string, string2, null);
    }

    public FileSelectModelGetter(String string, String string2, String[] stringArray) {
        this.directory = string;
        this.endsWithPattern = string2;
        this.fileList = stringArray;
    }

    public FileSelectModelGetter(String[] stringArray) {
        this(null, null, stringArray);
    }

    public EListModel getModel() {
        return new FileSelectModel(this.directory, this.endsWithPattern, this.fileList);
    }

    static class FileSelectModel
    extends AbstractEListModel {
        private String[] files;

        FileSelectModel(String string, String string2, String[] stringArray) {
            if (stringArray != null) {
                this.files = stringArray;
                Arrays.sort(this.files, new StringComparator());
            } else {
                File file = new File(string);
                if (!file.isDirectory()) {
                    this.files = new String[0];
                } else {
                    this.files = string2 != null ? file.list(new FileSystemHelper.EndsWithFilenameFilter(string2)) : file.list();
                    Arrays.sort(this.files, new StringComparator());
                }
            }
        }

        public int size() {
            return this.files.length;
        }

        public Object getItem(int n) {
            return this.files[n];
        }

        public void insertItem(int n, Object object) {
            throw new RuntimeException("Unmodifiable");
        }

        public void deleteItem(int n) {
            throw new RuntimeException("Unmodifiable");
        }
    }
}

