/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.NewItemCreator;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.EListModel;
import elgato.infrastructure.widgets.ValueField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FreqChanListScreen
extends ListScreen {
    private ValueField valueField;
    MenuItem insertButton;
    MenuItem deleteButton;
    private ValueListener changeListenerForCurrentValue = new ValueListener(){
        private final String listenerName = "FreqChanListScreen.changeListener";

        public String getListenerName() {
            return "FreqChanListScreen.changeListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            FreqChanListScreen.this.listModel.fireListDataChanged();
            EventDispatchThread.invokeLater(new Runnable(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    FreqChanListScreen.access$100(1.access$000(this.this$1));
                }
            }, "FreqChanListScreen.changeListenerForCurrentValue");
        }

        static /* synthetic */ FreqChanListScreen access$000(1 var0) {
            return var0.FreqChanListScreen.this;
        }
    };
    private NewItemCreator newItemCreator;

    public FreqChanListScreen(EListModel eListModel, int n, ItemSelectionListener itemSelectionListener, String string, NewItemCreator newItemCreator) {
        super(eListModel, n, itemSelectionListener, string, new DefaultEListCellRenderer());
        this.newItemCreator = newItemCreator;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.updateButtonStates();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        this.hideValueField();
        super.uninstallScreen(screenManager);
    }

    private void showValueField() {
        this.hideValueField();
        if (this.list.getSelectedIndex() != -1) {
            ValueInterface valueInterface = (ValueInterface)this.listModel.getItem(this.list.getSelectedIndex());
            valueInterface.setLabel(Text.Chan_Index + " " + (this.list.getSelectedIndex() + 1));
            this.valueField = new ValueField(valueInterface, this.getListenerBaseName());
            this.valueField.showField();
            valueInterface.addValueListener(this.changeListenerForCurrentValue);
        }
    }

    private void hideValueField() {
        if (this.valueField != null) {
            this.valueField.getValue().removeValueListener(this.changeListenerForCurrentValue);
            this.valueField.hideField();
            this.valueField = null;
        }
    }

    private void updateButtonStates() {
        int n = this.listModel.size();
        this.deleteButton.setEnabled(n > 1);
        this.insertButton.setEnabled(n < 40);
    }

    protected Menu makeRightMenu() {
        return new Menu("", new MenuItem[]{this.makeSelectButton(Text.Ok), this.insertButton = this.makeInsertRowButton(), this.deleteButton = this.makeDeleteRowButton(), null, null, null, this.makeCancelButton()});
    }

    protected void selectedItemChanged() {
        super.selectedItemChanged();
        this.showValueField();
    }

    private MenuItem makeInsertRowButton() {
        return new PushButton(Text.Insert_Row, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FreqChanListScreen.this.list.getSelectedIndex();
                if (n == -1) {
                    n = 0;
                }
                if (FreqChanListScreen.this.listModel.size() > 0) {
                    ++n;
                }
                FreqChanListScreen.this.listModel.insertItem(n, FreqChanListScreen.this.newItemCreator.createNewItem());
                FreqChanListScreen.this.list.select(n);
                FreqChanListScreen.this.showValueField();
                FreqChanListScreen.this.updateButtonStates();
            }
        });
    }

    private MenuItem makeDeleteRowButton() {
        return new PushButton(Text.Delete_Row, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FreqChanListScreen.this.list.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                FreqChanListScreen.this.listModel.deleteItem(n);
                FreqChanListScreen.this.list.select(n >= FreqChanListScreen.this.listModel.size() ? FreqChanListScreen.this.listModel.size() - 1 : n);
                FreqChanListScreen.this.showValueField();
                FreqChanListScreen.this.updateButtonStates();
            }
        });
    }
}

