/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.widgets.ChanStdCellRenderer;
import elgato.measurement.channelScanner.ChannelScannerFormat;
import elgato.measurement.channelScanner.ChannelScannerMeasurementSettings;
import elgato.measurement.gsm.GsmMeasurementSettings;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;

public class FrequencyChannelButtonFactory {
    public static MenuItem createChanStdSelectButton(String string, String string2) {
        return FrequencyChannelButtonFactory.makeButton(DisplayGlobalMeasurementSettings.instance().getChanStd(), string, FrequencyChannelButtonFactory.createChanStandardListener(), string2 + ".chanStdButton");
    }

    protected static ItemSelectionListener createChanStandardListener() {
        return new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                if (FrequencyChannelButtonFactory.reallyChanged(itemSelectionEvent) && FrequencyChannelButtonFactory.isChannelMode(DisplayGlobalMeasurementSettings.instance().getChanFreqUnits())) {
                    if (FrequencyChannelButtonFactory.haveSource()) {
                        SigGenMeasurementSettings.instance().getCenterFrequency().send(FrequencyChannelButtonFactory.getReverseFrequency(itemSelectionEvent));
                    }
                    SpectrumMeasurementSettings.instance().getCenterFrequency().send(FrequencyChannelButtonFactory.getForwardFrequency(itemSelectionEvent));
                }
            }
        };
    }

    public static MenuItem createChannelScannerChanStdSelectButton(String string, String string2) {
        ChannelScannerMeasurementSettings channelScannerMeasurementSettings = ChannelScannerMeasurementSettings.instance();
        ListActuator listActuator = channelScannerMeasurementSettings.getChanStd();
        ListActuatorButton listActuatorButton = FrequencyChannelButtonFactory.makeButton(listActuator, string, FrequencyChannelButtonFactory.createChannelStandardChanStandardSelectListener(), string2);
        listActuatorButton.setCellRenderer(new ChanStdCellRenderer(listActuator));
        return listActuatorButton;
    }

    protected static ItemSelectionListener createChannelStandardChanStandardSelectListener() {
        final ChannelScannerMeasurementSettings channelScannerMeasurementSettings = ChannelScannerMeasurementSettings.instance();
        return new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                if (FrequencyChannelButtonFactory.reallyChanged(itemSelectionEvent)) {
                    long l = Band.getBandChannelWidth(itemSelectionEvent.getIndex());
                    if (channelScannerMeasurementSettings.getStepSize().longValue() != l) {
                        channelScannerMeasurementSettings.getStepSize().send(l);
                    }
                    if (FrequencyChannelButtonFactory.isChannelMode(channelScannerMeasurementSettings.getFreqChanUnits())) {
                        channelScannerMeasurementSettings.getStartFreq().send(FrequencyChannelButtonFactory.getForwardFrequency(itemSelectionEvent));
                    }
                    if (channelScannerMeasurementSettings.getFormatType().getSelectedValue().intValue() == 0) {
                        FrequencyChannelButtonFactory.changeFormat(Band.getCurrentBand(itemSelectionEvent.getIndex()));
                    }
                }
            }
        };
    }

    public static MenuItem createGsmChanStdSelectButton(String string, String string2) {
        ListActuator listActuator = DisplayGlobalMeasurementSettings.instance().getChanStd();
        ListActuatorButton listActuatorButton = FrequencyChannelButtonFactory.makeButton(listActuator, string, FrequencyChannelButtonFactory.createGsmChanStandardSelectListener(), string2);
        listActuatorButton.setCellRenderer(new ChanStdCellRenderer(listActuator));
        return listActuatorButton;
    }

    protected static ItemSelectionListener createGsmChanStandardSelectListener() {
        final GsmMeasurementSettings gsmMeasurementSettings = GsmMeasurementSettings.instance();
        return new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                if (FrequencyChannelButtonFactory.reallyChanged(itemSelectionEvent)) {
                    long l = Band.getBandChannelWidth(itemSelectionEvent.getIndex());
                    if (gsmMeasurementSettings.getStepSize().longValue() != l) {
                        gsmMeasurementSettings.getStepSize().send(l);
                    }
                    gsmMeasurementSettings.getStopFreq().send(FrequencyChannelButtonFactory.getEndFwdFrequency(itemSelectionEvent));
                    gsmMeasurementSettings.getStartFreq().send(FrequencyChannelButtonFactory.getStartFwdFrequency(itemSelectionEvent));
                    gsmMeasurementSettings.getStartFreqChan().send(FrequencyChannelButtonFactory.getStartFwdFrequency(itemSelectionEvent));
                    gsmMeasurementSettings.getDecodeCf().send(FrequencyChannelButtonFactory.getStartFwdFrequency(itemSelectionEvent));
                }
            }
        };
    }

    static boolean reallyChanged(ItemSelectionEvent itemSelectionEvent) {
        return itemSelectionEvent.getOldIndex() != itemSelectionEvent.getIndex();
    }

    static void changeFormat(Band band) {
        ChannelScannerMeasurementSettings channelScannerMeasurementSettings = ChannelScannerMeasurementSettings.instance();
        ChannelScannerFormat channelScannerFormat = band.getChannelScannerFormat();
        channelScannerMeasurementSettings.getMeasBW().send(channelScannerFormat.getBandwidth());
        channelScannerMeasurementSettings.getMeasTime().send(channelScannerFormat.getTimeInterval());
        ValueInterface[] valueInterfaceArray = channelScannerMeasurementSettings.getFormatList().getValueList();
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            ValueInterface valueInterface = valueInterfaceArray[i];
            if (!valueInterface.getLongLabel().equals(channelScannerFormat.getLongLabel())) continue;
            channelScannerMeasurementSettings.getFormatList().setValue(valueInterface.intValue());
            break;
        }
    }

    static boolean haveSource() {
        return MeasurementFactory.instance().measurementAvailable("source");
    }

    private static void preloadMeasurementSettings() {
        if (FrequencyChannelButtonFactory.haveSource()) {
            SigGenMeasurementSettings.instance();
        }
        SpectrumMeasurementSettings.instance();
    }

    private static ListActuatorButton makeButton(ListActuator listActuator, String string, ItemSelectionListener itemSelectionListener, String string2) {
        FrequencyChannelButtonFactory.preloadMeasurementSettings();
        ListActuatorButton listActuatorButton = new ListActuatorButton(listActuator, string, string2);
        listActuatorButton.addItemSelectionListener(itemSelectionListener);
        return listActuatorButton;
    }

    static boolean isChannelMode(ListActuator listActuator) {
        return listActuator.intValue() == 1;
    }

    static long getReverseFrequency(ItemSelectionEvent itemSelectionEvent) {
        Band band = Band.getCurrentBand(itemSelectionEvent.getIndex());
        return band.getDefaultChannel().convertToReverse(band.getChannelRevUnitLabel()).getCenterFrequency();
    }

    static long getForwardFrequency(ItemSelectionEvent itemSelectionEvent) {
        return Band.getCurrentBand(itemSelectionEvent.getIndex()).getDefaultChannel().getCenterFrequency();
    }

    static long getLastFrequency(ItemSelectionEvent itemSelectionEvent) {
        return Band.getCurrentBand(itemSelectionEvent.getIndex()).getMaxChannel().getCenterFrequency();
    }

    static long getStartFwdFrequency(ItemSelectionEvent itemSelectionEvent) {
        return Band.getCurrentBand(itemSelectionEvent.getIndex()).getStartFwdFrequency();
    }

    static long getEndFwdFrequency(ItemSelectionEvent itemSelectionEvent) {
        return Band.getCurrentBand(itemSelectionEvent.getIndex()).getEndFwdFrequency();
    }
}

