/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.menu;

import elgato.gui.ModelTypeMgr;
import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.menu.AutoscaleButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;

public class LevelButtonFactory {
    private final Screen screen;
    private final TraceAnalyzer analyzer;
    private final boolean invertedScale;
    private boolean dtfMode;
    private LongActuator scaleDiv;
    private LongActuator refLevel;

    public LevelButtonFactory(Screen screen, TraceAnalyzer traceAnalyzer, LongActuator longActuator, LongActuator longActuator2, boolean bl) {
        this.screen = screen;
        this.analyzer = traceAnalyzer;
        this.invertedScale = bl;
        this.scaleDiv = longActuator2;
        this.refLevel = longActuator;
    }

    public MenuButton createMinimalLevelMenu() {
        if (ModelTypeMgr.instance().getModelType() == 0) {
            return new SimpleMenuButton(Text.Level_slash_n_Location, this.screen.getContextString("level"), new Menu(Text.Level, new MenuItem[]{this.createAutoscaleButton(), this.createRefLevelButton(this.refLevel), this.createScaleDivButton(this.scaleDiv), LevelButtonFactory.createGpsLocationButton(this.screen)}, 1));
        }
        return new SubMenuButton(Text.Level_slash_n_Location, this.screen.getContextString("level"), new Menu(Text.Level, new MenuItem[]{this.createAutoscaleButton(), this.createRefLevelButton(this.refLevel), this.createScaleDivButton(this.scaleDiv), LevelButtonFactory.createGpsLocationButton(this.screen)}, 1));
    }

    private MenuItem createAutoscaleButton() {
        AutoscaleButton autoscaleButton = new AutoscaleButton(Text.Autoscale, this.screen.getContextString("level.autoScale"), this.refLevel, this.scaleDiv, this.analyzer, this.invertedScale);
        autoscaleButton.setDtfMode(this.dtfMode);
        return autoscaleButton;
    }

    private MenuItem createScaleDivButton(LongActuator longActuator) {
        return new ActuatorEditor(longActuator, this.screen.getContextString("level.scaleDivision"), this.screen.getListenerBaseName() + ".scaleDivButton");
    }

    private MenuItem createRefLevelButton(LongActuator longActuator) {
        return new ActuatorEditor(longActuator, this.screen.getContextString("level.referenceLevel"), this.screen.getListenerBaseName() + ".refLevelButton");
    }

    public static MenuItem createGpsLocationButton(Screen screen) {
        return new MultiStateActuatorButton(DisplayGlobalMeasurementSettings.instance().getGpsLocationToggle(), screen.getContextString("showGpsLocation"), screen.getListenerBaseName() + ".gspLocationToggleButton");
    }

    public void setDtfMode(boolean bl) {
        this.dtfMode = bl;
    }
}

